/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs;

public class Version
implements Comparable<Version> {
    private final String versionString;
    private final int[] versionSegments;
    private final int hashCode;

    public Version(String versionString) {
        if (versionString == null || versionString.equals("")) {
            throw new IllegalArgumentException("Version string must be non-empty and non-null.");
        }
        if (versionString.startsWith(".") || versionString.endsWith(".")) {
            throw new IllegalArgumentException("Version string [] may not start or end with a period ('.').");
        }
        String[] tmpVerStringSegs = versionString.split("\\.");
        if (tmpVerStringSegs.length < 1) {
            throw new IllegalArgumentException("Version string [" + versionString + "] must have at least one numerical segment.");
        }
        int[] tmpVerSegs = new int[tmpVerStringSegs.length];
        for (int i = 0; i < tmpVerStringSegs.length; ++i) {
            try {
                tmpVerSegs[i] = Integer.parseInt(tmpVerStringSegs[i]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Version string [" + versionString + "] is not valid.", e);
            }
            if (tmpVerSegs[i] >= 0) continue;
            throw new IllegalArgumentException("Segments of version string [" + versionString + "] must all be integers greater than zero.");
        }
        this.versionString = versionString;
        this.versionSegments = tmpVerSegs;
        int tmpHashCode = 17;
        for (int i : this.versionSegments) {
            tmpHashCode = 37 * tmpHashCode + i;
        }
        this.hashCode = tmpHashCode;
    }

    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public int compareTo(Version thatVersion) {
        boolean thisNotThat;
        int[] tmpVerSegs;
        if (thatVersion == null) {
            throw new IllegalArgumentException("Version must be non-null.");
        }
        int minLength = Math.min(this.versionSegments.length, thatVersion.versionSegments.length);
        for (int i = 0; i < minLength; ++i) {
            if (this.versionSegments[i] < thatVersion.versionSegments[i]) {
                return -1;
            }
            if (this.versionSegments[i] <= thatVersion.versionSegments[i]) continue;
            return 1;
        }
        if (this.versionSegments.length == thatVersion.versionSegments.length) {
            return 0;
        }
        if (this.versionSegments.length > minLength) {
            tmpVerSegs = this.versionSegments;
            thisNotThat = true;
        } else {
            tmpVerSegs = thatVersion.versionSegments;
            thisNotThat = false;
        }
        for (int i = minLength; i < tmpVerSegs.length; ++i) {
            if (tmpVerSegs[i] <= 0) continue;
            return thisNotThat ? 1 : -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        return this.compareTo(v) == 0;
    }

    public String toString() {
        return this.versionString;
    }
}

