/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.server.wcs.Request;
import thredds.server.wcs.v1_0_0_1.WcsCoverage;
import thredds.server.wcs.v1_0_0_1.WcsDataset;
import thredds.server.wcs.v1_0_0_1.WcsException;
import thredds.server.wcs.v1_0_0_1.WcsRangeField;
import thredds.server.wcs.v1_0_0_1.WcsRequest;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class DescribeCoverage
extends WcsRequest {
    private List<String> coverages;
    private Document describeCoverageDoc;

    public DescribeCoverage(Request.Operation operation, String version, WcsDataset dataset, @Nonnull List<String> coverages) throws WcsException {
        super(operation, version, dataset);
        this.coverages = coverages;
        if (this.coverages.size() < 1) {
            throw new IllegalArgumentException("Coverage list must contain at least one ID [" + this.coverages.size() + "].");
        }
        ArrayList<String> badCovIds = new ArrayList<String>();
        for (String curCov : coverages) {
            if (this.getWcsDataset().isAvailableCoverageName(curCov)) continue;
            badCovIds.add(curCov);
        }
        if (badCovIds.size() > 0) {
            throw new WcsException("Coverage ID list contains one or more unknown IDs [" + String.valueOf(badCovIds) + "].");
        }
    }

    public Document getDescribeCoverageDoc() {
        if (this.describeCoverageDoc == null) {
            this.describeCoverageDoc = this.generateDescribeCoverageDoc();
        }
        return this.describeCoverageDoc;
    }

    public void writeDescribeCoverageDoc(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getDescribeCoverageDoc(), (Writer)pw);
    }

    public String writeDescribeCoverageDocAsString() throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        return xmlOutputter.outputString(this.getDescribeCoverageDoc());
    }

    Document generateDescribeCoverageDoc() {
        Element coverageDescriptionsElem = new Element("CoverageDescription", wcsNS);
        coverageDescriptionsElem.addNamespaceDeclaration(gmlNS);
        coverageDescriptionsElem.addNamespaceDeclaration(xlinkNS);
        coverageDescriptionsElem.setAttribute("version", this.getVersion());
        for (String curCoverageId : this.coverages) {
            coverageDescriptionsElem.addContent((Content)this.genCoverageOfferingElem(curCoverageId));
        }
        return new Document(coverageDescriptionsElem);
    }

    public Element genCoverageOfferingElem(String covId) {
        WcsCoverage coverage = this.getWcsDataset().getAvailableCoverage(covId);
        CoverageCoordSys gridCoordSystem = coverage.getCoordinateSystem();
        Element covDescripElem = this.genCoverageOfferingBriefElem("CoverageOffering", covId, coverage.getLabel(), coverage.getDescription(), gridCoordSystem);
        covDescripElem.addContent((Content)this.genDomainSetElem(coverage));
        covDescripElem.addContent((Content)this.genRangeSetElem(coverage));
        covDescripElem.addContent((Content)this.genSupportedCRSsElem(coverage));
        covDescripElem.addContent((Content)this.genSupportedFormatsElem(coverage));
        covDescripElem.addContent((Content)this.genSupportedInterpolationsElem());
        return covDescripElem;
    }

    private Element genDomainSetElem(WcsCoverage coverage) {
        Element domainSetElem = new Element("domainSet", wcsNS);
        domainSetElem.addContent((Content)this.genSpatialDomainElem(coverage));
        CoverageCoordAxis1D timeCoord = (CoverageCoordAxis1D)coverage.getCoordinateSystem().getTimeAxis();
        if (timeCoord != null) {
            domainSetElem.addContent((Content)this.genTemporalDomainElem(timeCoord));
        }
        return domainSetElem;
    }

    private Element genSpatialDomainElem(WcsCoverage coverage) {
        Element spatialDomainElem = new Element("spatialDomain", wcsNS);
        spatialDomainElem.addContent((Content)this.genEnvelopeElem(coverage.getCoordinateSystem()));
        spatialDomainElem.addContent((Content)this.genRectifiedGridElem(coverage));
        return spatialDomainElem;
    }

    private Element genRectifiedGridElem(WcsCoverage coverage) {
        Element rectifiedGridElem = new Element("RectifiedGrid", gmlNS);
        CoverageCoordAxis1D xaxis = (CoverageCoordAxis1D)coverage.getCoordinateSystem().getXAxis();
        CoverageCoordAxis1D yaxis = (CoverageCoordAxis1D)coverage.getCoordinateSystem().getYAxis();
        CoverageCoordAxis1D zaxis = (CoverageCoordAxis1D)coverage.getCoordinateSystem().getZAxis();
        rectifiedGridElem.setAttribute("srsName", coverage.getNativeCrs());
        int ndim = zaxis != null ? 3 : 2;
        rectifiedGridElem.setAttribute("dimension", Integer.toString(ndim));
        int[] minValues = new int[ndim];
        int[] maxValues = new int[ndim];
        maxValues[0] = xaxis.getNcoords() - 1;
        maxValues[1] = yaxis.getNcoords() - 1;
        if (zaxis != null) {
            maxValues[2] = zaxis.getNcoords() - 1;
        }
        Element limitsElem = new Element("limits", gmlNS);
        limitsElem.addContent((Content)new Element("GridEnvelope", gmlNS).addContent((Content)new Element("low", gmlNS).addContent(this.genIntegerListString(minValues))).addContent((Content)new Element("high", gmlNS).addContent(this.genIntegerListString(maxValues))));
        rectifiedGridElem.addContent((Content)limitsElem);
        rectifiedGridElem.addContent((Content)new Element("axisName", gmlNS).addContent("x"));
        rectifiedGridElem.addContent((Content)new Element("axisName", gmlNS).addContent("y"));
        if (zaxis != null) {
            rectifiedGridElem.addContent((Content)new Element("axisName", gmlNS).addContent("z"));
        }
        double[] origin = new double[ndim];
        origin[0] = xaxis.getCoordMidpoint(0);
        origin[1] = yaxis.getCoordMidpoint(0);
        if (zaxis != null) {
            origin[2] = zaxis.getCoordMidpoint(0);
        }
        rectifiedGridElem.addContent((Content)new Element("origin", gmlNS).addContent((Content)new Element("pos", gmlNS).addContent(this.genDoubleListString(origin))));
        double[] xoffset = new double[ndim];
        xoffset[0] = xaxis.getResolution();
        rectifiedGridElem.addContent((Content)new Element("offsetVector", gmlNS).addContent(this.genDoubleListString(xoffset)));
        double[] yoffset = new double[ndim];
        yoffset[1] = yaxis.getResolution();
        rectifiedGridElem.addContent((Content)new Element("offsetVector", gmlNS).addContent(this.genDoubleListString(yoffset)));
        if (zaxis != null) {
            double[] zoffset = new double[ndim];
            zoffset[2] = zaxis.getResolution();
            rectifiedGridElem.addContent((Content)new Element("offsetVector", gmlNS).addContent(this.genDoubleListString(zoffset)));
        }
        return rectifiedGridElem;
    }

    private String genIntegerListString(int[] values) {
        StringBuilder buf = new StringBuilder();
        for (int intValue : values) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(intValue);
        }
        return buf.toString();
    }

    private String genDoubleListString(double[] values) {
        StringBuilder buf = new StringBuilder();
        for (double doubleValue : values) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(doubleValue);
        }
        return buf.toString();
    }

    private Element genEnvelopeElem(CoverageCoordSys gcs) {
        CoverageCoordAxis timeCoord = gcs.getTimeAxis();
        Element envelopeElem = timeCoord != null ? new Element("EnvelopeWithTimePeriod", wcsNS) : new Element("Envelope", wcsNS);
        envelopeElem.setAttribute("srsName", "urn:ogc:def:crs:OGC:1.3:CRS84");
        LatLonRect llbb = this.wcsDataset.getDataset().getLatlonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        double lon = llpt.getLongitude() + llbb.getWidth();
        int posDim = 2;
        String firstPosition = llpt.getLongitude() + " " + llpt.getLatitude();
        String secondPosition = lon + " " + urpt.getLatitude();
        String posDimString = Integer.toString(posDim);
        envelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(firstPosition).setAttribute(new Attribute("dimension", posDimString)));
        envelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(secondPosition).setAttribute(new Attribute("dimension", posDimString)));
        if (timeCoord != null) {
            CalendarDateRange dateRange = timeCoord.getDateRange();
            envelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(dateRange.getStart().toString()));
            envelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(dateRange.getEnd().toString()));
        }
        return envelopeElem;
    }

    private Element genTemporalDomainElem(CoverageCoordAxis1D timeAxis) {
        Element temporalDomainElem = new Element("temporalDomain", wcsNS);
        for (int i = 0; i < timeAxis.getNcoords(); ++i) {
            double val = timeAxis.getCoordMidpoint(i);
            temporalDomainElem.addContent((Content)new Element("timePosition", gmlNS).addContent(timeAxis.makeDate(val).toString()));
        }
        return temporalDomainElem;
    }

    private Element genRangeSetElem(WcsCoverage coverage) {
        WcsRangeField rangeField = coverage.getRangeField();
        Element rangeSetElem = new Element("rangeSet", wcsNS);
        Element innerRangeSetElem = new Element("RangeSet", wcsNS);
        if (rangeField.getDescription() != null) {
            innerRangeSetElem.addContent((Content)new Element("description").addContent(rangeField.getDescription()));
        }
        innerRangeSetElem.addContent((Content)new Element("name", wcsNS).addContent(rangeField.getName()));
        innerRangeSetElem.addContent((Content)new Element("label", wcsNS).addContent(rangeField.getLabel()));
        WcsRangeField.Axis vertAxis = rangeField.getAxis();
        if (vertAxis != null) {
            Element axisDescElem = new Element("axisDescription", wcsNS);
            Element innerAxisDescElem = new Element("AxisDescription", wcsNS);
            innerAxisDescElem.addContent((Content)new Element("name", wcsNS).addContent(vertAxis.getName()));
            innerAxisDescElem.addContent((Content)new Element("label", wcsNS).addContent(vertAxis.getLabel()));
            Element valuesElem = new Element("values", wcsNS);
            for (String curVal : vertAxis.getValues()) {
                valuesElem.addContent((Content)new Element("singleValue", wcsNS).addContent(curVal));
            }
            innerAxisDescElem.addContent((Content)valuesElem);
            axisDescElem.addContent((Content)innerAxisDescElem);
            innerRangeSetElem.addContent((Content)axisDescElem);
        }
        if (coverage.hasMissingData()) {
            innerRangeSetElem.addContent((Content)new Element("nullValues", wcsNS).addContent((Content)new Element("singleValue", wcsNS).addContent("NaN")));
        }
        return rangeSetElem.addContent((Content)innerRangeSetElem);
    }

    private Element genSupportedCRSsElem(WcsCoverage coverage) {
        Element supportedCRSsElem = new Element("supportedCRSs", wcsNS);
        supportedCRSsElem.addContent((Content)new Element("requestCRSs", wcsNS).addContent(coverage.getDefaultRequestCrs()));
        supportedCRSsElem.addContent((Content)new Element("responseCRSs", wcsNS).addContent(coverage.getNativeCrs()));
        return supportedCRSsElem;
    }

    private Element genSupportedFormatsElem(WcsCoverage coverage) {
        Element supportedFormatsElem = new Element("supportedFormats", wcsNS);
        for (Request.Format curFormat : coverage.getSupportedCoverageFormatList()) {
            supportedFormatsElem.addContent((Content)new Element("formats", wcsNS).addContent(curFormat.toString()));
        }
        return supportedFormatsElem;
    }

    private Element genSupportedInterpolationsElem() {
        Element supportedInterpolationsElem = new Element("supportedInterpolations", wcsNS);
        supportedInterpolationsElem.addContent((Content)new Element("interpolationMethod", wcsNS).addContent("none"));
        return supportedInterpolationsElem;
    }
}

