/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.jplQuikSCAT;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JplQuikScatCalendar {
    private static Logger log = LoggerFactory.getLogger(JplQuikScatCalendar.class);
    protected Date epochStartDate = null;
    protected String epochStartDateTimeString = null;
    protected String epochStartDateTimeStringDefault = "1970-01-01T00:00:00.000GMT";
    protected String isoDateTimeStringFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    protected String isoDateStringFormat = "yyyy-MM-dd";
    protected Calendar calendar = null;

    public JplQuikScatCalendar(String epochStartDateTimeString) {
        String tmpMsg = null;
        if (epochStartDateTimeString == null) {
            tmpMsg = "JplQuikScatCalendar(): given date/time string was null.";
            log.debug(tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        this.epochStartDateTimeString = epochStartDateTimeString;
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        try {
            this.epochStartDate = this.getDateFromIsoDateTimeString(this.epochStartDateTimeString);
        }
        catch (ParseException e) {
            tmpMsg = "JplQuikScatCalendar(): could not parse date/time string <" + this.epochStartDateTimeString + "> " + "with the ISO date/time format <" + this.isoDateTimeStringFormat + ">.";
            log.debug(tmpMsg);
            throw (IllegalArgumentException)new IllegalArgumentException(tmpMsg).initCause(e);
        }
    }

    public Date getEpochStartDate() {
        return this.epochStartDate;
    }

    public String getEpochStartDateString() {
        return this.getIsoDateStringFromDate(this.epochStartDate);
    }

    public String getEpochStartDateTimeString() {
        return this.getIsoDateTimeStringFromDate(this.epochStartDate);
    }

    public Date getDateFromIsoDateTimeString(String isoDateString) throws ParseException {
        Date theDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.isoDateTimeStringFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        theDate = dateFormat.parse(isoDateString);
        return theDate;
    }

    public String getIsoDateTimeStringFromDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.isoDateTimeStringFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateString = dateFormat.format(date);
        return dateString;
    }

    public Date getDateFromIsoDateString(String isoDateString) throws ParseException {
        Date theDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.isoDateStringFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        theDate = dateFormat.parse(isoDateString);
        return theDate;
    }

    public String getIsoDateStringFromDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.isoDateStringFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateString = dateFormat.format(date);
        return dateString;
    }

    public Date getDateFromSecondsSinceEpoch(double secSinceEpoch) {
        this.calendar.clear();
        this.calendar.setTimeInMillis(this.epochStartDate.getTime() + (long)(secSinceEpoch * 1000.0));
        return this.calendar.getTime();
    }

    public double getSecondsSinceEpochFromDate(Date theDate) {
        double secSinceEpoch = (double)(theDate.getTime() - this.epochStartDate.getTime()) / 1000.0;
        return secSinceEpoch;
    }
}

