/*
 * Decompiled with CFR 0.152.
 */
package thredds.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.TdsServletResponseWrapper;
import thredds.servlet.UsageLog;

public class RequestBracketingLogMessageFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        TdsServletResponseWrapper response = new TdsServletResponseWrapper((HttpServletResponse)servletResponse);
        request.getServletPath();
        if (response.isCommitted()) {
            this.log.error("doFilter(): Yikes! Response is already committed (Heiko's bug?).");
        }
        this.log.info(UsageLog.setupRequestContext(request));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        this.log.info(UsageLog.closingMessageForRequestContext(response.getHttpStatusCode(), response.getHttpResponseBodyLength()));
    }
}

