/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cataloggen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.cataloggen.CatGenConfig;
import thredds.server.cataloggen.CatGenConfigParser;
import thredds.server.cataloggen.CatGenTaskConfig;
import thredds.server.cataloggen.CatGenTaskScheduler;
import thredds.server.config.TdsContext;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;
import thredds.util.RequestForwardUtils;

public class CatGenController
extends AbstractController {
    private static Logger log = LoggerFactory.getLogger(CatGenController.class);
    private Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private TdsContext tdsContext;
    private boolean allow;
    private String catGenConfigDirName;
    private File catGenConfigDir;
    private String catGenConfigFileName;
    private File catGenConfigFile;
    private String catGenResultsDirName;
    private File catGenResultsDir;
    private CatGenConfig catGenConfig;
    private CatGenConfigParser catGenConfigParser;
    private CatGenTaskScheduler scheduler;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setCatGenConfigDirName(String catGenConfigDirName) {
        this.catGenConfigDirName = catGenConfigDirName;
    }

    public void setCatGenConfigFileName(String catGenConfigFileName) {
        this.catGenConfigFileName = catGenConfigFileName;
    }

    public void setCatGenResultsDirName(String catGenResultsDirName) {
        this.catGenResultsDirName = catGenResultsDirName;
    }

    public void init() {
        this.logServerStartup.info("CatalogGen - initialize start - " + UsageLog.setupNonRequestContext());
        this.allow = ThreddsConfig.getBoolean("CatalogGen.allow", false);
        if (!this.allow) {
            this.logServerStartup.info("CatalogGen not enabled in threddsConfig.xml - " + UsageLog.closingMessageNonRequestContext());
            return;
        }
        if (this.tdsContext == null) {
            this.allow = false;
            this.logServerStartup.error("CatalogGen - Disabling service - null TdsContext - " + UsageLog.closingMessageNonRequestContext());
            return;
        }
        this.catGenConfigDir = this.tdsContext.getConfigFileSource().getFile(this.catGenConfigDirName);
        if (this.catGenConfigDir == null) {
            this.catGenConfigDir = this.createCatGenConfigDirectory();
            if (this.catGenConfigDir == null) {
                this.allow = false;
                this.logServerStartup.error("CatalogGen - Disabling service - could not locate or create CatGenConfig directory - " + UsageLog.closingMessageNonRequestContext());
                return;
            }
        }
        this.catGenConfigFile = new File(this.catGenConfigDir, this.catGenConfigFileName);
        if (!this.catGenConfigFile.exists()) {
            this.catGenConfigFile = this.createCatGenConfigFile();
            if (this.catGenConfigFile == null) {
                this.allow = false;
                this.logServerStartup.error("CatalogGen - Disabling service - could not locate or create CatGenConfig file - " + UsageLog.closingMessageNonRequestContext());
                return;
            }
        }
        this.catGenResultsDir = this.tdsContext.getConfigFileSource().getFile(this.catGenResultsDirName);
        if (this.catGenResultsDir == null) {
            this.catGenResultsDir = this.createCatGenResultsDirectory();
            if (this.catGenResultsDir == null) {
                this.logServerStartup.warn("CatalogGen - Could not locate or create CatGenResults directory - MAY cause problems when writing results.");
            }
        }
        this.logServerStartup.debug("CatalogGen - config directory  = " + this.catGenConfigDir.toString());
        this.logServerStartup.debug("CatalogGen - config file       = " + this.catGenConfigFile.toString());
        this.logServerStartup.debug("CatalogGen - results directory = " + this.catGenResultsDir.toString());
        this.catGenConfigParser = new CatGenConfigParser();
        try {
            this.catGenConfig = this.catGenConfigParser.parseXML(this.catGenConfigFile);
        }
        catch (IOException e) {
            this.logServerStartup.error("CatalogGen - Disabling service - failed to parse CatGenConfig file - " + UsageLog.closingMessageNonRequestContext() + " - " + e.getMessage());
            this.allow = false;
            return;
        }
        for (CatGenTaskConfig curTask : this.catGenConfig.getTaskInfoList()) {
            String curTaskResultFileName = curTask.getResultFileName();
            if (!curTaskResultFileName.startsWith("/")) continue;
            curTaskResultFileName.substring(1);
            File curResultFileParentDir = new File(this.tdsContext.getContentDirectory(), curTaskResultFileName).getParentFile();
            if (curResultFileParentDir.exists() || curResultFileParentDir.mkdirs()) continue;
            this.logServerStartup.warn("CatalogGen - Dropping \"" + curTask.getName() + "\" CatGenConfig Task: Non-existent results directory [" + curResultFileParentDir + "] couldn't be created.");
        }
        if (!this.catGenConfig.getTaskInfoList().isEmpty()) {
            this.scheduler = new CatGenTaskScheduler(this.catGenConfig, this.catGenConfigDir, this.catGenResultsDir, this.tdsContext.getContentDirectory());
            this.scheduler.start();
        }
        this.logServerStartup.info("CatalogGen - initialize done -  " + UsageLog.closingMessageNonRequestContext());
    }

    public void destroy() {
        this.logServerStartup.info("CatalogGen - destroy start - " + UsageLog.setupNonRequestContext());
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.logServerStartup.info("CatalogGen - destroy done - " + UsageLog.closingMessageNonRequestContext());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(request));
        if (!this.allow) {
            String msg = "CatalogGen service not supported.";
            log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(403, msg.length()));
            response.sendError(403, msg);
            return null;
        }
        String reqPath = request.getPathInfo();
        if (reqPath.equals("/")) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("contextPath", request.getContextPath());
            model.put("servletPath", request.getServletPath());
            model.put("catGenConfig", this.catGenConfig);
            model.put("catGenResultsDirName", this.catGenResultsDirName);
            this.tdsContext.getHtmlConfig().addHtmlConfigInfoToModel(model);
            log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, -1L));
            return new ModelAndView("/thredds/server/cataloggen/catGenConfig", model);
        }
        String extendedPath = request.getServletPath() + reqPath;
        if (extendedPath.startsWith("/" + this.catGenResultsDirName + "/")) {
            String fwdPath = "/catalog" + extendedPath;
            RequestForwardUtils.forwardRequestRelativeToCurrentContext(fwdPath, request, response);
            return null;
        }
        return new ModelAndView("editTask", "config", (Object)"junk");
    }

    private File createCatGenConfigDirectory() {
        File configDir = new File(this.tdsContext.getContentDirectory(), this.catGenConfigDirName);
        if (configDir.exists()) {
            log.error("createCatGenConfigDirectory(): Existing CatGenConfigDir [" + configDir + "] not found in TdsContext ConfigFileSource, check TdsContext config.");
            return null;
        }
        if (!configDir.mkdirs()) {
            log.error("createCatGenConfigDirectory(): Failed to create CatGenConfig directory.");
            return null;
        }
        if (!configDir.equals(this.tdsContext.getConfigFileSource().getFile(this.catGenConfigDirName))) {
            log.error("createCatGenConfigDirectory(): Newly created CatGenConfig directory not found by TdsContext ConfigFileSource.");
            return null;
        }
        return configDir;
    }

    private File createCatGenResultsDirectory() {
        File dir = new File(this.tdsContext.getContentDirectory(), this.catGenResultsDirName);
        if (dir.exists()) {
            log.error("createCatGenResultsDirectory(): Existing CatGenResultsDir [" + dir + "] not found in TdsContext ConfigFileSource, check TdsContext config.");
            return null;
        }
        if (!dir.mkdirs()) {
            log.error("createCatGenResultsDirectory(): Failed to create CatGenResults directory.");
            return null;
        }
        if (!dir.equals(this.tdsContext.getConfigFileSource().getFile(this.catGenResultsDirName))) {
            log.error("createCatGenResultsDirectory(): Newly created CatGenResults directory not found by TdsContext ConfigFileSource.");
            return null;
        }
        return dir;
    }

    private File createCatGenConfigFile() {
        File configFile = new File(this.catGenConfigDir, this.catGenConfigFileName);
        if (configFile.exists()) {
            log.error("createCatGenConfigFile(): Existing catGenConfigFile [" + configFile + "] not found in TdsContext ConfigFileSource, check TdsContext config.");
            return null;
        }
        boolean created = false;
        try {
            created = configFile.createNewFile();
        }
        catch (IOException e) {
            log.error("createCatGenConfigFile(): I/O error while creating CatGenConfig file.");
            return null;
        }
        if (!created) {
            log.error("createCatGenConfigFile(): Failed to create CatGEnConfig file.");
            return null;
        }
        if (!this.writeEmptyConfigDocToFile(configFile)) {
            log.error("createCatGenConfigFile(): Failed to write empty config file [" + configFile + "].");
            return null;
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeEmptyConfigDocToFile(File configFile) {
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            fos = new FileOutputStream(configFile);
            writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            writer.append(this.genEmptyConfigDocAsString());
            writer.flush();
        }
        catch (IOException e) {
            log.debug("writeEmptyConfigDocToFile(): IO error writing blank config file: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.debug("writeEmptyConfigDocToFile(): IO error closing just written blank config file: " + e.getMessage());
                return true;
            }
        }
        return true;
    }

    private String genEmptyConfigDocAsString() {
        StringBuilder sb = new StringBuilder().append("<?xml version='1.0' encoding='UTF-8'?>\n").append("<preferences EXTERNAL_XML_VERSION='1.0'>\n").append("  <root type='user'>\n").append("    <map>\n").append("      <beanCollection key='config' class='thredds.cataloggen.servlet.CatGenTimerTask'>\n").append("      </beanCollection>\n").append("    </map>\n").append("  </root>\n").append("</preferences>");
        return sb.toString();
    }
}

