/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cataloggen;

import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatGenTaskConfig {
    private static Logger log = LoggerFactory.getLogger(CatGenTaskConfig.class);
    private final String name;
    private final String configDocName;
    private final String resultFileName;
    private final int periodInMinutes;
    private final int delayInMinutes;
    private File configDoc = null;
    private URL configDocURL = null;
    private File resultFile = null;

    CatGenTaskConfig(String name, String configDocName, String resultFileName, int periodInMinutes, int delayInMinutes) {
        if (name == null || name.equals("")) {
            log.error("ctor(): The name cannot be null or empty string.");
            throw new IllegalArgumentException("The name cannot be null or empty string.");
        }
        if (configDocName == null || configDocName.equals("")) {
            log.error("ctor(): The config doc name cannot be null or empty string.");
            throw new IllegalArgumentException("The config doc name cannot be null or empty string.");
        }
        if (resultFileName == null || resultFileName.equals("")) {
            log.error("ctor(): The result file name cannot be null or empty string.");
            throw new IllegalArgumentException("The result file name cannot be null or empty string.");
        }
        this.name = name;
        this.configDocName = configDocName;
        this.resultFileName = resultFileName;
        this.periodInMinutes = periodInMinutes;
        this.delayInMinutes = delayInMinutes;
    }

    CatGenTaskConfig(CatGenTaskConfig taskConfig) {
        this.name = taskConfig.name;
        this.configDocName = taskConfig.configDocName;
        this.resultFileName = taskConfig.resultFileName;
        this.periodInMinutes = taskConfig.periodInMinutes;
        this.delayInMinutes = taskConfig.delayInMinutes;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigDocName() {
        return this.configDocName;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public int getPeriodInMinutes() {
        return this.periodInMinutes;
    }

    public int getDelayInMinutes() {
        return this.delayInMinutes;
    }
}

