/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.DataBinder;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.LocalCatalogRequest;
import thredds.util.TdsPathUtils;

public class LocalCatalogRequestDataBinder
extends DataBinder {
    private String suffixForDirPath = "catalog.html";

    public LocalCatalogRequestDataBinder(LocalCatalogRequest target, String requestObjectName) {
        super((Object)target, requestObjectName);
    }

    public void bind(HttpServletRequest req) {
        String catPath = TdsPathUtils.extractPath(req);
        String command = req.getParameter(FieldInfo.COMMAND.getParameterName());
        String dataset = req.getParameter(FieldInfo.DATASET.getParameterName());
        MutablePropertyValues values = new MutablePropertyValues();
        if (catPath == null) {
            catPath = FieldInfo.CATALOG.getDefaultValue();
        } else if (catPath.endsWith("/") || catPath.equals("")) {
            catPath = catPath + this.suffixForDirPath;
        }
        if (dataset == null) {
            dataset = FieldInfo.DATASET.getDefaultValue();
        }
        if (command == null) {
            command = dataset.equals(FieldInfo.DATASET.getDefaultValue()) ? Command.SHOW.name() : Command.SUBSET.name();
        }
        values.addPropertyValue(FieldInfo.CATALOG.getPropertyName(), (Object)catPath);
        values.addPropertyValue(FieldInfo.COMMAND.getPropertyName(), (Object)command);
        values.addPropertyValue(FieldInfo.DATASET.getPropertyName(), (Object)dataset);
        super.bind((PropertyValues)values);
    }

    private static enum FieldInfo {
        CATALOG("catalog", "path", ""),
        COMMAND("command", "command", ""),
        DATASET("dataset", "dataset", "");

        private String parameterName;
        private String propertyName;
        private String defaultValue;

        private FieldInfo(String parameterName, String propertyName, String defaultValue) {
            this.parameterName = parameterName;
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

