/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.HtmlUtils;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.util.DeepCopyUtils;
import thredds.server.catalogservice.CatalogServiceUtils;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsContext;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;

public class RemoteCatalogServiceController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;
    private HtmlConfig htmlConfig;
    private HtmlWriter htmlWriter;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
        if (this.tdsContext != null) {
            this.htmlConfig = this.tdsContext.getHtmlConfig();
        }
    }

    public void setHtmlWriter(HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.log.info(UsageLog.setupRequestContext(request));
            boolean allowRemote = ThreddsConfig.getBoolean("CatalogServices.allowRemote", false);
            if (!allowRemote) {
                this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(403, -1L));
                response.sendError(403, "Catalog services not supported for remote catalogs.");
                return null;
            }
            if (request.getServletPath().equals("/remoteCatalogValidation.html")) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                this.htmlConfig.addHtmlConfigInfoToModel(model);
                this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(200, -1L));
                return new ModelAndView("/thredds/server/catalogservice/validationForm", model);
            }
            BindingResult bindingResult = CatalogServiceUtils.bindAndValidateRemoteCatalogRequest(request);
            if (bindingResult.hasErrors()) {
                StringBuilder msg = new StringBuilder("Bad request");
                List oeList = bindingResult.getAllErrors();
                for (ObjectError e : oeList) {
                    msg.append(": ").append(e.getDefaultMessage() != null ? e.getDefaultMessage() : e.toString());
                }
                this.log.info("handleRequestInternal(): " + msg);
                this.log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                response.sendError(400, msg.toString());
                return null;
            }
            RemoteCatalogRequest catalogServiceRequest = (RemoteCatalogRequest)bindingResult.getTarget();
            URI uri = catalogServiceRequest.getCatalogUri();
            InvCatalogImpl catalog = null;
            InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)true);
            try {
                catalog = fac.readXML(uri);
            }
            catch (Throwable t) {
                String msg = "Error reading catalog [" + uri + "]: " + t.getMessage();
                this.log.error("handleRequestInternal(): " + msg);
                this.log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                response.sendError(400, msg.toString());
                return null;
            }
            if (catalog == null) {
                String msg = "Failed to read catalog [" + uri + "].";
                this.log.error("handleRequestInternal(): " + msg);
                this.log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                response.sendError(400, msg.toString());
                return null;
            }
            StringBuilder validateMess = new StringBuilder();
            boolean verbose = catalogServiceRequest.isVerbose();
            catalog.check(validateMess, verbose);
            if (catalog.hasFatalError()) {
                response.setHeader("Validate", "FAIL");
                return CatalogServiceUtils.constructValidationErrorModelAndView(uri, validateMess.toString(), this.htmlConfig);
            }
            response.setHeader("Validate", "OK");
            if (catalogServiceRequest.getCommand().equals((Object)Command.SHOW)) {
                int i = this.htmlWriter.writeCatalog(request, response, catalog, false);
                this.log.info(UsageLog.closingMessageForRequestContext(200, i));
                return null;
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SUBSET)) {
                String datasetId = catalogServiceRequest.getDataset();
                InvDataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + HtmlUtils.htmlEscape((String)datasetId) + "] in catalog [" + uri + "].";
                    this.log.info("handleRequestInternal(): " + msg);
                    this.log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
                    response.sendError(400, msg.toString());
                    return null;
                }
                if (catalogServiceRequest.isHtmlView()) {
                    int i = this.htmlWriter.showDataset(uri.toString(), (InvDatasetImpl)dataset, request, response, false);
                    this.log.info(UsageLog.closingMessageForRequestContext(200, i));
                    return null;
                }
                InvCatalog subsetCat = DeepCopyUtils.subsetCatalogOnDataset((InvCatalog)catalog, (InvDataset)dataset);
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.VALIDATE)) {
                return CatalogServiceUtils.constructValidationMessageModelAndView(uri, validateMess.toString(), this.htmlConfig);
            }
            String msg = "Unsupported request command [" + (Object)((Object)catalogServiceRequest.getCommand()) + "].";
            this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
            this.log.info(UsageLog.closingMessageForRequestContext(400, msg.length()));
            response.sendError(400, msg.toString());
            return null;
        }
        catch (IOException e) {
            this.log.error("handleRequestInternal(): Trouble writing to response.", (Throwable)e);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, -1L));
            return null;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(400, -1L));
            if (!response.isCommitted()) {
                response.sendError(500);
            }
            return null;
        }
    }
}

