/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmvalidator;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;
import thredds.util.filesource.BasicDescendantFileSource;
import thredds.util.filesource.FileSource;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;

public class CdmValidatorContext {
    private static Logger log = LoggerFactory.getLogger(TdsContext.class);
    private String webappName;
    private String webappVersion;
    private String webappVersionBrief;
    private String webappVersionBuildDate;
    private String contextPath;
    private String contentRootPath;
    private String contentPath;
    private File rootDirectory;
    private File contentDirectory;
    private FileSource configSource;
    private String configFileName;
    private HtmlConfig htmlConfig;
    private RequestDispatcher defaultRequestDispatcher;
    private RequestDispatcher jspRequestDispatcher;
    private DiskCache2 cdmValidateCache = null;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private DiskFileItemFactory fileuploadFileItemFactory;
    private File cacheDir;
    private long maxFileUploadSize;
    private boolean deleteImmediately = true;

    public void setContentRootPath(String contentRootPath) {
        this.contentRootPath = contentRootPath;
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    public void setConfigFileName(String filename) {
        this.configFileName = filename;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void init(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException("ServletContext must not be null.");
        }
        ServletUtil.initDebugging(servletContext);
        this.webappName = servletContext.getServletContextName();
        String tmpContextPath = servletContext.getInitParameter("ContextPath");
        if (tmpContextPath == null) {
            tmpContextPath = "cdmvalidator";
        }
        this.contextPath = "/" + tmpContextPath;
        ServletUtil.setContextPath(this.contextPath);
        if (this.webappVersion != null && !this.webappVersion.startsWith(this.webappVersionBrief + ".")) {
            throw new IllegalStateException("Full version [" + this.webappVersion + "] must start with version [" + this.webappVersionBrief + "].");
        }
        String rootPath = servletContext.getRealPath("/");
        if (rootPath == null) {
            throw new IllegalStateException("Webapp [" + this.webappName + "] must run with exploded deployment directory (not from .war).");
        }
        this.rootDirectory = new File(rootPath);
        BasicDescendantFileSource rootDirSource = new BasicDescendantFileSource(this.rootDirectory);
        this.rootDirectory = rootDirSource.getRootDirectory();
        ServletUtil.setRootPath(rootDirSource.getRootDirectoryPath());
        File contentRootDir = new File(this.contentRootPath);
        if (!contentRootDir.isAbsolute()) {
            this.contentDirectory = new File(new File(this.rootDirectory, this.contentRootPath), this.contentPath);
        } else if (contentRootDir.isDirectory()) {
            this.contentDirectory = new File(contentRootDir, this.contentPath);
        } else {
            throw new IllegalStateException("Content root directory [" + this.contentRootPath + "] not a directory.");
        }
        if (!this.contentDirectory.exists() && !this.contentDirectory.mkdirs()) {
            String tmpMsg = "Content directory does not exist and could not be created";
            log.error("init(): " + tmpMsg + " [" + this.contentDirectory.getAbsolutePath() + "]");
            throw new IllegalStateException(tmpMsg);
        }
        if (!this.contentDirectory.isDirectory()) {
            String tmpMsg = "Content directory not a directory";
            log.error("init(): " + tmpMsg + " [" + this.contentDirectory.getAbsolutePath() + "]");
            throw new IllegalStateException(tmpMsg);
        }
        BasicDescendantFileSource contentDirSource = new BasicDescendantFileSource(StringUtils.cleanPath((String)this.contentDirectory.getAbsolutePath()));
        this.contentDirectory = contentDirSource.getRootDirectory();
        ServletUtil.setContentPath(contentDirSource.getRootDirectoryPath());
        File configFile = contentDirSource.getFile(this.configFileName);
        if (configFile == null) {
            configFile = new File(this.contentDirectory, this.configFileName);
            String templateConfigFilePath = "WEB-INF/altContent/" + this.configFileName;
            File templateConfigFile = rootDirSource.getFile(templateConfigFilePath);
            if (templateConfigFile == null) {
                String tmpMsg = "Non-existent template configuration file";
                log.error("init(): " + tmpMsg + " [" + templateConfigFilePath + "]");
                throw new IllegalStateException(tmpMsg);
            }
            try {
                IO.copyFile((File)templateConfigFile, (File)configFile);
            }
            catch (IOException e) {
                String tmpMsg = "Configuration file doesn't exist and could not be created";
                log.error("init(): " + tmpMsg + " [" + configFile.getAbsolutePath() + "]", (Throwable)e);
                throw new IllegalStateException(tmpMsg, e);
            }
        }
        ThreddsConfig.init(configFile.getPath());
        this.configSource = contentDirSource;
        this.jspRequestDispatcher = servletContext.getNamedDispatcher("jsp");
        this.defaultRequestDispatcher = servletContext.getNamedDispatcher("default");
        if (this.htmlConfig != null) {
            this.htmlConfig.init(this.getWebappName(), this.getWebappVersion(), this.getWebappVersionBrief(), this.getWebappVersionBuildDate(), this.getWebappContextPath());
        }
        this.initCaching();
    }

    private void initCaching() {
        this.maxFileUploadSize = ThreddsConfig.getBytes("CdmValidatorService.maxFileUploadSize", 1000000000L);
        String cacheDirPath = ThreddsConfig.get("CdmValidatorService.cache.dir", new File(this.getContentDirectory(), "/cache/cdmValidate").getPath());
        int scourSecs = ThreddsConfig.getSeconds("CdmValidatorService.cache.scour", -1);
        int maxAgeSecs = ThreddsConfig.getSeconds("CdmValidatorService.cache.maxAge", -1);
        final long maxSize = ThreddsConfig.getBytes("CdmValidatorService.cache.maxSize", 1000000000L);
        if (maxAgeSecs > 0) {
            DiskCache.setRootDirectory((String)cacheDirPath);
            DiskCache.setCachePolicy((boolean)true);
            if (!this.scheduler.isShutdown()) {
                Runnable command = new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder sb = new StringBuilder();
                        DiskCache.cleanCache((long)maxSize, (StringBuilder)sb);
                        sb.append("----------------------\n");
                        log.debug("init():Runnable:run(): Scour on ucar.nc2.util.DiskCache:\n" + sb);
                    }
                };
                this.scheduler.scheduleAtFixedRate(command, scourSecs / 2, scourSecs, TimeUnit.SECONDS);
            }
            this.deleteImmediately = false;
            this.cdmValidateCache = new DiskCache2(cacheDirPath, false, maxAgeSecs / 60, scourSecs / 60);
        }
        this.cacheDir = new File(cacheDirPath);
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            String msg = "File upload cache directory [" + this.cacheDir + "] doesn't exist and couldn't be created.";
            log.error("init(): " + msg + " - " + UsageLog.closingMessageNonRequestContext());
            throw new IllegalStateException(msg);
        }
        this.fileuploadFileItemFactory = new DiskFileItemFactory(0, this.cacheDir);
    }

    public void destroy() {
        if (this.cdmValidateCache != null) {
            this.cdmValidateCache.exit();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getWebappContextPath() {
        return this.contextPath;
    }

    public String getWebappVersion() {
        return this.webappVersion;
    }

    public void setWebappVersion(String verFull) {
        this.webappVersion = verFull;
    }

    public String getWebappVersionBrief() {
        return this.webappVersionBrief;
    }

    public void setWebappVersionBrief(String ver) {
        this.webappVersionBrief = ver;
    }

    public String getWebappVersionBuildDate() {
        return this.webappVersionBuildDate;
    }

    public void setWebappVersionBuildDate(String buildDateString) {
        this.webappVersionBuildDate = buildDateString;
    }

    public void setHtmlConfig(HtmlConfig htmlConfig) {
        this.htmlConfig = htmlConfig;
    }

    public HtmlConfig getHtmlConfig() {
        return this.htmlConfig;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getContentDirectory() {
        return this.contentDirectory;
    }

    public FileSource getConfigFileSource() {
        return this.configSource;
    }

    public RequestDispatcher getDefaultRequestDispatcher() {
        return this.defaultRequestDispatcher;
    }

    public RequestDispatcher getJspRequestDispatcher() {
        return this.jspRequestDispatcher;
    }

    public static Logger getLog() {
        return log;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public long getMaxFileUploadSize() {
        return this.maxFileUploadSize;
    }

    public boolean isDeleteImmediately() {
        return this.deleteImmediately;
    }

    public FileItemFactory getFileuploadFileItemFactory() {
        return this.fileuploadFileItemFactory;
    }
}

