/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.MController;
import thredds.inventory.bdb.MetadataManager;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileCache;

public class CdmInit {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private DiskCache2 aggCache;
    private DiskCache2 gcCache;
    private Timer timer;
    private MController cacheManager;

    void init(TdsContext tdsContext) {
        boolean extendIndex;
        ThreddsDataFactory.setPreferCdm((boolean)true);
        String fcCache = ThreddsConfig.get("FeatureCollection.dir", null);
        if (fcCache == null) {
            fcCache = ThreddsConfig.get("FeatureCollection.cacheDirectory", tdsContext.getContentDirectory().getPath() + "/cache/collection/");
        }
        long maxSizeBytes = ThreddsConfig.getBytes("FeatureCollection.maxSize", 0L);
        int jvmPercent = ThreddsConfig.getInt("FeatureCollection.jvmPercent", 2);
        try {
            MetadataManager.setCacheDirectory((String)fcCache, (long)maxSizeBytes, (int)jvmPercent);
            CollectionManagerAbstract.enableMetadataManager();
            startupLog.info("CdmInit: FeatureCollection.cacheDirectory= " + fcCache);
        }
        catch (Exception e) {
            startupLog.error("CdmInit: Failed to open FeatureCollection.cacheDirectory= " + fcCache, (Throwable)e);
        }
        boolean useBytesForDataSize = ThreddsConfig.getBoolean("catalogWriting.useBytesForDataSize", false);
        InvCatalogFactory10.useBytesForDataSize((boolean)useBytesForDataSize);
        startupLog.info("CdmInit: catalogWriting.useBytesForDataSize= " + useBytesForDataSize);
        int min = ThreddsConfig.getInt("NetcdfFileCache.minFiles", 50);
        int max = ThreddsConfig.getInt("NetcdfFileCache.maxFiles", 100);
        int secs = ThreddsConfig.getSeconds("NetcdfFileCache.scour", 600);
        if (max > 0) {
            NetcdfDataset.initNetcdfFileCache((int)min, (int)max, (int)secs);
            startupLog.info("CdmInit: NetcdfDataset.initNetcdfFileCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("GribCollection.minFiles", 100);
        max = ThreddsConfig.getInt("GribCollection.maxFiles", 200);
        secs = ThreddsConfig.getSeconds("GribCollection.scour", 900);
        if (max > 0) {
            GribCollection.initFileCache((int)min, (int)max, (int)secs);
            startupLog.info("CdmInit: GribCollection.initFileCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("HTTPFileCache.minFiles", 5);
        max = ThreddsConfig.getInt("HTTPFileCache.maxFiles", 10);
        secs = ThreddsConfig.getSeconds("HTTPFileCache.scour", 720);
        if (max > 0) {
            ServletUtil.setFileCache(new FileCache("HTTP File Cache", min, max, -1, secs));
            startupLog.info("CdmInit: HTTPFileCache.initCache= [" + min + "," + max + "] scour = " + secs);
        }
        GridServiceProvider.IndexExtendMode mode = (extendIndex = ThreddsConfig.getBoolean("GribIndexing.setExtendIndex", false)) ? GridServiceProvider.IndexExtendMode.extendwrite : GridServiceProvider.IndexExtendMode.readonly;
        GridServiceProvider.setIndexFileModeOnOpen((GridServiceProvider.IndexExtendMode)mode);
        GridServiceProvider.setIndexFileModeOnSync((GridServiceProvider.IndexExtendMode)mode);
        startupLog.info("CdmInit: GridServiceProvider.IndexExtendMode= " + mode);
        boolean alwaysUseCache = ThreddsConfig.getBoolean("GribIndexing.alwaysUseCache", false);
        GridServiceProvider.setIndexAlwaysInCache((boolean)alwaysUseCache);
        startupLog.info("CdmInit: GribIndexing.alwaysUseCache= " + alwaysUseCache);
        NetcdfFile.setProperty((String)"syncExtendOnly", (String)"true");
        String dir = ThreddsConfig.get("AggregationCache.dir", new File(tdsContext.getContentDirectory().getPath(), "/cache/agg/").getPath());
        int scourSecs = ThreddsConfig.getSeconds("AggregationCache.scour", 86400);
        int maxAgeSecs = ThreddsConfig.getSeconds("AggregationCache.maxAge", 7776000);
        this.aggCache = new DiskCache2(dir, false, maxAgeSecs / 60, scourSecs / 60);
        Aggregation.setPersistenceCache((DiskCache2)this.aggCache);
        startupLog.info("CdmInit:  AggregationCache= " + dir + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
        String typicalDataset = ThreddsConfig.get("Aggregation.typicalDataset", "penultimate");
        Aggregation.setTypicalDatasetMode((String)typicalDataset);
        startupLog.info("CdmInit: Aggregation.setTypicalDatasetMode= " + typicalDataset);
        dir = ThreddsConfig.get("DiskCache.dir", new File(tdsContext.getContentDirectory(), "/cache/cdm/").getPath());
        boolean alwaysUse = ThreddsConfig.getBoolean("DiskCache.alwaysUse", false);
        scourSecs = ThreddsConfig.getSeconds("DiskCache.scour", 3600);
        long maxSize = ThreddsConfig.getBytes("DiskCache.maxSize", 1000000000L);
        DiskCache.setRootDirectory((String)dir);
        DiskCache.setCachePolicy((boolean)alwaysUse);
        startupLog.info("CdmInit:  CdmCache= " + dir + " scour = " + scourSecs + " maxSize = " + maxSize);
        Calendar c = Calendar.getInstance();
        c.add(13, scourSecs / 2);
        this.timer = new Timer("CdmDiskCache");
        this.timer.scheduleAtFixedRate((TimerTask)new CacheScourTask(maxSize), c.getTime(), 1000L * (long)scourSecs);
        startupLog.info("CdmInit complete");
    }

    public void destroy() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        NetcdfDataset.shutdown();
        if (this.aggCache != null) {
            this.aggCache.exit();
        }
        if (this.gcCache != null) {
            this.gcCache.exit();
        }
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
        MetadataManager.closeAll();
        startupLog.info("CdmInit shutdown");
    }

    private class CacheScourTask
    extends TimerTask {
        long maxBytes;

        CacheScourTask(long maxBytes) {
            this.maxBytes = maxBytes;
        }

        @Override
        public void run() {
            StringBuilder sbuff = new StringBuilder();
            DiskCache.cleanCache((long)this.maxBytes, (StringBuilder)sbuff);
            sbuff.append("----------------------\n");
        }
    }
}

