/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.Log4jWebConfigurer;
import thredds.inventory.CollectionUpdater;
import thredds.server.config.CdmInit;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.HtmlWriter;
import thredds.servlet.RestrictedAccessConfigListener;
import thredds.servlet.UsageLog;

public class TdsConfigContextListener
implements ServletContextListener {
    private Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");

    public void contextInitialized(ServletContextEvent event) {
        System.out.println("TdsConfigContextListener.contextInitialized(): start.");
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        TdsContext tdsContext = (TdsContext)wac.getBean("tdsContext", TdsContext.class);
        tdsContext.init(servletContext);
        Log4jWebConfigurer.initLogging((ServletContext)servletContext);
        this.logServerStartup.info("TdsConfigContextListener.contextInitialized() start[2]: " + UsageLog.setupNonRequestContext());
        CdmInit cdmInit = (CdmInit)wac.getBean("cdmInit", CdmInit.class);
        cdmInit.init(tdsContext);
        this.logServerStartup.info("TdsConfigContextListener: CdmInit done");
        DataRootHandler catHandler = (DataRootHandler)wac.getBean("tdsDRH", DataRootHandler.class);
        catHandler.registerConfigListener(new RestrictedAccessConfigListener());
        catHandler.init();
        DataRootHandler.setInstance(catHandler);
        this.logServerStartup.info("TdsConfigContextListener: DataRootHandler done");
        HtmlWriter htmlWriter = (HtmlWriter)wac.getBean("htmlWriter", HtmlWriter.class);
        htmlWriter.setSingleton(htmlWriter);
        this.logServerStartup.info("TdsConfigContextListener.contextInitialized(): done - " + UsageLog.closingMessageNonRequestContext());
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.logServerStartup.info("TdsConfigContextListener.contextDestroyed(): start." + UsageLog.setupNonRequestContext());
        CollectionUpdater.INSTANCE.shutdown();
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        TdsContext tdsContext = (TdsContext)wac.getBean("tdsContext", TdsContext.class);
        tdsContext.destroy();
        this.logServerStartup.info("TdsConfigContextListener.contextDestroyed(): Done except for shutdownLogging() - " + UsageLog.closingMessageNonRequestContext());
        Log4jWebConfigurer.shutdownLogging((ServletContext)servletContext);
    }
}

