/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.springframework.util.StringUtils;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetScan;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsConfigMapper;
import thredds.server.config.TdsServerInfo;
import thredds.server.config.WmsConfig;
import thredds.server.ncSubset.GridServlet;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.filesource.BasicDescendantFileSource;
import thredds.util.filesource.BasicWithExclusionsDescendantFileSource;
import thredds.util.filesource.ChainedFileSource;
import thredds.util.filesource.DescendantFileSource;
import thredds.util.filesource.FileSource;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

public class TdsContext {
    private String webappName;
    private String webappVersion;
    private String webappVersionBrief;
    private String webappVersionBuildDate;
    private String contextPath;
    private String contentRootPath;
    private String contentPath;
    private String startupContentPath;
    private String iddContentPath;
    private String motherlodeContentPath;
    private String webinfPath;
    private File rootDirectory;
    private File contentDirectory;
    private File publicContentDirectory;
    private File tomcatLogDir;
    private File startupContentDirectory;
    private File iddContentDirectory;
    private File motherlodeContentDirectory;
    private DescendantFileSource rootDirSource;
    private DescendantFileSource contentDirSource;
    private DescendantFileSource publicContentDirSource;
    private DescendantFileSource startupContentDirSource;
    private DescendantFileSource iddContentPublicDirSource;
    private DescendantFileSource motherlodeContentPublicDirSource;
    private FileSource configSource;
    private FileSource publicDocSource;
    private RequestDispatcher defaultRequestDispatcher;
    private RequestDispatcher jspRequestDispatcher;
    private String tdsConfigFileName;
    private HtmlConfig htmlConfig;
    private TdsServerInfo serverInfo;
    private WmsConfig wmsConfig;

    public void setWebappVersion(String verFull) {
        this.webappVersion = verFull;
    }

    public void setWebappVersionBrief(String ver) {
        this.webappVersionBrief = ver;
    }

    public void setWebappVersionBuildDate(String buildDateString) {
        this.webappVersionBuildDate = buildDateString;
    }

    public void setContentRootPath(String contentRootPath) {
        this.contentRootPath = contentRootPath;
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    public void setStartupContentPath(String startupContentPath) {
        this.startupContentPath = startupContentPath;
    }

    public void setIddContentPath(String iddContentPath) {
        this.iddContentPath = iddContentPath;
    }

    public void setMotherlodeContentPath(String motherlodeContentPath) {
        this.motherlodeContentPath = motherlodeContentPath;
    }

    public void setTdsConfigFileName(String filename) {
        this.tdsConfigFileName = filename;
    }

    public String getTdsConfigFileName() {
        return this.tdsConfigFileName;
    }

    public void setServerInfo(TdsServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public TdsServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setHtmlConfig(HtmlConfig htmlConfig) {
        this.htmlConfig = htmlConfig;
    }

    public HtmlConfig getHtmlConfig() {
        return this.htmlConfig;
    }

    public WmsConfig getWmsConfig() {
        return this.wmsConfig;
    }

    public void setWmsConfig(WmsConfig wmsConfig) {
        this.wmsConfig = wmsConfig;
    }

    public void destroy() {
    }

    public void init(ServletContext servletContext) {
        String msg;
        if (servletContext == null) {
            throw new IllegalArgumentException("ServletContext must not be null.");
        }
        ServletUtil.initDebugging(servletContext);
        this.webappName = servletContext.getServletContextName();
        String tmpContextPath = servletContext.getInitParameter("ContextPath");
        if (tmpContextPath == null) {
            tmpContextPath = "thredds";
        }
        this.contextPath = "/" + tmpContextPath;
        ServletUtil.setContextPath(this.contextPath);
        if (this.webappVersion != null && !this.webappVersion.startsWith(this.webappVersionBrief + ".")) {
            String msg2 = "Full version [" + this.webappVersion + "] must start with version [" + this.webappVersionBrief + "].";
            System.out.println("ERROR - TdsContext.init(): " + msg2);
            throw new IllegalStateException(msg2);
        }
        String rootPath = servletContext.getRealPath("/");
        if (rootPath == null) {
            String msg3 = "Webapp [" + this.webappName + "] must run with exploded deployment directory (not from .war).";
            System.out.println("ERROR - TdsContext.init(): " + msg3);
            throw new IllegalStateException(msg3);
        }
        this.rootDirectory = new File(rootPath);
        this.rootDirSource = new BasicDescendantFileSource(this.rootDirectory);
        this.rootDirectory = this.rootDirSource.getRootDirectory();
        ServletUtil.setRootPath(this.rootDirSource.getRootDirectoryPath());
        this.startupContentDirectory = new File(this.rootDirectory, this.startupContentPath);
        this.startupContentDirSource = new BasicDescendantFileSource(this.startupContentDirectory);
        this.startupContentDirectory = this.startupContentDirSource.getRootDirectory();
        this.webinfPath = this.rootDirectory + "/WEB-INF";
        try {
            String base = System.getProperty("catalina.base");
            if (base != null) {
                this.tomcatLogDir = new File(base, "logs").getCanonicalFile();
                if (!this.tomcatLogDir.exists()) {
                    msg = "'catalina.base' directory not found";
                    System.out.println("WARN - TdsContext.init(): " + msg);
                }
            } else {
                msg = "'catalina.base' property not found - probably not a tomcat server";
                System.out.println("WARN - TdsContext.init(): " + msg);
            }
        }
        catch (IOException e) {
            msg = "tomcatLogDir could not be created";
            System.out.println("WARN - TdsContext.init(): " + msg);
        }
        File contentRootDir = new File(this.contentRootPath);
        if (!contentRootDir.isAbsolute()) {
            this.contentDirectory = new File(new File(this.rootDirectory, this.contentRootPath), this.contentPath);
        } else if (contentRootDir.isDirectory()) {
            this.contentDirectory = new File(contentRootDir, this.contentPath);
        } else {
            msg = "Content root directory [" + this.contentRootPath + "] not a directory.";
            System.out.println("ERROR - TdsContext.init(): " + msg);
            throw new IllegalStateException(msg);
        }
        if (!this.contentDirectory.exists()) {
            try {
                IO.copyDirTree((String)this.startupContentDirectory.getPath(), (String)this.contentDirectory.getPath());
            }
            catch (IOException e) {
                String tmpMsg = "Content directory does not exist and could not be created";
                System.out.println("ERROR - TdsContext.init(): " + tmpMsg + " [" + this.contentDirectory.getAbsolutePath() + "].");
                throw new IllegalStateException(tmpMsg);
            }
        }
        if (!this.contentDirectory.isDirectory()) {
            String tmpMsg = "Content directory not a directory";
            System.out.println("ERROR - TdsContext.init(): " + tmpMsg + " [" + this.contentDirectory.getAbsolutePath() + "].");
            throw new IllegalStateException(tmpMsg);
        }
        this.contentDirSource = new BasicDescendantFileSource(StringUtils.cleanPath((String)this.contentDirectory.getAbsolutePath()));
        this.contentDirectory = this.contentDirSource.getRootDirectory();
        ServletUtil.setContentPath(this.contentDirSource.getRootDirectoryPath());
        File tdsConfigFile = this.contentDirSource.getFile(this.getTdsConfigFileName());
        String tdsConfigFilename = tdsConfigFile != null ? tdsConfigFile.getPath() : "";
        ThreddsConfig.init(tdsConfigFilename);
        File logDir = new File(this.contentDirectory, "logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            String msg4 = "Couldn't create TDS log directory [" + logDir.getPath() + "].";
            System.out.println("ERROR - TdsContext.init(): " + msg4);
            throw new IllegalStateException(msg4);
        }
        String loggingDirectory = StringUtil2.substitute((String)logDir.getPath(), (String)"\\", (String)"/");
        System.setProperty("tds.log.dir", loggingDirectory);
        this.publicContentDirectory = new File(this.contentDirectory, "public");
        if (!this.publicContentDirectory.exists() && !this.publicContentDirectory.mkdirs()) {
            String msg5 = "Couldn't create TDS public directory [" + this.publicContentDirectory.getPath() + "].";
            System.out.println("ERROR - TdsContext.init(): " + msg5);
            throw new IllegalStateException(msg5);
        }
        this.publicContentDirSource = new BasicDescendantFileSource(this.publicContentDirectory);
        this.iddContentDirectory = new File(this.rootDirectory, this.iddContentPath);
        this.iddContentPublicDirSource = new BasicDescendantFileSource(this.iddContentDirectory);
        this.motherlodeContentDirectory = new File(this.rootDirectory, this.motherlodeContentPath);
        this.motherlodeContentPublicDirSource = new BasicDescendantFileSource(this.motherlodeContentDirectory);
        ArrayList<DescendantFileSource> chain = new ArrayList<DescendantFileSource>();
        BasicWithExclusionsDescendantFileSource contentMinusPublicSource = new BasicWithExclusionsDescendantFileSource(this.contentDirectory, Collections.singletonList("public"));
        chain.add(contentMinusPublicSource);
        for (String curContentRoot : ThreddsConfig.getContentRootList()) {
            if (curContentRoot.equalsIgnoreCase("idd")) {
                chain.add(this.iddContentPublicDirSource);
                continue;
            }
            if (curContentRoot.equalsIgnoreCase("motherlode")) {
                chain.add(this.motherlodeContentPublicDirSource);
                continue;
            }
            try {
                chain.add(new BasicDescendantFileSource(StringUtils.cleanPath((String)curContentRoot)));
            }
            catch (IllegalArgumentException e) {
                String msg6 = "Couldn't add content root [" + curContentRoot + "]: " + e.getMessage();
                System.out.println("WARN - TdsContext.init(): " + msg6);
            }
        }
        this.configSource = new ChainedFileSource(chain);
        this.publicDocSource = this.publicContentDirSource;
        InvDatasetScan.setContext((String)this.contextPath);
        InvDatasetScan.setCatalogServletName((String)"/catalog");
        InvDatasetFeatureCollection.setContext((String)this.contextPath);
        GridServlet.setContextPath(this.contextPath);
        this.jspRequestDispatcher = servletContext.getNamedDispatcher("jsp");
        this.defaultRequestDispatcher = servletContext.getNamedDispatcher("default");
        TdsConfigMapper tdsConfigMapper = new TdsConfigMapper();
        tdsConfigMapper.setTdsServerInfo(this.serverInfo);
        tdsConfigMapper.setHtmlConfig(this.htmlConfig);
        tdsConfigMapper.setWmsConfig(this.wmsConfig);
        tdsConfigMapper.init(this);
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getWebinfPath() {
        return this.webinfPath;
    }

    public String getWebappVersion() {
        return this.webappVersion;
    }

    public String getWebappVersionBrief() {
        return this.webappVersionBrief;
    }

    public String getWebappVersionBuildDate() {
        return this.webappVersionBuildDate;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getTomcatLogDirectory() {
        return this.tomcatLogDir;
    }

    public File getContentDirectory() {
        return this.contentDirectory;
    }

    public File getStartupContentDirectory() {
        return this.startupContentDirectory;
    }

    public File getIddContentDirectory() {
        return this.iddContentDirectory;
    }

    public File getMotherlodeContentDirectory() {
        return this.motherlodeContentDirectory;
    }

    public FileSource getConfigFileSource() {
        return this.configSource;
    }

    public FileSource getPublicDocFileSource() {
        return this.publicDocSource;
    }

    public RequestDispatcher getDefaultRequestDispatcher() {
        return this.defaultRequestDispatcher;
    }

    public RequestDispatcher getJspRequestDispatcher() {
        return this.jspRequestDispatcher;
    }
}

