/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.units.DateFromString;

public class CollectionManager {
    private static Logger logger = LoggerFactory.getLogger(CollectionManager.class);
    private ArrayList<MyFile> scanList = new ArrayList();
    private Date latest = null;
    private String dirName;

    public CollectionManager(String dirName, FileFilter ff, String dateFormatString) {
        File[] files;
        this.dirName = dirName;
        File dir = new File(dirName);
        for (File f : files = dir.listFiles(ff)) {
            Date d = DateFromString.getDateUsingSimpleDateFormat((String)f.getName(), (String)dateFormatString);
            this.add(f, d);
        }
    }

    public String toString() {
        return this.dirName;
    }

    public List<MyFile> getList() {
        return this.scanList;
    }

    public Date getLatest() {
        return this.latest;
    }

    public void add(File file, Date d) {
        this.scanList.add(new MyFile(file, d));
        if (this.latest == null || d.after(this.latest)) {
            this.latest = d;
        }
    }

    public boolean remove(MyFile file) {
        return this.scanList.remove(file);
    }

    public MyFile find(File file) {
        int index = this.scanList.indexOf(file);
        return index >= 0 ? this.scanList.get(index) : null;
    }

    public List<MyFile> after(Date date) {
        ArrayList<MyFile> result = new ArrayList<MyFile>();
        for (MyFile f : this.scanList) {
            if (date != null && !f.date.after(date)) continue;
            result.add(f);
        }
        return result;
    }

    public class MyFile
    implements Comparable {
        public File file;
        public Date date;

        MyFile(File file, Date d) {
            this.date = d;
            this.file = file;
        }

        public int compareTo(Object o) {
            MyFile om = (MyFile)o;
            return this.date.compareTo(om.date);
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }
}

