/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.config.TdsContext;
import thredds.server.ncSubset.QueryParams;
import thredds.server.ncSubset.StationObsCollection;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.UsageLog;
import ucar.nc2.time.CalendarDateRange;

public class StationController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private StationObsCollection soc;
    private boolean debug = false;
    private boolean showTime = false;
    private TdsContext tdsContext;
    private boolean allow = false;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("StationController");
        DebugHandler.Action act = new DebugHandler.Action("showMetarFiles", "Show Metar Files"){

            @Override
            public void doAction(DebugHandler.Event e) {
                e.pw.println("Metar Files\n");
                ArrayList<StationObsCollection.Dataset> list = StationController.this.soc.getDatasets();
                for (StationObsCollection.Dataset ds : list) {
                    e.pw.println(" " + ds);
                }
            }
        };
        debugHandler.addAction(act);
    }

    public void init() throws ServletException {
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization start - " + UsageLog.setupNonRequestContext());
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization done - " + UsageLog.closingMessageNonRequestContext());
    }

    public void destroy() {
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " destroy start - " + UsageLog.setupNonRequestContext());
        if (null != this.soc) {
            this.soc.close();
        }
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " destroy done - " + UsageLog.closingMessageNonRequestContext());
    }

    public long getLastModified(HttpServletRequest req) {
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(req.getPathInfo());
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        boolean useAllTimes;
        boolean useAllStations;
        String pathInfo;
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return null;
        }
        if (!this.soc.isReady()) {
            res.sendError(503, "Service Temporarily Unavailable");
            return null;
        }
        long start = System.currentTimeMillis();
        this.log.info(UsageLog.setupRequestContext(req));
        if (this.debug) {
            System.out.println(req.getQueryString());
        }
        if ((pathInfo = req.getPathInfo()) == null) {
            pathInfo = "";
        }
        boolean wantXML = pathInfo.endsWith("dataset.xml");
        boolean showForm = pathInfo.endsWith("dataset.html");
        boolean wantStationXML = pathInfo.endsWith("stations.xml");
        if (wantXML || showForm || wantStationXML) {
            this.showForm(res, wantXML, wantStationXML);
            return null;
        }
        QueryParams qp = new QueryParams();
        if (!qp.parseQuery(req, res, new String[]{"text/plain", "text/csv", "application/xml", "application/x-netcdf", "application/x-netcdfs", "application/x-cdmremote"})) {
            return null;
        }
        if (qp.hasBB) {
            qp.stns = this.soc.getStationNames(qp.getBB());
            if (qp.stns.size() == 0) {
                qp.errs.append("ERROR: Bounding Box contains no stations\n");
                qp.writeErr(req, res, qp.errs.toString(), 400);
                return null;
            }
        }
        if (qp.hasStns && this.soc.isStationListEmpty(qp.stns)) {
            qp.errs.append("ERROR: No valid stations specified\n");
            qp.writeErr(req, res, qp.errs.toString(), 400);
            return null;
        }
        if (qp.hasLatlonPoint) {
            qp.stns = new ArrayList<String>();
            qp.stns.add(this.soc.findClosestStation(qp.lat, qp.lon));
        } else if (qp.fatal) {
            qp.errs.append("ERROR: No valid stations specified\n");
            qp.writeErr(req, res, qp.errs.toString(), 400);
            return null;
        }
        boolean bl = useAllStations = !qp.hasBB && !qp.hasStns && !qp.hasLatlonPoint;
        if (useAllStations) {
            qp.stns = new ArrayList<String>();
        }
        if (qp.hasTimePoint && this.soc.filterDataset(qp.time) == null) {
            qp.errs.append("ERROR: This dataset does not contain the time point= " + qp.time + " \n");
            qp.writeErr(req, res, qp.errs.toString(), 400);
            return null;
        }
        if (qp.hasDateRange) {
            CalendarDateRange dr = qp.getCalendarDateRange();
            if (!this.soc.intersect(dr)) {
                qp.errs.append("ERROR: This dataset does not contain the time range= " + qp.time + " \n");
                qp.writeErr(req, res, qp.errs.toString(), 400);
                return null;
            }
            if (this.debug) {
                System.out.println(" date range= " + dr);
            }
        }
        boolean bl2 = useAllTimes = !qp.hasTimePoint && !qp.hasDateRange;
        if (useAllStations && useAllTimes) {
            qp.errs.append("ERROR: You must subset by space or time\n");
            qp.writeErr(req, res, qp.errs.toString(), 400);
            return null;
        }
        String contentType = qp.acceptType;
        if (qp.acceptType.equals("text/csv")) {
            contentType = "text/plain";
        }
        res.setContentType(contentType);
        if (qp.acceptType.equals("application/x-netcdf")) {
            res.setHeader("Content-Disposition", "attachment; filename=metarSubset.nc");
            File file = this.soc.writeNetcdf(qp);
            ServletUtil.returnFile(req, res, file, "application/x-netcdf");
            file.delete();
            if (this.showTime) {
                long took = System.currentTimeMillis() - start;
                System.out.println("\ntotal response took = " + took + " msecs");
            }
            return null;
        }
        this.soc.write(qp, res);
        this.log.info(UsageLog.closingMessageForRequestContext(200, -1L));
        if (this.showTime) {
            long took = System.currentTimeMillis() - start;
            System.out.println("\ntotal response took = " + took + " msecs");
        }
        return null;
    }

    private void showForm(HttpServletResponse res, boolean wantXml, boolean wantStationXml) throws IOException {
        String infoString;
        Document doc;
        if (wantXml) {
            doc = this.soc.getDoc();
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(doc);
        } else if (wantStationXml) {
            doc = this.soc.getStationDoc();
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(doc);
        } else {
            InputStream xslt = this.getXSLT("ncssSobs.xsl");
            Document doc2 = this.soc.getDoc();
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc2);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Exception e) {
                this.log.error("SobsServlet internal error", (Throwable)e);
                this.log.info(UsageLog.closingMessageForRequestContext(500, 0L));
                res.sendError(500, "SobsServlet internal error");
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml || wantStationXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        this.log.info(UsageLog.closingMessageForRequestContext(200, infoString.length()));
    }

    private InputStream getXSLT(String xslName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }
}

