/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DPrimitive;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.NoSuchTypeException;
import opendap.dap.parsers.ParseException;
import opendap.servers.CEEvaluator;
import opendap.servers.SDArray;
import opendap.servers.ServerDDS;
import opendap.servlet.AbstractServlet;
import opendap.servlet.AsciiWriter;
import opendap.servlet.BadURLException;
import opendap.servlet.GetInfoHandler;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.GetHTMLInterfaceHandler2;
import thredds.server.opendap.GuardedDatasetCacheAndClone;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.Debug;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.util.net.EscapeStrings;

public class OpendapServlet
extends AbstractServlet {
    static final String DEFAULTCONTEXTPATH = "/thredds";
    static final String GDATASET = "guarded_dataset";
    private static Logger log = LoggerFactory.getLogger(OpendapServlet.class);
    private boolean allowSessions = false;
    private boolean allowDeflate = false;
    private String odapVersionString = "opendap/3.7";
    private URI baseURI = null;
    private int ascLimit = 50;
    private int binLimit = 500;
    private boolean debugSession = false;

    public String getDefaultContextPath() {
        return DEFAULTCONTEXTPATH;
    }

    public void init() throws ServletException {
        super.init();
        Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization start - " + UsageLog.setupNonRequestContext());
        this.ascLimit = ThreddsConfig.getInt("Opendap.ascLimit", this.ascLimit);
        this.binLimit = ThreddsConfig.getInt("Opendap.binLimit", this.binLimit);
        this.odapVersionString = ThreddsConfig.get("Opendap.serverVersion", this.odapVersionString);
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " version= " + this.odapVersionString + " ascLimit = " + this.ascLimit + " binLimit = " + this.binLimit);
        this.makeDebugActions();
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization done - " + UsageLog.closingMessageNonRequestContext());
    }

    public String getServerVersion() {
        return this.odapVersionString;
    }

    protected long getLastModified(HttpServletRequest req) {
        String query = req.getQueryString();
        if (query != null) {
            return -1L;
        }
        String path = req.getPathInfo();
        if (path == null) {
            return -1L;
        }
        if (path.endsWith(".asc")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".ascii")) {
            path = path.substring(0, path.length() - 6);
        } else if (path.endsWith(".das")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".dds")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".ddx")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".dods")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".info")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".opendap")) {
            path = path.substring(0, path.length() - 5);
        } else {
            return -1L;
        }
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(path);
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.info("doGet(): " + UsageLog.setupRequestContext(request));
        String path = null;
        ReqState rs = this.getRequestState(request, response);
        try {
            path = request.getPathInfo();
            log.debug("doGet path={}", (Object)path);
            if (Debug.isSet("showRequestDetail")) {
                log.debug(ServletUtil.showRequestDetail((HttpServlet)this, request));
            }
            if (path == null) {
                log.info("doGet(): " + UsageLog.closingMessageForRequestContext(404, -1L));
                response.sendError(404);
                return;
            }
            if (this.baseURI == null) {
                URI reqURI = ServletUtil.getRequestURI(request);
                String baseUriString = request.getContextPath() + request.getServletPath() + "/";
                this.baseURI = reqURI.resolve(baseUriString);
                log.debug("doGet(): baseURI was set = {}", (Object)this.baseURI);
            }
            if (path.endsWith("latest.xml")) {
                DataRootHandler.getInstance().processReqForLatestDataset((HttpServlet)this, request, response);
                return;
            }
            if (path.equals("/") || path.equals("/catalog.html") || path.equals("/catalog.xml")) {
                ServletUtil.sendPermanentRedirect(ServletUtil.getContextPath() + path, request, response);
                return;
            }
            if (path.endsWith("/") || path.endsWith("/catalog.html") || path.endsWith("/catalog.xml")) {
                if (!DataRootHandler.getInstance().hasDataRootMatch(path)) {
                    log.info("doGet(): " + UsageLog.closingMessageForRequestContext(404, -1L));
                    response.sendError(404);
                    return;
                }
                if (DataRootHandler.getInstance().processReqForCatalog(request, response)) return;
                log.error("doGet(): " + UsageLog.closingMessageForRequestContext(1002, -1L));
                return;
            }
            if (rs == null) {
                this.sendErrorResponse(response, 400, "Unrecognized request");
                return;
            }
            String dataSet = rs.getDataSet();
            String requestSuffix = rs.getRequestSuffix();
            if (dataSet == null || dataSet.equals("/") || dataSet.equals("")) {
                this.doGetDIR(rs);
            } else if (requestSuffix.equalsIgnoreCase("blob")) {
                this.doGetBLOB(rs);
            } else if (requestSuffix.equalsIgnoreCase("close")) {
                this.doClose(rs);
            } else if (requestSuffix.equalsIgnoreCase("dds")) {
                this.doGetDDS(rs);
            } else if (requestSuffix.equalsIgnoreCase("das")) {
                this.doGetDAS(rs);
            } else if (requestSuffix.equalsIgnoreCase("ddx")) {
                this.doGetDDX(rs);
            } else if (requestSuffix.equalsIgnoreCase("dods")) {
                this.doGetDAP2Data(rs);
            } else if (requestSuffix.equalsIgnoreCase("asc") || requestSuffix.equalsIgnoreCase("ascii")) {
                this.doGetASC(rs);
            } else if (requestSuffix.equalsIgnoreCase("info")) {
                this.doGetINFO(rs);
            } else if (requestSuffix.equalsIgnoreCase("html") || requestSuffix.equalsIgnoreCase("htm")) {
                this.doGetHTML(rs);
            } else if (requestSuffix.equalsIgnoreCase("ver") || requestSuffix.equalsIgnoreCase("version") || dataSet.equalsIgnoreCase("/version") || dataSet.equalsIgnoreCase("/version/")) {
                this.doGetVER(rs);
            } else {
                if (!(dataSet.equalsIgnoreCase("/help") || dataSet.equalsIgnoreCase("/help/") || dataSet.equalsIgnoreCase("/" + requestSuffix) || requestSuffix.equalsIgnoreCase("help"))) {
                    this.sendErrorResponse(response, 400, "Unrecognized request");
                    return;
                }
                this.doGetHELP(rs);
            }
            log.info(UsageLog.closingMessageForRequestContext(200, -1L));
            return;
        }
        catch (FileNotFoundException e) {
            this.sendErrorResponse(response, 404, e.getMessage());
            return;
        }
        catch (BadURLException e) {
            log.info(UsageLog.closingMessageForRequestContext(400, -1L));
            response.setStatus(400);
            this.dap2ExceptionHandler((DAP2Exception)((Object)e), rs);
            return;
        }
        catch (DAP2Exception de) {
            int status;
            int n = status = de.getErrorCode() == 1 ? 404 : 400;
            if (de.getErrorCode() != 1 && de.getErrorMessage() != null) {
                log.debug(de.getErrorMessage());
            }
            log.info(UsageLog.closingMessageForRequestContext(status, -1L));
            response.setStatus(status);
            this.dap2ExceptionHandler(de, rs);
            return;
        }
        catch (ParseException pe) {
            log.info(UsageLog.closingMessageForRequestContext(400, -1L));
            response.setStatus(400);
            this.parseExceptionHandler(pe, response);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendErrorResponse(response, 403, e.getMessage());
            return;
        }
        catch (SocketException e) {
            log.info("SocketException: " + e.getMessage(), (Throwable)e);
            log.info(UsageLog.closingMessageForRequestContext(1000, -1L));
            return;
        }
        catch (IOException e) {
            String eName = e.getClass().getName();
            if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
                log.debug("ClientAbortException: " + e.getMessage());
                log.info(UsageLog.closingMessageForRequestContext(1000, -1L));
                return;
            }
            log.error("path= " + path, (Throwable)e);
            this.sendErrorResponse(response, 500, e.getMessage());
            return;
        }
        catch (Throwable t) {
            log.error("path= " + path, t);
            t.printStackTrace();
            this.sendErrorResponse(response, 500, t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetASC(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/plain");
            response.setHeader("Content-Description", "dods-ascii");
            log.debug("Sending OPeNDAP ASCII Data For: " + rs + "  CE: '" + rs.getConstraintExpression() + "'");
            ServerDDS dds = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(dds);
            ce.parseConstraint(rs);
            this.checkSize(dds, true);
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            dds.printConstrained(pw);
            pw.println("---------------------------------------------");
            AsciiWriter writer = new AsciiWriter();
            writer.toASCII(pw, (DDS)dds, (Object)ds);
            pw.flush();
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAS(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-das");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            DAS myDAS = ds.getDAS();
            myDAS.print((OutputStream)Out);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDS(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-dds");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.print((OutputStream)out);
                ((OutputStream)out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
                myDDS.printConstrained(pw);
                pw.flush();
            }
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDX(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-ddx");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            myDDS.ingestDAS(ds.getDAS());
            if (rs.getConstraintExpression().equals("")) {
                myDDS.printXML((OutputStream)out);
                ((OutputStream)out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
                myDDS.printConstrainedXML(pw);
                pw.flush();
            }
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetBLOB(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("application/octet-stream");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-blob");
            ServletOutputStream sOut = response.getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                response.setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs);
            this.checkSize(myDDS, false);
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), (OutputStream)sink, (Object)ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    private void doClose(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        HttpServletRequest request = rs.getRequest();
        String reqPath = rs.getDataSet();
        HttpSession session = request.getSession();
        session.removeAttribute(reqPath);
        response.setHeader("XDODS-Server", this.getServerVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAP2Data(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("application/octet-stream");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-data");
            ServletOutputStream sOut = response.getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                response.setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs);
            this.checkSize(myDDS, false);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes());
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), (OutputStream)sink, (Object)ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetVER(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-version");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        pw.println("Server Version: " + this.getServerVersion());
        pw.flush();
    }

    public void doGetHELP(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-help");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        this.printHelpPage(pw);
        pw.flush();
    }

    public void doGetDIR(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        HttpServletRequest request = rs.getRequest();
        if (rs.getRequestSuffix() == null || rs.getRequestSuffix().length() == 0) {
            ServletUtil.forwardToCatalogServices(request, response);
            return;
        }
        this.sendErrorResponse(response, 0, "Unrecognized request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetINFO(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            PrintStream pw = new PrintStream((OutputStream)response.getOutputStream());
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/html");
            response.setHeader("Content-Description", "dods-description");
            GetInfoHandler di = new GetInfoHandler();
            di.sendINFO(pw, ds, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHTML(ReqState rs) throws Exception {
        HttpServletResponse response = rs.getResponse();
        HttpServletRequest request = rs.getRequest();
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/html");
            response.setHeader("Content-Description", "dods-form");
            ServerDDS myDDS = ds.getDDS();
            DAS das = ds.getDAS();
            GetHTMLInterfaceHandler2 di = new GetHTMLInterfaceHandler2();
            di.sendDataRequestForm(request, response, rs.getDataSet(), myDDS, das);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    private void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("ncdodsServer");
        DebugHandler.Action act = new DebugHandler.Action("help", "Show help page"){

            @Override
            public void doAction(DebugHandler.Event e) {
                try {
                    OpendapServlet.this.doGetHELP(OpendapServlet.this.getRequestState(e.req, e.res));
                }
                catch (Exception ioe) {
                    log.error("ShowHelp", (Throwable)ioe);
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("version", "Show server version"){

            @Override
            public void doAction(DebugHandler.Event e) {
                e.pw.println("  version= " + OpendapServlet.this.getServerVersion());
            }
        };
        debugHandler.addAction(act);
    }

    public String getServerName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void printHelpPage(PrintWriter pw) {
        pw.println("<h3>OPeNDAP Server Help</h3>");
        pw.println("To access most of the features of this OPeNDAP server, append");
        pw.println("one of the following a eight suffixes to a URL: .das, .dds, .dods, .ddx, .blob, .info,");
        pw.println(".ver or .help. Using these suffixes, you can ask this server for:");
        pw.println("<dl>");
        pw.println("<dt> das  </dt> <dd> Dataset Attribute Structure (DAS)</dd>");
        pw.println("<dt> dds  </dt> <dd> Dataset Descriptor Structure (DDS)</dd>");
        pw.println("<dt> dods </dt> <dd> DataDDS object (A constrained DDS populated with data)</dd>");
        pw.println("<dt> ddx  </dt> <dd> XML version of the DDS/DAS</dd>");
        pw.println("<dt> blob </dt> <dd> Serialized binary data content for requested data set, with the constraint expression applied.</dd>");
        pw.println("<dt> info </dt> <dd> info object (attributes, types and other information)</dd>");
        pw.println("<dt> html </dt> <dd> html form for this dataset</dd>");
        pw.println("<dt> ver  </dt> <dd> return the version number of the server</dd>");
        pw.println("<dt> help </dt> <dd> help information (this text)</dd>");
        pw.println("</dl>");
        pw.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        pw.println("test dataset) you would appand `.das' to the URL:");
        pw.println("http://opendap.gso.url.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        pw.println("<p><b>Note</b>: Many OPeNDAP clients supply these extensions for you so you don't");
        pw.println("need to append them (for example when using interfaces supplied by us or");
        pw.println("software re-linked with a OPeNDAP client-library). Generally, you only need to");
        pw.println("add these if you are typing a URL directly into a WWW browser.");
        pw.println("<p><b>Note</b>: If you would like version information for this server but");
        pw.println("don't know a specific data file or data set name, use `/version' for the");
        pw.println("filename. For example: http://opendap.gso.url.edu/cgi-bin/nph-nc/version will");
        pw.println("return the version number for the netCDF server used in the first example. ");
        pw.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        pw.println("would like information about the dataset, use the `.info' extension.");
        pw.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        pw.println("query using the customized form.");
    }

    private void printBadURLPage(PrintWriter pw) {
        String serverContactName = ThreddsConfig.get("serverInformation.contact.name", "UNKNOWN");
        String serverContactEmail = ThreddsConfig.get("serverInformation.contact.email", "UNKNOWN");
        pw.println("<h3>Error in URL</h3>");
        pw.println("The URL extension did not match any that are known by this");
        pw.println("server. Below is a list of the five extensions that are be recognized by");
        pw.println("all OPeNDAP servers. If you think that the server is broken (that the URL you");
        pw.println("submitted should have worked), then please contact the");
        pw.println("administrator of this server [" + serverContactName + "] at: ");
        pw.println("<a href='mailto:" + serverContactEmail + "'>" + serverContactEmail + "</a><p>");
    }

    protected ReqState getRequestState(HttpServletRequest request, HttpServletResponse response) {
        ReqState rs = null;
        String baseurl = request.getRequestURL().toString();
        baseurl = EscapeStrings.unescapeURL((String)baseurl);
        String query = request.getQueryString();
        query = EscapeStrings.unescapeURLQuery((String)query);
        log.info(String.format("OpendapServlet: nominal url: %s?%s", baseurl, query));
        try {
            rs = new ReqState(request, response, (AbstractServlet)this, this.getServerName(), baseurl, query);
        }
        catch (Exception bue) {
            rs = null;
        }
        return rs;
    }

    private void checkSize(ServerDDS dds, boolean isAscii) throws Exception {
        double maxSize;
        long size = this.computeSize((DConstructor)dds, isAscii);
        log.debug("total (constrained) size={}", (Object)size);
        double dsize = size / 1000000L;
        double d = maxSize = isAscii ? (double)this.ascLimit : (double)this.binLimit;
        if (dsize > maxSize) {
            log.info("Reject request size = {} Mbytes", (Object)dsize);
            throw new UnsupportedOperationException("Request too big=" + dsize + " Mbytes, max=" + maxSize);
        }
    }

    private long computeSize(DConstructor ctor, boolean isAscii) throws Exception {
        long projectsize = 0L;
        long othersize = 0L;
        long fieldsize = 0L;
        int projectedcount = 0;
        int fieldcount = 0;
        Enumeration vars = ctor.getVariables();
        while (vars.hasMoreElements()) {
            ++fieldcount;
            BaseType field = (BaseType)vars.nextElement();
            fieldsize = this.computeFieldSize(field, isAscii);
            if (field.isProject()) {
                projectsize += fieldsize;
                ++projectedcount;
                continue;
            }
            othersize += fieldsize;
        }
        if (projectedcount == fieldcount) {
            return projectsize;
        }
        if (projectedcount == 0) {
            return othersize;
        }
        assert (projectedcount > 0 && projectedcount < fieldcount);
        return projectsize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long computeFieldSize(BaseType bt, boolean isAscii) throws Exception {
        long fieldsize = 0L;
        if (bt instanceof DConstructor) {
            return this.computeSize((DConstructor)bt, isAscii);
        }
        if (bt instanceof DArray) {
            SDArray da = (SDArray)bt;
            if (da.getContainerVar() instanceof DPrimitive) {
                return this.computeArraySize(da);
            }
            if (!(da.getContainerVar() instanceof DStructure)) throw new NoSuchTypeException("Computesize: unexpected type for " + bt.getLongName());
            return this.computeSize((DConstructor)((DStructure)da.getContainerVar()), isAscii);
        }
        if (!(bt instanceof DPrimitive)) throw new NoSuchTypeException("Computesize: unknown type for " + bt.getLongName());
        DPrimitive dp = (DPrimitive)bt;
        if (dp instanceof DString) {
            String v = ((DString)dp).getValue();
            if (v == null) {
                return 0L;
            }
            int n = v.length();
            return n;
        }
        DataType dtype = DODSNetcdfFile.convertToNCType((BaseType)bt);
        return dtype.getSize();
    }

    long computeArraySize(SDArray da) throws Exception {
        assert (da.getContainerVar() instanceof DPrimitive);
        BaseType base = da.getPrimitiveVector().getTemplate();
        DataType dtype = DODSNetcdfFile.convertToNCType((BaseType)base);
        int elemSize = dtype.getSize();
        int n = da.numDimensions();
        ArrayList<Range> ranges = new ArrayList<Range>(n);
        long size = 0L;
        for (int i = 0; i < n; ++i) {
            ranges.add(new Range(da.getStart(i), da.getStop(i), da.getStride(i)));
            Section s = new Section(ranges);
            size += s.computeSize() * (long)elemSize;
        }
        return size;
    }

    protected GuardedDataset getDataset(ReqState preq) throws Exception {
        GuardedDataset gdataset;
        HttpServletRequest req = preq.getRequest();
        String reqPath = preq.getDataSet();
        boolean acceptSession = false;
        String s = req.getHeader("X-Accept-Session");
        if (s != null && s.equalsIgnoreCase("true") && this.allowSessions) {
            acceptSession = true;
        }
        HttpSession session = null;
        if (acceptSession && !(session = req.getSession()).isNew() && null != (gdataset = (GuardedDataset)session.getAttribute(reqPath))) {
            if (this.debugSession) {
                System.out.printf(" found gdataset %s in session %s %n", reqPath, session.getId());
            }
            if (log.isDebugEnabled()) {
                log.debug(" found gdataset " + gdataset + " in session " + session.getId());
            }
            return gdataset;
        }
        NetcdfFile ncd = DatasetHandler.getNetcdfFile(req, preq.getResponse(), reqPath);
        if (null == ncd) {
            return null;
        }
        GuardedDatasetCacheAndClone gdataset2 = new GuardedDatasetCacheAndClone(reqPath, ncd, acceptSession);
        if (acceptSession) {
            String suffix;
            String cookiePath = req.getRequestURI();
            if (cookiePath.endsWith(suffix = "." + preq.getRequestSuffix())) {
                cookiePath = cookiePath.substring(0, cookiePath.length() - suffix.length());
            }
            session.setAttribute(reqPath, (Object)gdataset2);
            session.setAttribute("SESSION_PATH", (Object)cookiePath);
            if (this.debugSession) {
                System.out.printf(" added gdataset %s in session %s cookiePath %s %n", reqPath, session.getId(), cookiePath);
            }
            if (log.isDebugEnabled()) {
                log.debug(" added gdataset " + gdataset2 + " in session " + session.getId());
            }
        }
        return gdataset2;
    }

    public void parseExceptionHandler(ParseException pe, HttpServletResponse response) {
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setContentType("text/plain");
            String msg = pe.getMessage().replace('\"', '\'');
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print((OutputStream)eOut);
        }
        catch (Exception e) {
            System.err.println("parseExceptionHandler: " + e);
        }
    }

    public void dap2ExceptionHandler(DAP2Exception de, ReqState rs) {
        rs.getResponse().setHeader("Content-Description", "dods-error");
        rs.getResponse().setContentType("text/plain");
        try {
            de.print((OutputStream)rs.getResponse().getOutputStream());
        }
        catch (Exception e) {
            System.err.println("dap2ExceptionHandler: " + e);
        }
    }

    private void sendErrorResponse(HttpServletResponse response, int errorCode, String errorMessage) {
        try {
            log.info(UsageLog.closingMessageForRequestContext(errorCode, -1L));
            response.setStatus(errorCode);
            response.setHeader("Content-Description", "dods-error");
            response.setContentType("text/plain");
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            pw.println("Error {");
            pw.println("    code = " + errorCode + ";");
            pw.println("    message = \"" + errorMessage + "\";");
            pw.println("};");
            pw.flush();
        }
        catch (Exception e) {
            System.err.println("sendErrorResponse: " + e);
        }
    }
}

