/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.inventory.CollectionManager;
import thredds.inventory.DatasetCollectionMFiles;
import thredds.inventory.MFile;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DebugHandler;
import thredds.servlet.UsageLog;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.unidata.util.StringUtil2;

public class CollectionController
extends AbstractController {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Logger logFc = LoggerFactory.getLogger(DatasetCollectionMFiles.class);
    private static final String PATH = "/admin/collection";
    private static final String COLLECTION = "collection";
    private static final String TRIGGER = "trigger";
    private final TdsContext tdsContext;

    CollectionController(TdsContext _tdsContext) {
        this.tdsContext = _tdsContext;
        DebugHandler debugHandler = DebugHandler.get("Collections");
        DebugHandler.Action act = new DebugHandler.Action("triggerRescan", "Show Collections"){

            @Override
            public void doAction(DebugHandler.Event e) {
                List<InvDatasetFeatureCollection> fcList = DataRootHandler.getInstance().getFeatureCollections();
                for (InvDatasetFeatureCollection fc : fcList) {
                    String ename = StringUtil2.escape((String)fc.getName(), (String)"");
                    String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "?" + CollectionController.COLLECTION + "=" + ename;
                    e.pw.printf("<p/><a href='%s'>%s</a>%n", url, fc.getName());
                }
            }
        };
        debugHandler.addAction(act);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.log.info("handleRequest: " + UsageLog.setupRequestContext(req));
        String path = req.getPathInfo();
        if (path == null) {
            path = "";
        }
        String collectName = req.getParameter(COLLECTION);
        String trigger = req.getParameter(TRIGGER);
        boolean wantTrigger = trigger != null && trigger.equalsIgnoreCase("true");
        InvDatasetFeatureCollection fc = DataRootHandler.getInstance().getFeatureCollection(collectName);
        if (fc == null) {
            this.log.info(UsageLog.closingMessageForRequestContext(404, 0L));
            res.setStatus(404);
            PrintWriter pw = res.getWriter();
            pw.append("NOT FOUND");
            pw.flush();
            return null;
        }
        if (wantTrigger) {
            if (!fc.getConfig().updateConfig.triggerOk && !fc.getConfig().tdmConfig.triggerOk) {
                this.log.info(UsageLog.closingMessageForRequestContext(403, 0L));
                res.setStatus(403);
                PrintWriter pw = res.getWriter();
                pw.append("NOT ALLOWED");
                pw.flush();
                return null;
            }
            this.logFc.info("Trigger rescan for {}", (Object)fc.getName());
            fc.triggerRescan();
        } else {
            res.setContentType("text/html");
            PrintWriter pw = res.getWriter();
            CollectionManager dcm = fc.getDatasetCollectionManager();
            pw.printf("<h3>Collection Name %s</h3>%n", dcm.getCollectionName() + "");
            pw.printf("%n<pre>Last Scanned %-20s%n", CalendarDateFormatter.toDateTimeString((Date)new Date(dcm.getLastScanned())));
            pw.printf("%n%-60s %-20s %7s %s%n", "Path", "Last Modified", "KB", "Aux");
            for (MFile mfile : dcm.getFiles()) {
                pw.printf("%-60s %-20s %7d %s%n", mfile.getPath(), CalendarDateFormatter.toDateTimeString((Date)new Date(mfile.getLastModified())), mfile.getLength() / 1000L, mfile.getAuxInfo());
            }
            pw.printf("</pre>%n", new Object[0]);
            pw.flush();
        }
        this.log.info(UsageLog.closingMessageForRequestContext(200, 0L));
        return null;
    }
}

