/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.serverinfo;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.server.config.TdsContext;
import thredds.servlet.UsageLog;

public class ServerInfoController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TdsContext tdsContext;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.info("handleRequestInternal(): " + UsageLog.setupRequestContext(request));
        String reqPath = request.getServletPath();
        if (reqPath == null) {
            this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(404, 0L));
            response.sendError(404);
            return null;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("serverInfo", this.tdsContext.getServerInfo());
        model.put("webappName", this.tdsContext.getWebappName());
        model.put("webappVersion", this.tdsContext.getWebappVersion());
        model.put("webappVersionBuildDate", this.tdsContext.getWebappVersionBuildDate());
        if (reqPath.equals("/serverInfo.html")) {
            return new ModelAndView("thredds/server/serverinfo/serverInfo_html", model);
        }
        if (reqPath.equals("/serverInfo.xml")) {
            return new ModelAndView("thredds/server/serverinfo/serverInfo_xml", model);
        }
        if (reqPath.equals("/serverVersion.txt")) {
            return new ModelAndView("thredds/server/serverinfo/serverVersion_txt", model);
        }
        this.log.info("handleRequestInternal(): " + UsageLog.closingMessageForRequestContext(404, 0L));
        response.sendError(404);
        return null;
    }
}

