/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_1_0;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.wcs.v1_1_0.GetCapabilities;
import thredds.wcs.v1_1_0.Request;
import thredds.wcs.v1_1_0.WcsException;
import ucar.nc2.dt.grid.GridDataset;

public class WcsRequestParser {
    private static Logger log = LoggerFactory.getLogger(WcsRequestParser.class);

    public static Request parseRequest(String version, HttpServletRequest req, HttpServletResponse res) throws WcsException {
        Request request;
        Request.Operation operation;
        String datasetPath = req.getPathInfo();
        ucar.nc2.dt.GridDataset dataset = WcsRequestParser.openDataset(req, res);
        String requestParam = ServletUtil.getParameterIgnoreCase(req, "Request");
        try {
            operation = Request.Operation.valueOf((String)requestParam);
        }
        catch (IllegalArgumentException e) {
            throw new WcsException(WcsException.Code.OperationNotSupported, requestParam, "");
        }
        if (operation.equals((Object)Request.Operation.GetCapabilities)) {
            List sections;
            String sectionsParam = ServletUtil.getParameterIgnoreCase(req, "Sections");
            String updateSequenceParam = ServletUtil.getParameterIgnoreCase(req, "UpdateSequence");
            String acceptFormatsParam = ServletUtil.getParameterIgnoreCase(req, "AccpetFormats");
            if (sectionsParam != null) {
                String[] sectionArray = sectionsParam.split(",");
                sections = new ArrayList(sectionArray.length);
                for (String curSection : sectionArray) {
                    sections.add(GetCapabilities.Section.valueOf((String)curSection));
                }
            } else {
                sections = Collections.emptyList();
            }
            request = Request.getGetCapabilitiesRequest((Request.Operation)operation, (String)version, sections, (String)datasetPath, (ucar.nc2.dt.GridDataset)dataset);
        } else if (operation.equals((Object)Request.Operation.DescribeCoverage)) {
            String identifiers = ServletUtil.getParameterIgnoreCase(req, "Identifiers");
            if (identifiers == null) {
                identifiers = ServletUtil.getParameterIgnoreCase(req, "Identifier");
            }
            List<String> idList = WcsRequestParser.splitCommaSeperatedList(identifiers);
            request = Request.getDescribeCoverageRequest((Request.Operation)operation, (String)version, idList, (String)datasetPath, (ucar.nc2.dt.GridDataset)dataset);
        } else if (operation.equals((Object)Request.Operation.GetCoverage)) {
            String identifier = ServletUtil.getParameterIgnoreCase(req, "Identifier");
            request = Request.getGetCoverageRequest((Request.Operation)operation, (String)version, (String)identifier, (String)datasetPath, (ucar.nc2.dt.GridDataset)dataset);
        } else {
            throw new WcsException(WcsException.Code.OperationNotSupported, requestParam, "");
        }
        return request;
    }

    private static List<String> splitCommaSeperatedList(String identifiers) {
        ArrayList<String> idList = new ArrayList<String>();
        String[] idArray = identifiers.split(",");
        for (int i = 0; i < idArray.length; ++i) {
            idList.add(idArray[i].trim());
        }
        return idList;
    }

    private static ucar.nc2.dt.GridDataset openDataset(HttpServletRequest req, HttpServletResponse res) throws WcsException {
        GridDataset dataset;
        String datasetURL = ServletUtil.getParameterIgnoreCase(req, "dataset");
        boolean isRemote = datasetURL != null;
        String datasetPath = isRemote ? datasetURL : req.getPathInfo();
        try {
            dataset = isRemote ? GridDataset.open((String)datasetPath) : DatasetHandler.openGridDataset(req, res, datasetPath);
        }
        catch (IOException e) {
            log.warn("WcsRequestParser(): Failed to open dataset <" + datasetPath + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.NoApplicableCode, null, "Failed to open dataset, \"" + datasetPath + "\".");
        }
        if (dataset == null) {
            log.debug("WcsRequestParser(): Unknown dataset <" + datasetPath + ">.");
            throw new WcsException(WcsException.Code.NoApplicableCode, null, "Unknown dataset, \"" + datasetPath + "\".");
        }
        return dataset;
    }
}

