/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.opengis.metadata.extent.GeographicBoundingBox;
import thredds.server.wms.ThreddsDataset;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.config.LayerSettings;
import uk.ac.rdg.resc.ncwms.coords.HorizontalCoordSys;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

class ThreddsVectorLayer
implements VectorLayer,
ThreddsLayer {
    private final VectorLayer wrappedLayer;
    private LayerSettings layerSettings;

    public ThreddsVectorLayer(VectorLayer wrappedLayer) {
        this.wrappedLayer = wrappedLayer;
    }

    public String getName() {
        return this.getId();
    }

    @Override
    public String getStandardName() {
        return this.getId();
    }

    public ScalarLayer getEastwardComponent() {
        return this.wrappedLayer.getEastwardComponent();
    }

    public ScalarLayer getNorthwardComponent() {
        return this.wrappedLayer.getNorthwardComponent();
    }

    @Override
    public ThreddsDataset getDataset() {
        return (ThreddsDataset)this.wrappedLayer.getDataset();
    }

    public String getId() {
        return this.wrappedLayer.getId();
    }

    public String getTitle() {
        return this.wrappedLayer.getTitle();
    }

    public String getAbstract() {
        return this.wrappedLayer.getAbstract();
    }

    public String getUnits() {
        return this.wrappedLayer.getUnits();
    }

    public GeographicBoundingBox getGeographicBoundingBox() {
        return this.wrappedLayer.getGeographicBoundingBox();
    }

    public HorizontalCoordSys getHorizontalCoordSys() {
        return this.wrappedLayer.getHorizontalCoordSys();
    }

    public Chronology getChronology() {
        return this.wrappedLayer.getChronology();
    }

    public List<DateTime> getTimeValues() {
        return this.wrappedLayer.getTimeValues();
    }

    public DateTime getCurrentTimeValue() {
        return this.wrappedLayer.getCurrentTimeValue();
    }

    public DateTime getDefaultTimeValue() {
        return this.wrappedLayer.getDefaultTimeValue();
    }

    public List<Double> getElevationValues() {
        return this.wrappedLayer.getElevationValues();
    }

    public double getDefaultElevationValue() {
        return this.wrappedLayer.getDefaultElevationValue();
    }

    public String getElevationUnits() {
        return this.wrappedLayer.getElevationUnits();
    }

    public boolean isElevationPositive() {
        return this.wrappedLayer.isElevationPositive();
    }

    @Override
    public void setLayerSettings(LayerSettings layerSettings) {
        this.layerSettings = layerSettings;
    }

    public boolean isQueryable() {
        return this.layerSettings.isAllowFeatureInfo();
    }

    public Range<Float> getApproxValueRange() {
        return this.layerSettings.getDefaultColorScaleRange();
    }

    public boolean isLogScaling() {
        return this.layerSettings.isLogScaling();
    }

    public ColorPalette getDefaultColorPalette() {
        return ColorPalette.get((String)this.layerSettings.getDefaultPaletteName());
    }

    public int getDefaultNumColorBands() {
        return this.layerSettings.getDefaultNumColorBands();
    }
}

