/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;
import org.jdom.xpath.XPath;
import thredds.server.wms.config.LayerSettings;
import thredds.server.wms.config.WmsConfigException;

class DatasetPathSettings {
    private final String pathSpec;
    private final Pattern pathSpecPattern;
    private final LayerSettings defaultSettings;
    private final Map<String, LayerSettings> settingsPerVariable;

    public DatasetPathSettings(Element el) throws WmsConfigException {
        this.pathSpec = el.getAttributeValue("pathSpec");
        this.defaultSettings = new LayerSettings(el.getChild("pathDefaults"));
        this.settingsPerVariable = new HashMap<String, LayerSettings>();
        try {
            GlobCompiler globCompiler = new GlobCompiler();
            this.pathSpecPattern = globCompiler.compile(this.pathSpec, 8);
            List variablesList = XPath.selectNodes((Object)el, (String)"variables/variable");
            for (Element variableEl : variablesList) {
                String varId = variableEl.getAttributeValue("id");
                LayerSettings varSettings = new LayerSettings(variableEl);
                this.settingsPerVariable.put(varId, varSettings);
            }
        }
        catch (Exception e) {
            throw new WmsConfigException(e);
        }
    }

    public String getPathSpec() {
        return this.pathSpec;
    }

    public boolean pathSpecMatches(String s) {
        return new Perl5Matcher().matches(s, this.pathSpecPattern);
    }

    public LayerSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public Map<String, LayerSettings> getSettingsPerVariable() {
        return this.settingsPerVariable;
    }
}

