/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Formatter;
import javax.servlet.http.HttpServletRequest;
import thredds.filesystem.CacheManager;
import thredds.servlet.Debug;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class DebugCommands {
    public DebugCommands() {
        this.makeGeneralActions();
        this.makeDebugActions();
        this.makeCacheActions();
    }

    protected void makeCacheActions() {
        DebugHandler debugHandler = DebugHandler.get("Caches");
        DebugHandler.Action act = new DebugHandler.Action("showCaches", "Show File Object Caches"){

            @Override
            public void doAction(DebugHandler.Event e) {
                Formatter f = new Formatter(e.pw);
                f.format("NetcdfFileCache contents\n", new Object[0]);
                NetcdfDataset.getNetcdfFileCache().showCache(f);
                f.format("GribCollectionFileCache contents\n", new Object[0]);
                GribCollection.getFileCache().showCache(f);
                f.format("HTTPFileCache contents\n", new Object[0]);
                ServletUtil.getFileCache().showCache(f);
                e.pw.flush();
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("clearCache", "Clear File Object Caches"){

            @Override
            public void doAction(DebugHandler.Event e) {
                NetcdfDataset.getNetcdfFileCache().clearCache(false);
                GribCollection.getFileCache().clearCache(false);
                ServletUtil.getFileCache().clearCache(false);
                e.pw.println("  ClearCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("forceNCCache", "Force clear NetcdfFile Cache"){

            @Override
            public void doAction(DebugHandler.Event e) {
                NetcdfDataset.getNetcdfFileCache().clearCache(true);
                e.pw.println("  NetcdfFileCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("forceGCCache", "Force clear GribCollection Cache"){

            @Override
            public void doAction(DebugHandler.Event e) {
                NetcdfDataset.getNetcdfFileCache().clearCache(true);
                e.pw.println("  NetcdfFileCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("forceRAFCache", "Force clear HTTP File Cache"){

            @Override
            public void doAction(DebugHandler.Event e) {
                ServletUtil.getFileCache().clearCache(true);
                e.pw.println("  RAF FileCache force clearCache done ");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showMFileCache", "Show MFile Directory Cache"){

            @Override
            public void doAction(DebugHandler.Event e) {
                Formatter f = new Formatter(e.pw);
                f.format("MFile Directory Cache %n %s %n", CacheManager.show((String)"directories"));
                e.pw.flush();
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("disableCache", "Disable NetcdfFile Caches"){

            @Override
            public void doAction(DebugHandler.Event e) {
                NetcdfDataset.disableNetcdfFileCache();
                ServletUtil.setFileCache(null);
                e.pw.println("  disableCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("disableCache", "Disable HTTP File Caches"){

            @Override
            public void doAction(DebugHandler.Event e) {
                ServletUtil.setFileCache(null);
                e.pw.println("  disableCache ok");
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("Debug");
        DebugHandler.Action act = new DebugHandler.Action("enableRafHandles", "Toggle tracking open RAF"){

            @Override
            public void doAction(DebugHandler.Event e) {
                try {
                    RandomAccessFile.setDebugLeaks((!RandomAccessFile.getDebugLeaks() ? 1 : 0) != 0);
                    e.pw.println("  Tracking RAF=" + RandomAccessFile.getDebugLeaks());
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRafHandles", "Show open RAF"){

            @Override
            public void doAction(DebugHandler.Event e) {
                try {
                    for (String s : RandomAccessFile.getOpenFiles()) {
                        e.pw.println("  " + s);
                    }
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeGeneralActions() {
        DebugHandler debugHandler = DebugHandler.get("General");
        DebugHandler.Action act = new DebugHandler.Action("showVersion", "Show Build Version"){

            @Override
            public void doAction(DebugHandler.Event e) {
                try {
                    IO.copyFile((String)(ServletUtil.getRootPath() + "/docs/README.txt"), (OutputStream)e.pw);
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRuntime", "Show Runtime info"){

            @Override
            public void doAction(DebugHandler.Event e) {
                Runtime runt = Runtime.getRuntime();
                double scale = 1.0E-6;
                e.pw.println(" freeMemory= " + scale * (double)runt.freeMemory() + " Mb");
                e.pw.println(" totalMemory= " + scale * (double)runt.totalMemory() + " Mb");
                e.pw.println(" maxMemory= " + scale * (double)runt.maxMemory() + " Mb");
                e.pw.println(" availableProcessors= " + runt.availableProcessors());
                e.pw.println();
                ServletUtil.showThreads(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showFlags", "Show Debugging Flags"){

            @Override
            public void doAction(DebugHandler.Event e) {
                DebugCommands.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("toggleFlag", null){

            @Override
            public void doAction(DebugHandler.Event e) {
                if (e.target != null) {
                    String flag;
                    Debug.set(flag, !Debug.isSet(flag = e.target));
                } else {
                    e.pw.println(" Must be toggleFlag=<flagName>");
                }
                DebugCommands.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRequest", "Show HTTP Request info"){

            @Override
            public void doAction(DebugHandler.Event e) {
                e.pw.println(ServletUtil.showRequestDetail(null, e.req));
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSystemProperties", "Show Server info"){

            @Override
            public void doAction(DebugHandler.Event e) {
                ServletUtil.showServerInfo(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSession", "Show HTTP Session info"){

            @Override
            public void doAction(DebugHandler.Event e) {
                ServletUtil.showSession(e.req, e.res, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSecurity", "Show Security info"){

            @Override
            public void doAction(DebugHandler.Event e) {
                e.pw.println(ServletUtil.showSecurity(e.req, "admin"));
            }
        };
        debugHandler.addAction(act);
    }

    void showFlags(HttpServletRequest req, PrintStream pw) {
        for (String key : Debug.keySet()) {
            String url = req.getRequestURI() + "?toggleFlag=" + key;
            pw.println("  <a href='" + url + "'>" + key + " = " + Debug.isSet(key) + "</a>");
        }
    }
}

