/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.XMLEntityResolver;
import thredds.servlet.Debug;
import thredds.servlet.HtmlWriter;
import thredds.servlet.UsageLog;
import thredds.util.RequestForwardUtils;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.nc2.util.net.EscapeStrings;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class ServletUtil {
    public static final String CONTENT_TEXT = "text/plain; charset=utf-8";
    public static final int STATUS_CLIENT_ABORT = 1000;
    public static final int STATUS_FORWARDED = 1001;
    public static final int STATUS_FORWARD_FAILURE = 1002;
    private static Logger log = LoggerFactory.getLogger(ServletUtil.class);
    private static boolean isDebugInit = false;
    private static String contextPath = null;
    private static String rootPath = null;
    private static String contentPath = null;
    private static FileCache fileCacheRaf;
    private static final FileFactory fileFactory;

    public static void initContext(ServletContext context) {
        if (contextPath == null) {
            String tmpContextPath = context.getInitParameter("ContextPath");
            if (tmpContextPath == null) {
                tmpContextPath = "thredds";
            }
            contextPath = "/" + tmpContextPath;
        }
        if (rootPath == null) {
            rootPath = context.getRealPath("/");
            rootPath = rootPath.replace('\\', '/');
        }
        if (contentPath == null) {
            String tmpContentPath = "../../content" + ServletUtil.getContextPath() + "/";
            File cf = new File(ServletUtil.getRootPath(), tmpContentPath);
            try {
                contentPath = cf.getCanonicalPath() + "/";
                contentPath = contentPath.replace('\\', '/');
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        ServletUtil.initDebugging(context);
    }

    public static void setContextPath(String newContextPath) {
        contextPath = newContextPath;
    }

    public static void setRootPath(String newRootPath) {
        rootPath = newRootPath;
    }

    public static void setContentPath(String newContentPath) {
        contentPath = newContentPath;
        if (!contentPath.endsWith("/")) {
            contentPath = contentPath + "/";
        }
    }

    public static void initDebugging(ServletContext webapp) {
        if (isDebugInit) {
            return;
        }
        isDebugInit = true;
        String debugOn = webapp.getInitParameter("DebugOn");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set(toker.nextToken(), true);
            }
        }
    }

    public static String getRootPath() {
        return rootPath;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static String getContentPath() {
        return contentPath;
    }

    public static String getInitialContentPath() {
        return ServletUtil.getRootPath() + "/WEB-INF/altContent/startup/";
    }

    public static String formFilename(String dirPath, String filePath) {
        if (dirPath == null || filePath == null) {
            return null;
        }
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return dirPath.endsWith("/") ? dirPath + filePath : dirPath + "/" + filePath;
    }

    public static void handleRequestForRawFile(String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        File rFile;
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain \"..\" directory.");
            log.info(UsageLog.closingMessageForRequestContext(403, -1L));
            return;
        }
        String upper = path.toUpperCase();
        if (upper.indexOf("WEB-INF") != -1 || upper.indexOf("META-INF") != -1) {
            res.sendError(403, "Path cannot contain \"WEB-INF\" or \"META-INF\".");
            log.info(UsageLog.closingMessageForRequestContext(403, -1L));
            return;
        }
        File regFile = null;
        File cFile = new File(ServletUtil.formFilename(ServletUtil.getContentPath(), path));
        if (cFile.exists()) {
            if (cFile.isDirectory()) {
                if (!path.endsWith("/")) {
                    String newPath = req.getRequestURL().append("/").toString();
                    ServletUtil.sendPermanentRedirect(newPath, req, res);
                }
                if ((cFile = new File(cFile, "index.html")).exists() && !cFile.isDirectory()) {
                    regFile = cFile;
                }
            } else {
                regFile = cFile;
            }
        }
        if (regFile == null && (rFile = new File(ServletUtil.formFilename(ServletUtil.getRootPath(), path))).exists()) {
            if (rFile.isDirectory()) {
                if (!path.endsWith("/")) {
                    String newPath = req.getRequestURL().append("/").toString();
                    ServletUtil.sendPermanentRedirect(newPath, req, res);
                }
                if ((rFile = new File(rFile, "index.html")).exists() && !rFile.isDirectory()) {
                    regFile = rFile;
                }
            } else {
                regFile = rFile;
            }
        }
        if (regFile == null) {
            res.sendError(404);
            log.info(UsageLog.closingMessageForRequestContext(404, -1L));
            return;
        }
        ServletUtil.returnFile(servlet, req, res, regFile, null);
    }

    public static void handleRequestForContentFile(String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletUtil.handleRequestForContentOrRootFile("/content/", path, servlet, req, res);
    }

    public static void handleRequestForRootFile(String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletUtil.handleRequestForContentOrRootFile("/root/", path, servlet, req, res);
    }

    private static void handleRequestForContentOrRootFile(String pathPrefix, String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!pathPrefix.equals("/content/") && !pathPrefix.equals("/root/")) {
            log.error("handleRequestForContentFile(): The path prefix <" + pathPrefix + "> must be \"/content/\" or \"/root/\".");
            throw new IllegalArgumentException("Path prefix must be \"/content/\" or \"/root/\".");
        }
        if (!path.startsWith(pathPrefix)) {
            log.error("handleRequestForContentFile(): path <" + path + "> must start with \"" + pathPrefix + "\".");
            throw new IllegalArgumentException("Path must start with \"" + pathPrefix + "\".");
        }
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain \"..\" directory.");
            log.info(UsageLog.closingMessageForRequestContext(403, -1L));
            return;
        }
        File file = new File(ServletUtil.formFilename(ServletUtil.getContentPath(), path.substring(pathPrefix.length() - 1)));
        if (file.exists()) {
            if (file.isDirectory()) {
                if (!path.endsWith("/")) {
                    String redirectPath = req.getRequestURL().append("/").toString();
                    ServletUtil.sendPermanentRedirect(redirectPath, req, res);
                    return;
                }
                int i = HtmlWriter.getInstance().writeDirectory(res, file, path);
                int status = i == 0 ? 404 : 200;
                log.info(UsageLog.closingMessageForRequestContext(status, i));
                return;
            }
            ServletUtil.returnFile(servlet, req, res, file, null);
        } else {
            log.info(UsageLog.closingMessageForRequestContext(404, -1L));
            res.sendError(404);
        }
    }

    public static void sendPermanentRedirect(String targetPath, HttpServletRequest req, HttpServletResponse res) throws IOException {
        URI uri;
        try {
            uri = new URI(req.getRequestURL().toString());
        }
        catch (URISyntaxException e) {
            log.error("sendPermanentRedirect(): Bad syntax on request URL <" + req.getRequestURL() + ">.", (Throwable)e);
            log.info("sendPermanentRedirect(): " + UsageLog.closingMessageForRequestContext(500, 0L));
            if (!res.isCommitted()) {
                res.sendError(500);
            }
            return;
        }
        String absolutePath = uri.resolve(targetPath).toString();
        absolutePath = res.encodeRedirectURL(absolutePath);
        res.setStatus(301);
        res.addHeader("Location", absolutePath);
        String title = "Permanently Moved - 301";
        String body = "<p>" + "The requested URL <" + req.getRequestURL() + "> has been permanently moved (HTTP status code 301)." + " Instead, please use the following URL: <a href=\"" + absolutePath + "\">" + absolutePath + "</a>." + "</p>";
        String htmlResp = HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag() + "<head><title>" + title + "</title></head><body>" + "<h1>" + title + "</h1>" + body + "</body></html>";
        log.info("sendPermanentRedirect(): redirect to " + absolutePath);
        log.info("sendPermanentRedirect(): " + UsageLog.closingMessageForRequestContext(301, htmlResp.length()));
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        out.print(htmlResp);
        out.flush();
    }

    public static void returnFile(HttpServlet servlet, String contentPath, String path, HttpServletRequest req, HttpServletResponse res, String contentType) throws IOException {
        String filename = ServletUtil.formFilename(contentPath, path);
        log.debug("returnFile(): returning file <" + filename + ">.");
        if (filename == null) {
            log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(404, 0L));
            res.sendError(404);
            return;
        }
        if (filename.indexOf("..") != -1) {
            log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(403, 0L));
            res.sendError(403);
            return;
        }
        String upper = filename.toUpperCase();
        if (upper.indexOf("WEB-INF") != -1 || upper.indexOf("META-INF") != -1) {
            log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(403, 0L));
            res.sendError(403);
            return;
        }
        ServletUtil.returnFile(servlet, req, res, new File(filename), contentType);
    }

    public static void setFileCache(FileCache fileCache) {
        fileCacheRaf = fileCache;
    }

    public static FileCache getFileCache() {
        return fileCacheRaf;
    }

    public static void returnFile(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res, File file, String contentType) throws IOException {
        if (file == null) {
            log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(404, 0L));
            res.sendError(404);
            return;
        }
        if (!file.exists()) {
            log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(404, 0L));
            res.sendError(404);
            return;
        }
        if (!file.isFile()) {
            log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(400, 0L));
            res.sendError(400);
            return;
        }
        String filename = file.getPath();
        if (null == contentType && (contentType = filename.endsWith(".html") ? "text/html; charset=iso-8859-1" : (filename.endsWith(".xml") ? "text/xml; charset=iso-8859-1" : (filename.endsWith(".txt") || filename.endsWith(".log") ? CONTENT_TEXT : (filename.indexOf(".log.") > 0 ? CONTENT_TEXT : (filename.endsWith(".nc") ? "application/x-netcdf" : servlet.getServletContext().getMimeType(filename)))))) == null) {
            contentType = "application/octet-stream";
        }
        ServletUtil.returnFile(req, res, file, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnFile(HttpServletRequest req, HttpServletResponse res, File file, String contentType) throws IOException {
        block19: {
            long fileSize;
            int pos2;
            int pos;
            res.setContentType(contentType);
            boolean isRangeRequest = false;
            long startPos = 0L;
            long endPos = Long.MAX_VALUE;
            String rangeRequest = req.getHeader("Range");
            if (rangeRequest != null && (pos = rangeRequest.indexOf("=")) > 0 && (pos2 = rangeRequest.indexOf("-")) > 0) {
                String startString = rangeRequest.substring(pos + 1, pos2);
                String endString = rangeRequest.substring(pos2 + 1);
                startPos = Long.parseLong(startString);
                if (endString.length() > 0) {
                    endPos = Long.parseLong(endString) + 1L;
                }
                isRangeRequest = true;
            }
            long contentLength = fileSize = file.length();
            if (isRangeRequest) {
                endPos = Math.min(endPos, fileSize);
                contentLength = endPos - startPos;
            }
            if (contentLength > Integer.MAX_VALUE) {
                res.addHeader("Content-Length", Long.toString(contentLength));
            } else {
                res.setContentLength((int)contentLength);
            }
            String filename = file.getPath();
            boolean debugRequest = Debug.isSet("returnFile");
            if (debugRequest) {
                log.debug("returnFile(): filename = " + filename + " contentType = " + contentType + " contentLength = " + contentLength);
            }
            res.addHeader("Accept-Ranges", "bytes");
            if (req.getMethod().equals("HEAD")) {
                log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(200, 0L));
                return;
            }
            try {
                if (isRangeRequest) {
                    res.addHeader("Content-Range", "bytes " + startPos + "-" + (endPos - 1L) + "/" + fileSize);
                    res.setStatus(206);
                    RandomAccessFile craf = null;
                    try {
                        craf = (RandomAccessFile)fileCacheRaf.acquire(fileFactory, filename, null);
                        IO.copyRafB((RandomAccessFile)craf, (long)startPos, (long)contentLength, (OutputStream)res.getOutputStream(), (byte[])new byte[60000]);
                        log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(206, contentLength));
                        return;
                    }
                    finally {
                        if (craf != null) {
                            fileCacheRaf.release((FileCacheable)craf);
                        }
                    }
                }
                ServletOutputStream out = res.getOutputStream();
                IO.copyFileB((File)file, (OutputStream)out, (int)60000);
                res.flushBuffer();
                out.close();
                if (debugRequest) {
                    log.debug("returnFile(): returnFile ok = " + filename);
                }
                log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(200, contentLength));
            }
            catch (FileNotFoundException e) {
                log.error("returnFile(): FileNotFoundException= " + filename);
                log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(404, 0L));
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (SocketException e) {
                log.info("returnFile(): SocketException sending file: " + filename + " " + e.getMessage());
                log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(1000, 0L));
            }
            catch (IOException e) {
                String eName = e.getClass().getName();
                if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
                    log.info("returnFile(): ClientAbortException while sending file: " + filename + " " + e.getMessage());
                    log.info("returnFile(): " + UsageLog.closingMessageForRequestContext(1000, 0L));
                    return;
                }
                log.error("returnFile(): IOException (" + e.getClass().getName() + ") sending file ", (Throwable)e);
                log.error("returnFile(): " + UsageLog.closingMessageForRequestContext(404, 0L));
                if (res.isCommitted()) break block19;
                res.sendError(404, "Problem sending file: " + e.getMessage());
            }
        }
    }

    public static void returnString(String contents, HttpServletResponse res) throws IOException {
        try {
            ServletOutputStream out = res.getOutputStream();
            IO.copy((InputStream)new ByteArrayInputStream(contents.getBytes()), (OutputStream)out);
            log.info(UsageLog.closingMessageForRequestContext(200, contents.length()));
        }
        catch (IOException e) {
            log.error(" IOException sending string: ", (Throwable)e);
            log.info(UsageLog.closingMessageForRequestContext(404, 0L));
            res.sendError(404, "Problem sending string: " + e.getMessage());
        }
    }

    public static String getReletiveURL(HttpServletRequest req) {
        return req.getContextPath() + req.getServletPath() + req.getPathInfo();
    }

    public static void forwardToCatalogServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String reqs = "catalog=" + ServletUtil.getReletiveURL(req);
        String query = req.getQueryString();
        if (query != null) {
            reqs = reqs + "&" + query;
        }
        log.info("forwardToCatalogServices(): request string = \"/catalog.html?" + reqs + "\"");
        RequestForwardUtils.forwardRequestRelativeToCurrentContext("/catalog.html?" + reqs, req, res);
    }

    public static boolean saveFile(HttpServlet servlet, String contentPath, String path, HttpServletRequest req, HttpServletResponse res) {
        boolean debugRequest = Debug.isSet("SaveFile");
        if (debugRequest) {
            log.debug(" saveFile(): path= " + path);
        }
        String filename = contentPath + path;
        File want = new File(filename);
        int version = ServletUtil.getBackupVersion(want.getParent(), want.getName());
        String fileSave = filename + "~" + version;
        File file = new File(filename);
        if (file.exists()) {
            try {
                IO.copyFile((String)filename, (String)fileSave);
            }
            catch (IOException e) {
                log.error("saveFile(): Unable to save copy of file " + filename + " to " + fileSave + "\n" + e.getMessage());
                return false;
            }
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
            IO.copy((InputStream)req.getInputStream(), (OutputStream)out);
            ((OutputStream)out).close();
            if (debugRequest) {
                log.debug("saveFile(): ok= " + filename);
            }
            res.setStatus(201);
            log.info(UsageLog.closingMessageForRequestContext(201, -1L));
            return true;
        }
        catch (IOException e) {
            log.error("saveFile(): Unable to PUT file " + filename + " to " + fileSave + "\n" + e.getMessage());
            return false;
        }
    }

    private static int getBackupVersion(String dirName, String fileName) {
        int maxN = 0;
        File dir = new File(dirName);
        if (!dir.exists()) {
            return -1;
        }
        String[] files = dir.list();
        if (null == files) {
            return -1;
        }
        for (String name : files) {
            int pos;
            if (name.indexOf(fileName) < 0 || (pos = name.indexOf(126)) < 0) continue;
            String ver = name.substring(pos + 1);
            int n = 0;
            try {
                n = Integer.parseInt(ver);
            }
            catch (NumberFormatException e) {
                log.error("Format Integer error on backup filename= " + ver);
            }
            maxN = Math.max(n, maxN);
        }
        return maxN + 1;
    }

    public static boolean copyDir(String fromDir, String toDir) throws IOException {
        File contentFile = new File(toDir + ".INIT");
        if (!contentFile.exists()) {
            IO.copyDirTree((String)fromDir, (String)toDir);
            contentFile.createNewFile();
            return true;
        }
        return false;
    }

    public static void handleException(Throwable t, HttpServletResponse res) {
        try {
            String message = t.getMessage();
            if (message == null) {
                message = "NULL message " + t.getClass().getName();
            }
            if (Debug.isSet("trustedMode")) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bs);
                t.printStackTrace(ps);
                message = new String(bs.toByteArray());
            }
            log.info(UsageLog.closingMessageForRequestContext(400, message.length()));
            log.error("handleException", t);
            t.printStackTrace();
            if (!res.isCommitted()) {
                res.sendError(400, message);
            }
        }
        catch (Throwable e) {
            log.error("handleException() had problem reporting Exception", e);
            t.printStackTrace();
        }
    }

    public static void showServerInfo(PrintStream out) {
        out.println("Server Info");
        out.println(" getDocumentBuilderFactoryVersion(): " + XMLEntityResolver.getDocumentBuilderFactoryVersion());
        out.println();
        Properties sysp = System.getProperties();
        Enumeration<?> e = sysp.propertyNames();
        ArrayList<String> list = Collections.list(e);
        Collections.sort(list);
        out.println("System Properties:");
        for (String name : list) {
            String value = System.getProperty(name);
            out.println("  " + name + " = " + value);
        }
        out.println();
    }

    public static void showServletInfo(HttpServlet servlet, PrintStream out) {
        String name;
        out.println("Servlet Info");
        out.println(" getServletName(): " + servlet.getServletName());
        out.println(" getRootPath(): " + ServletUtil.getRootPath());
        out.println(" Init Parameters:");
        Enumeration params = servlet.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name2 = (String)params.nextElement();
            out.println("  " + name2 + ": " + servlet.getInitParameter(name2));
        }
        out.println();
        ServletContext context = servlet.getServletContext();
        out.println("Context Info");
        try {
            out.println(" context.getResource('/'): " + context.getResource("/"));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        out.println(" context.getServerInfo(): " + context.getServerInfo());
        out.println("  name: " + ServletUtil.getServerInfoName(context.getServerInfo()));
        out.println("  version: " + ServletUtil.getServerInfoVersion(context.getServerInfo()));
        out.println(" context.getInitParameterNames():");
        params = context.getInitParameterNames();
        while (params.hasMoreElements()) {
            name = (String)params.nextElement();
            out.println("  " + name + ": " + context.getInitParameter(name));
        }
        out.println(" context.getAttributeNames():");
        params = context.getAttributeNames();
        while (params.hasMoreElements()) {
            name = (String)params.nextElement();
            out.println("  context.getAttribute(\"" + name + "\"): " + context.getAttribute(name));
        }
        out.println();
    }

    public static String getRequestParsed(HttpServletRequest req) {
        return req.getRequestURI() + " = " + req.getContextPath() + "(context), " + req.getServletPath() + "(servletPath), " + req.getPathInfo() + "(pathInfo), " + req.getQueryString() + "(query)";
    }

    public static String getRequestServer(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
    }

    public static String getRequestBase(HttpServletRequest req) {
        return req.getRequestURL().toString();
    }

    public static URI getRequestURI(HttpServletRequest req) {
        try {
            return new URI(ServletUtil.getRequestBase(req));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRequestPath(HttpServletRequest req) {
        StringBuffer buff = new StringBuffer();
        if (req.getServletPath() != null) {
            buff.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            buff.append(req.getPathInfo());
        }
        return buff.toString();
    }

    public static String getRequest(HttpServletRequest req) {
        String query = req.getQueryString();
        return ServletUtil.getRequestBase(req) + (query == null ? "" : "?" + query);
    }

    public static String getParameterIgnoreCase(HttpServletRequest req, String paramName) {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equalsIgnoreCase(paramName)) continue;
            return req.getParameter(s);
        }
        return null;
    }

    public static String[] getParameterValuesIgnoreCase(HttpServletRequest req, String paramName) {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equalsIgnoreCase(paramName)) continue;
            return req.getParameterValues(s);
        }
        return null;
    }

    public static String getFileURL(String filename) {
        filename = filename.replace('\\', '/');
        filename = StringUtil2.replace((String)filename, (char)' ', (String)"+");
        return "file:" + filename;
    }

    public static String showRequestDetail(HttpServlet servlet, HttpServletRequest req) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Request Info\n");
        sbuff.append(" req.getServerName(): ").append(req.getServerName()).append("\n");
        sbuff.append(" req.getServerPort(): ").append(req.getServerPort()).append("\n");
        sbuff.append(" req.getContextPath:").append(req.getContextPath()).append("\n");
        sbuff.append(" req.getServletPath:").append(req.getServletPath()).append("\n");
        sbuff.append(" req.getPathInfo:").append(req.getPathInfo()).append("\n");
        sbuff.append(" req.getQueryString:").append(req.getQueryString()).append("\n");
        sbuff.append(" getQueryStringDecoded:").append(EscapeStrings.urlDecode((String)req.getQueryString())).append("\n");
        sbuff.append(" req.getRequestURI:").append(req.getRequestURI()).append("\n");
        sbuff.append(" getRequestBase:").append(ServletUtil.getRequestBase(req)).append("\n");
        sbuff.append(" getRequestServer:").append(ServletUtil.getRequestServer(req)).append("\n");
        sbuff.append(" getRequest:").append(ServletUtil.getRequest(req)).append("\n");
        sbuff.append("\n");
        sbuff.append(" req.getPathTranslated:").append(req.getPathTranslated()).append("\n");
        String path = req.getPathTranslated();
        if (path != null && servlet != null) {
            ServletContext context = servlet.getServletContext();
            sbuff.append(" getMimeType:").append(context.getMimeType(path)).append("\n");
        }
        sbuff.append("\n");
        sbuff.append(" req.getScheme:").append(req.getScheme()).append("\n");
        sbuff.append(" req.getProtocol:").append(req.getProtocol()).append("\n");
        sbuff.append(" req.getMethod:").append(req.getMethod()).append("\n");
        sbuff.append("\n");
        sbuff.append(" req.getContentType:").append(req.getContentType()).append("\n");
        sbuff.append(" req.getContentLength:").append(req.getContentLength()).append("\n");
        sbuff.append(" req.getRemoteAddr():").append(req.getRemoteAddr());
        try {
            sbuff.append(" getRemoteHost():").append(InetAddress.getByName(req.getRemoteHost()).getHostName()).append("\n");
        }
        catch (UnknownHostException e) {
            sbuff.append(" getRemoteHost():").append(e.getMessage()).append("\n");
        }
        sbuff.append(" getRemoteUser():").append(req.getRemoteUser()).append("\n");
        sbuff.append("\n");
        sbuff.append("Request Parameters:\n");
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                sbuff.append("  ").append(name).append("  (").append(i).append("): ").append(values[i]).append("\n");
            }
        }
        sbuff.append("\n");
        sbuff.append("Request Headers:\n");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                sbuff.append("  ").append(name).append(": ").append(value).append("\n");
            }
        }
        sbuff.append(" ------------------\n");
        return sbuff.toString();
    }

    public static String showRequestHeaders(HttpServletRequest req) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Request Headers:\n");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                sbuff.append("  ").append(name).append(": ").append(value).append("\n");
            }
        }
        return sbuff.toString();
    }

    public static void showSession(HttpServletRequest req, HttpServletResponse res, PrintStream out) {
        HttpSession session = req.getSession();
        Integer count = (Integer)session.getAttribute("snoop.count");
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        session.setAttribute("snoop.count", (Object)count);
        out.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        out.println("<HEAD><TITLE>SessionSnoop</TITLE></HEAD>");
        out.println("<BODY><H1>Session Snoop</H1>");
        out.println("You've visited this page " + count + (count == 1 ? " time." : " times."));
        out.println("<P>");
        out.println("<H3>Here is your saved session data:</H3>");
        Enumeration atts = session.getAttributeNames();
        while (atts.hasMoreElements()) {
            String name = (String)atts.nextElement();
            out.println(name + ": " + session.getAttribute(name) + "<BR>");
        }
        out.println("<H3>Here are some vital stats on your session:</H3>");
        out.println("Session id: " + session.getId() + " <I>(keep it secret)</I><BR>");
        out.println("New session: " + session.isNew() + "<BR>");
        out.println("Timeout: " + session.getMaxInactiveInterval());
        out.println("<I>(" + session.getMaxInactiveInterval() / 60 + " minutes)</I><BR>");
        out.println("Creation time: " + session.getCreationTime());
        out.println("<I>(" + new Date(session.getCreationTime()) + ")</I><BR>");
        out.println("Last access time: " + session.getLastAccessedTime());
        out.println("<I>(" + new Date(session.getLastAccessedTime()) + ")</I><BR>");
        out.println("Requested session ID from cookie: " + req.isRequestedSessionIdFromCookie() + "<BR>");
        out.println("Requested session ID from URL: " + req.isRequestedSessionIdFromURL() + "<BR>");
        out.println("Requested session ID valid: " + req.isRequestedSessionIdValid() + "<BR>");
        out.println("<H3>Test URL Rewriting</H3>");
        out.println("Click <A HREF=\"" + res.encodeURL(req.getRequestURI()) + "\">here</A>");
        out.println("to test that session tracking works via URL");
        out.println("rewriting even when cookies aren't supported.");
        out.println("</BODY></HTML>");
    }

    public static void showSession(HttpServletRequest req, PrintStream out) {
        HttpSession session = req.getSession();
        out.println("Session id: " + session.getId());
        out.println(" session.isNew(): " + session.isNew());
        out.println(" session.getMaxInactiveInterval(): " + session.getMaxInactiveInterval() + " secs");
        out.println(" session.getCreationTime(): " + session.getCreationTime() + " (" + new Date(session.getCreationTime()) + ")");
        out.println(" session.getLastAccessedTime(): " + session.getLastAccessedTime() + " (" + new Date(session.getLastAccessedTime()) + ")");
        out.println(" req.isRequestedSessionIdFromCookie: " + req.isRequestedSessionIdFromCookie());
        out.println(" req.isRequestedSessionIdFromURL: " + req.isRequestedSessionIdFromURL());
        out.println(" req.isRequestedSessionIdValid: " + req.isRequestedSessionIdValid());
        out.println("Saved session Attributes:");
        Enumeration atts = session.getAttributeNames();
        while (atts.hasMoreElements()) {
            String name = (String)atts.nextElement();
            out.println(" " + name + ": " + session.getAttribute(name) + "<BR>");
        }
    }

    public static String showSecurity(HttpServletRequest req, String role) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Security Info\n");
        sbuff.append(" req.getRemoteUser(): ").append(req.getRemoteUser()).append("\n");
        sbuff.append(" req.getUserPrincipal(): ").append(req.getUserPrincipal()).append("\n");
        sbuff.append(" req.isUserInRole(").append(role).append("):").append(req.isUserInRole(role)).append("\n");
        sbuff.append(" ------------------\n");
        return sbuff.toString();
    }

    private static String getServerInfoName(String serverInfo) {
        int slash = serverInfo.indexOf(47);
        if (slash == -1) {
            return serverInfo;
        }
        return serverInfo.substring(0, slash);
    }

    private static String getServerInfoVersion(String serverInfo) {
        int slash = serverInfo.indexOf(47);
        if (slash == -1) {
            return null;
        }
        int space = serverInfo.indexOf(32, slash);
        if (space == -1) {
            space = serverInfo.length();
        }
        return serverInfo.substring(slash + 1, space);
    }

    public static void showThreads(PrintStream pw) {
        Thread current = Thread.currentThread();
        ThreadGroup group = current.getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        ServletUtil.showThreads(pw, group, current);
    }

    private static void showThreads(PrintStream pw, ThreadGroup g, Thread current) {
        int nthreads = g.activeCount();
        pw.println("\nThread Group = " + g.getName() + " activeCount= " + nthreads);
        Thread[] tarray = new Thread[nthreads];
        int n = g.enumerate(tarray, false);
        for (int i = 0; i < n; ++i) {
            Thread thread = tarray[i];
            ClassLoader loader = thread.getContextClassLoader();
            String loaderName = loader == null ? "Default" : loader.getClass().getName();
            Thread.State state = thread.getState();
            long id = thread.getId();
            pw.print("   " + id + " " + thread.getName() + " " + (Object)((Object)state) + " " + loaderName);
            if (thread == current) {
                pw.println(" **** CURRENT ***");
                continue;
            }
            pw.println();
        }
        int ngroups = g.activeGroupCount();
        ThreadGroup[] garray = new ThreadGroup[ngroups];
        int ng = g.enumerate(garray, false);
        for (int i = 0; i < ng; ++i) {
            ThreadGroup nested = garray[i];
            ServletUtil.showThreads(pw, nested, current);
        }
    }

    static {
        fileFactory = new FileFactory(){

            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                return new RandomAccessFile(location, "r");
            }
        };
    }
}

