/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ViewServlet;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.xml.RuntimeConfigParser;

public class ThreddsConfig {
    private static Logger log = LoggerFactory.getLogger(ThreddsConfig.class);
    private static String _filename;
    private static Element rootElem;
    private static List<String> catalogRoots;
    private static List<String> contentRootList;

    public static void init(String filename) {
        _filename = filename;
        ThreddsConfig.readConfig();
    }

    static void readConfig() {
        Element elem2;
        Document doc;
        catalogRoots = new ArrayList<String>();
        contentRootList = new ArrayList<String>();
        File file = new File(_filename);
        if (!file.exists()) {
            return;
        }
        System.out.println("ThreddsConfig:INFO: reading xml file = " + _filename);
        try {
            FileInputStream is = new FileInputStream(_filename);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)is);
        }
        catch (IOException e) {
            System.out.println("ThreddsConfig:ERROR: incorrectly formed xml file [" + _filename + "]: " + e.getMessage());
            return;
        }
        catch (JDOMException e) {
            System.out.println("ThreddsConfig:ERROR: incorrectly formed xml file [" + _filename + "]: " + e.getMessage());
            return;
        }
        rootElem = doc.getRootElement();
        List rootList = rootElem.getChildren("catalogRoot");
        for (Element catrootElem : rootList) {
            String location = StringUtils.cleanPath((String)catrootElem.getTextNormalize());
            if (location.length() <= 0) continue;
            catalogRoots.add(location);
            System.out.println("ThreddsConfig:INFO: adding catalogRoot = " + location);
        }
        Element contentRootsElem = rootElem.getChild("contentRoots");
        if (contentRootsElem != null) {
            List contentRootElemList = contentRootsElem.getChildren("contentRoot");
            for (Element curRoot : contentRootElemList) {
                String location = StringUtils.cleanPath((String)curRoot.getTextNormalize());
                if (location.isEmpty()) continue;
                contentRootList.add(location);
                System.out.println("ThreddsConfig:INFO: adding contentRoot [" + location + "].");
            }
        }
        List viewerList = rootElem.getChildren("Viewer");
        for (Element elem2 : viewerList) {
            String className = elem2.getText().trim();
            ViewServlet.registerViewer(className);
        }
        List sourceList = rootElem.getChildren("datasetSource");
        for (Element elem3 : sourceList) {
            String className = elem3.getText().trim();
            DatasetHandler.registerDatasetSource(className);
        }
        elem2 = rootElem.getChild("nj22Config");
        if (elem2 != null) {
            StringBuilder errlog = new StringBuilder();
            RuntimeConfigParser.read((Element)elem2, (StringBuilder)errlog);
            if (errlog.length() > 0) {
                System.out.println("ThreddsConfig:WARN: " + errlog.toString());
            }
        }
    }

    static void getCatalogRoots(List<String> extraList) {
        extraList.addAll(catalogRoots);
    }

    public static List<String> getContentRootList() {
        return Collections.unmodifiableList(contentRootList);
    }

    public static String get(String paramName, String defValue) {
        String s = ThreddsConfig.getParam(paramName);
        return s == null ? defValue : s;
    }

    public static boolean hasElement(String paramName) {
        Element elem = rootElem;
        if (elem == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(paramName, ".");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (null != (elem = elem.getChild(toke))) continue;
            return false;
        }
        return true;
    }

    public static boolean getBoolean(String paramName, boolean defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not a boolean: " + e.getMessage());
            return defValue;
        }
    }

    public static long getBytes(String paramName, long defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        String num = s;
        try {
            long factor = 1L;
            int pos = s.indexOf(32);
            if (pos > 0) {
                num = s.substring(0, pos);
                String units = s.substring(pos + 1).trim();
                char c = Character.toUpperCase(units.charAt(0));
                if (c == 'K') {
                    factor = 1000L;
                } else if (c == 'M') {
                    factor = 1000000L;
                } else if (c == 'G') {
                    factor = 1000000000L;
                } else if (c == 'T') {
                    factor = 1000000000000L;
                } else if (c == 'P') {
                    factor = 1000000000000000L;
                }
            }
            return factor * Long.parseLong(num);
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not a byte count: " + s + " " + e.getMessage());
            return defValue;
        }
    }

    public static int getInt(String paramName, int defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not an integer " + e.getMessage());
            return defValue;
        }
    }

    public static int getSeconds(String paramName, int defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            TimeDuration tu = new TimeDuration(s);
            return (int)tu.getValueInSeconds();
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not udunit time " + e.getMessage());
            return defValue;
        }
    }

    private static String getParam(String name) {
        Element elem = rootElem;
        if (elem == null) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(name, ".");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (null != (elem = elem.getChild(toke))) continue;
            return null;
        }
        String text = elem.getText();
        return text == null ? null : text.trim();
    }
}

