/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.MDC;

public class UsageLog {
    private static AtomicLong logServerAccessId = new AtomicLong(0L);

    public static String setupRequestContext(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        MDC.put((String)"ID", (String)Long.toString(logServerAccessId.incrementAndGet()));
        MDC.put((String)"host", (String)req.getRemoteHost());
        MDC.put((String)"ident", (String)(session == null ? "-" : session.getId()));
        MDC.put((String)"userid", (String)(req.getRemoteUser() != null ? req.getRemoteUser() : "-"));
        MDC.put((String)"startTime", (String)Long.toString(System.currentTimeMillis()));
        String query = req.getQueryString();
        query = query != null ? "?" + query : "";
        StringBuffer request = new StringBuffer();
        request.append("\"").append(req.getMethod()).append(" ").append(req.getRequestURI()).append(query).append(" ").append(req.getProtocol()).append("\"");
        MDC.put((String)"request", (String)request.toString());
        return "Remote host: " + req.getRemoteHost() + " - Request: " + request.toString();
    }

    public static String closingMessageForRequestContext(int resCode, long resSizeInBytes) {
        long duration = UsageLog.calculateElapsedTime();
        return "Request Completed - " + resCode + " - " + resSizeInBytes + " - " + duration;
    }

    public static String setupNonRequestContext() {
        MDC.put((String)"ID", (String)Long.toString(logServerAccessId.incrementAndGet()));
        MDC.put((String)"startTime", (String)Long.toString(System.currentTimeMillis()));
        return "Non-request thread opening.";
    }

    public static String closingMessageNonRequestContext() {
        long duration = UsageLog.calculateElapsedTime();
        return "Non-request thread closing - " + duration;
    }

    private static long calculateElapsedTime() {
        long endTime = System.currentTimeMillis();
        long startTime = Long.parseLong(MDC.get((String)"startTime"));
        long duration = endTime - startTime;
        return duration;
    }
}

