/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.ServiceType;
import thredds.server.wms.Godiva2Viewer;
import thredds.servlet.AbstractServlet;
import thredds.servlet.ServletUtil;
import thredds.servlet.UsageLog;
import thredds.servlet.Viewer;
import thredds.servlet.ViewerLinkProvider;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

public class ViewServlet
extends AbstractServlet {
    private static Logger log = LoggerFactory.getLogger(ViewServlet.class);
    private static HashMap<String, String> templates = new HashMap();
    private static ArrayList<Viewer> viewerList = new ArrayList();

    public static void registerViewer(String className) {
        Object instance;
        Class<?> vClass;
        try {
            vClass = ViewServlet.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("Attempt to load Viewer class " + className + " not found");
            return;
        }
        if (!Viewer.class.isAssignableFrom(vClass)) {
            log.error("Attempt to load class " + className + " does not implement " + Viewer.class.getName());
            return;
        }
        try {
            instance = vClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Attempt to load Viewer class " + className + " cannot instantiate, probably need default Constructor.");
            return;
        }
        catch (IllegalAccessException e) {
            log.error("Attempt to load Viewer class " + className + " is not accessible.");
            return;
        }
        ViewServlet.registerViewer((Viewer)instance);
    }

    public static void registerViewer(Viewer v) {
        viewerList.add(v);
    }

    private static String getTemplate(String path) {
        String template = templates.get(path);
        if (template != null) {
            return template;
        }
        try {
            template = IO.readFile((String)path);
        }
        catch (IOException ioe) {
            return null;
        }
        templates.put(path, template);
        return template;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization done -  " + UsageLog.closingMessageNonRequestContext());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            log.info(UsageLog.setupRequestContext(req));
            String path = req.getPathInfo();
            int pos = path.lastIndexOf("/");
            String filename = "views/" + path.substring(pos + 1);
            log.debug("**ViewManager req= " + path + " look for " + ServletUtil.getRootPath() + "/" + filename);
            String template = ViewServlet.getTemplate(ServletUtil.getRootPath() + "/WEB-INF/" + filename);
            if (template == null) {
                template = ViewServlet.getTemplate(this.contentPath + "/" + filename);
            }
            if (template == null) {
                log.info(UsageLog.closingMessageForRequestContext(404, 0L));
                res.sendError(404);
                return;
            }
            StringBuilder sbuff = new StringBuilder(template);
            Enumeration params = req.getParameterNames();
            while (params.hasMoreElements()) {
                String name = (String)params.nextElement();
                String[] values = req.getParameterValues(name);
                if (values == null) continue;
                String sname = "{" + name + "}";
                for (String value : values) {
                    StringUtil2.substitute((StringBuilder)sbuff, (String)sname, (String)value);
                }
            }
            try {
                res.setContentType("application/x-java-jnlp-file");
                ServletUtil.returnString(sbuff.toString(), res);
            }
            catch (Throwable t) {
                log.error(" jnlp=" + sbuff.toString(), t);
                log.info(UsageLog.closingMessageForRequestContext(500, 0L));
                if (res.isCommitted()) break block6;
                res.sendError(500);
            }
        }
    }

    public static void showViewers(StringBuilder sbuff, InvDatasetImpl dataset, HttpServletRequest req) {
        int count = 0;
        for (Viewer viewer : viewerList) {
            if (!viewer.isViewable(dataset)) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        sbuff.append("<h3>Viewers:</h3><ul>\r\n");
        for (Viewer viewer : viewerList) {
            if (!viewer.isViewable(dataset)) continue;
            if (viewer instanceof ViewerLinkProvider) {
                List<ViewerLinkProvider.ViewerLink> sp = ((ViewerLinkProvider)viewer).getViewerLinks(dataset, req);
                for (ViewerLinkProvider.ViewerLink vl : sp) {
                    if (!(vl.getUrl() != null & !vl.getUrl().equals(""))) continue;
                    sbuff.append("<li><a href='").append(vl.getUrl()).append("'>").append(vl.getTitle() != null ? vl.getTitle() : vl.getUrl()).append("</a></li>\n");
                }
                continue;
            }
            String viewerLinkHtml = viewer.getViewerLinkHtml(dataset, req);
            if (viewerLinkHtml == null) continue;
            sbuff.append("  <li> ");
            sbuff.append(viewerLinkHtml);
            sbuff.append("</li>\n");
        }
        sbuff.append("</ul>\r\n");
    }

    @Override
    protected String getPath() {
        return "view/";
    }

    @Override
    protected void makeDebugActions() {
    }

    static {
        ViewServlet.registerViewer(new IDV());
        ViewServlet.registerViewer(new ToolsUI());
        ViewServlet.registerViewer(new Godiva2Viewer());
        ViewServlet.registerViewer(new StaticView());
    }

    protected static class StaticView
    implements ViewerLinkProvider {
        private final String propertyNamePrefix = "viewer";

        protected StaticView() {
        }

        @Override
        public boolean isViewable(InvDatasetImpl ds) {
            return this.hasViewerProperties(ds);
        }

        @Override
        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            List<ViewerLinkProvider.ViewerLink> viewerLinks = this.getViewerLinks(ds, req);
            if (viewerLinks.isEmpty()) {
                return null;
            }
            ViewerLinkProvider.ViewerLink firstLink = viewerLinks.get(0);
            return "<a href='" + firstLink.getUrl() + "'>" + firstLink.getTitle() + "</a>";
        }

        @Override
        public List<ViewerLinkProvider.ViewerLink> getViewerLinks(InvDatasetImpl ds, HttpServletRequest req) {
            List<InvProperty> viewerProperties = this.findViewerProperties(ds);
            if (viewerProperties.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ViewerLinkProvider.ViewerLink> result = new ArrayList<ViewerLinkProvider.ViewerLink>();
            for (InvProperty p : viewerProperties) {
                ViewerLinkProvider.ViewerLink viewerLink = this.parseViewerPropertyValue(p.getName(), p.getValue(), ds, req);
                if (viewerLink == null) continue;
                result.add(viewerLink);
            }
            return result;
        }

        private ViewerLinkProvider.ViewerLink parseViewerPropertyValue(String viewerName, String viewerValue, InvDatasetImpl ds, HttpServletRequest req) {
            String viewerTitle;
            String viewerUrl;
            int lastCommaLocation = viewerValue.lastIndexOf(",");
            if (lastCommaLocation != -1) {
                viewerUrl = viewerValue.substring(0, lastCommaLocation);
                viewerTitle = viewerValue.substring(lastCommaLocation + 1);
                if (viewerUrl.equals("")) {
                    return null;
                }
                if (viewerTitle.equals("")) {
                    viewerTitle = viewerName;
                }
            } else {
                viewerUrl = viewerValue;
                viewerTitle = viewerName;
            }
            viewerUrl = StringUtil2.quoteHtmlContent((String)this.sub(viewerUrl, ds, req));
            ViewerLinkProvider.ViewerLink viewerLink = new ViewerLinkProvider.ViewerLink(viewerTitle, viewerUrl);
            return viewerLink;
        }

        private boolean hasViewerProperties(InvDatasetImpl ds) {
            for (InvProperty p : ds.getProperties()) {
                if (!p.getName().startsWith("viewer")) continue;
                return true;
            }
            return false;
        }

        private List<InvProperty> findViewerProperties(InvDatasetImpl ds) {
            ArrayList<InvProperty> result = new ArrayList<InvProperty>();
            for (InvProperty p : ds.getProperties()) {
                if (!p.getName().startsWith("viewer")) continue;
                result.add(p);
            }
            return result;
        }

        private String sub(String org, InvDatasetImpl ds, HttpServletRequest req) {
            List access = ds.getAccess();
            if (access.size() == 0) {
                return org;
            }
            for (InvAccess acc : access) {
                String sname = "{" + acc.getService().getServiceType() + "}";
                if (org.indexOf(sname) < 0) continue;
                return StringUtil2.substitute((String)org, (String)sname, (String)acc.getStandardUri().toString());
            }
            String sname = "{url}";
            if (org.indexOf(sname) >= 0 && access.size() > 0) {
                InvAccess acc;
                acc = (InvAccess)access.get(0);
                return StringUtil2.substitute((String)org, (String)sname, (String)acc.getStandardUri().toString());
            }
            return org;
        }
    }

    private static class IDV
    implements Viewer {
        private IDV() {
        }

        @Override
        public boolean isViewable(InvDatasetImpl ds) {
            InvAccess access = this.getOpendapAccess(ds);
            if (access == null) {
                return false;
            }
            FeatureType dt = ds.getDataType();
            return dt == FeatureType.GRID;
        }

        @Override
        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            InvAccess access = this.getOpendapAccess(ds);
            URI dataURI = access.getStandardUri();
            if (!dataURI.isAbsolute()) {
                try {
                    URI base = new URI(req.getRequestURL().toString());
                    dataURI = base.resolve(dataURI);
                }
                catch (URISyntaxException e) {
                    log.error("Resolve URL with " + req.getRequestURL(), (Throwable)e);
                }
            }
            return "<a href='" + req.getContextPath() + "/view/idv.jnlp?url=" + dataURI.toString() + "'>Integrated Data Viewer (IDV) (webstart)</a>";
        }

        private InvAccess getOpendapAccess(InvDatasetImpl ds) {
            InvAccess access = ds.getAccess(ServiceType.DODS);
            if (access == null) {
                access = ds.getAccess(ServiceType.OPENDAP);
            }
            return access;
        }
    }

    private static class ToolsUI
    implements Viewer {
        private ToolsUI() {
        }

        @Override
        public boolean isViewable(InvDatasetImpl ds) {
            String id = ds.getID();
            return id != null && ds.hasAccess();
        }

        @Override
        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            String base = ds.getParentCatalog().getUriString();
            if (base.endsWith(".html")) {
                base = base.substring(0, base.length() - 5) + ".xml";
            }
            Formatter query = new Formatter();
            query.format("<a href='%s/view/ToolsUI.jnlp?", req.getContextPath());
            query.format("catalog=%s&amp;dataset=%s'>NetCDF-Java ToolsUI (webstart)</a>", base, ds.getID());
            return query.toString();
        }
    }
}

