/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.catalogservice.Command;
import thredds.servlet.filter.ParameterValidationUtils;

public class CatalogServiceFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String[] cmdValidSet = new String[]{Command.SHOW.toString(), Command.SUBSET.toString(), Command.VALIDATE.toString()};
        if (ParameterValidationUtils.validateParameterAsSingleValueUriString(request, response, "catalog") && ParameterValidationUtils.validateParameterAsSingleValueAlphanumericStringConstrained(request, response, "command", cmdValidSet, true) && ParameterValidationUtils.validateParameterAsSingleValuePathString(request, response, "dataset") && ParameterValidationUtils.validateParameterAsSingleValueBooleanString(request, response, "htmlView") && ParameterValidationUtils.validateParameterAsSingleValueBooleanString(request, response, "verbose")) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

