/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.NodeStateProtocol;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.JoinGroupEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.MonitorChangeListener;
import com.sleepycat.je.rep.monitor.MonitorService;
import com.sleepycat.je.rep.monitor.NewMasterEvent;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Monitor {
    private final NameIdPair nameIdPair;
    private final ReplicationConfig monitorConfig;
    private final ReplicationGroupAdmin repGroupAdmin;
    private Learner learner;
    private MasterChangeListener masterChangeListener;
    private final Logger logger;
    private final Formatter formatter;
    private MonitorChangeListener monitorChangeListener;
    private ServiceDispatcher serviceDispatcher;
    AtomicBoolean shutdown = new AtomicBoolean(false);

    public Monitor(ReplicationConfig monitorConfig) {
        if (!monitorConfig.getNodeType().equals((Object)NodeType.MONITOR)) {
            throw new IllegalArgumentException("The configured node type was: " + (Object)((Object)monitorConfig.getNodeType()) + " instead of: " + (Object)((Object)NodeType.MONITOR));
        }
        String groupName = monitorConfig.getGroupName();
        if (groupName == null) {
            throw new IllegalArgumentException("Missing group name");
        }
        this.nameIdPair = new NameIdPair(monitorConfig.getNodeName());
        String nodeHost = monitorConfig.getNodeHostPort();
        if (nodeHost == null) {
            throw new IllegalArgumentException("Missing nodeHost");
        }
        this.monitorConfig = monitorConfig.clone();
        this.repGroupAdmin = new ReplicationGroupAdmin(groupName, monitorConfig.getHelperSockets());
        this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(this.nameIdPair);
    }

    public String getGroupName() {
        return this.monitorConfig.getGroupName();
    }

    public NameIdPair getMonitorNameIdPair() {
        return this.nameIdPair;
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public InetSocketAddress getMonitorSocketAddress() {
        return this.monitorConfig.getNodeSocketAddress();
    }

    public ReplicationNode register() throws EnvironmentFailureException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        if (this.repGroupAdmin.getHelperSockets().size() == 0) {
            throw new IllegalStateException("No helper sockets were specified at Monitor initialization");
        }
        RepNodeImpl monitorNode = new RepNodeImpl(this.nameIdPair, NodeType.MONITOR, this.monitorConfig.getNodeHostname(), this.monitorConfig.getNodePort());
        return this.repGroupAdmin.ensureMonitor(monitorNode);
    }

    public void startListener(MonitorChangeListener newListener) throws DatabaseException, IOException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        if (newListener == null) {
            throw new IllegalArgumentException("A MonitorChangeListener must be associated with  this Monitor when invoking this method");
        }
        if (this.monitorChangeListener != null) {
            throw new IllegalStateException("A Listener has already been established");
        }
        this.monitorChangeListener = newListener;
        this.serviceDispatcher = new ServiceDispatcher(this.monitorConfig.getNodeSocketAddress());
        this.serviceDispatcher.start();
        Protocol electionProtocol = new Protocol(TimebasedProposalGenerator.getParser(), MasterValue.getParser(), this.monitorConfig.getGroupName(), this.nameIdPair, null);
        this.learner = new Learner(electionProtocol, this.serviceDispatcher, this.nameIdPair);
        this.serviceDispatcher.register(new MonitorService(this, this.serviceDispatcher));
        this.masterChangeListener = new MasterChangeListener();
        this.learner.addListener(this.masterChangeListener);
        this.learner.start();
        try {
            ReplicationGroup repGroup = this.repGroupAdmin.getGroup();
            RepGroupImpl group = RepInternal.getRepGroupImpl(repGroup);
            this.learner.queryForMaster(group.getLearnerSockets());
            this.notifyJoinGroupEventsForActiveNodes(repGroup);
        }
        catch (UnknownMasterException ume) {
            LoggerUtils.logMsg(this.logger, this.formatter, Level.INFO, "No current master.");
        }
    }

    private void notifyJoinGroupEventsForActiveNodes(ReplicationGroup group) {
        NodeStateProtocol stateProtocol = new NodeStateProtocol(group.getName(), NameIdPair.NOCHECK, null);
        for (ReplicationNode repNode : group.getElectableNodes()) {
            NodeStateProtocol nodeStateProtocol = stateProtocol;
            nodeStateProtocol.getClass();
            InetSocketAddress inetSocketAddress = repNode.getSocketAddress();
            NodeStateProtocol nodeStateProtocol2 = stateProtocol;
            nodeStateProtocol2.getClass();
            TextProtocol.MessageExchange me = nodeStateProtocol.new TextProtocol.MessageExchange(inetSocketAddress, "NodeState", nodeStateProtocol2.new NodeStateProtocol.NodeStateRequest(repNode.getName()));
            me.run();
            TextProtocol.ResponseMessage resp = me.getResponseMessage();
            if (!(resp instanceof NodeStateProtocol.NodeStateResponse)) continue;
            NodeStateProtocol.NodeStateResponse response = (NodeStateProtocol.NodeStateResponse)resp;
            this.notify(new JoinGroupEvent(response.getNodeName(), response.getMasterName(), response.getJoinTime()));
        }
    }

    public String getMasterNodeName() throws UnknownMasterException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        return this.repGroupAdmin.getMasterNodeName();
    }

    public ReplicationGroup getGroup() throws UnknownMasterException, DatabaseException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        return this.repGroupAdmin.getGroup();
    }

    public synchronized void shutdown() throws InterruptedException {
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.formatter, Level.INFO, "Shutting down monitor " + this.nameIdPair);
        if (this.learner != null) {
            this.learner.shutdown();
        }
        if (this.serviceDispatcher != null) {
            this.serviceDispatcher.shutdown();
        }
    }

    void notify(GroupChangeEvent event) {
        this.monitorChangeListener.notify(event);
    }

    void notify(JoinGroupEvent event) {
        this.monitorChangeListener.notify(event);
    }

    void notify(LeaveGroupEvent event) {
        this.monitorChangeListener.notify(event);
    }

    private class MasterChangeListener
    implements Learner.Listener {
        private MasterValue currentValue = null;

        private MasterChangeListener() {
        }

        public void notify(Proposer.Proposal proposal, Protocol.Value value) {
            if (value.equals(this.currentValue)) {
                return;
            }
            this.currentValue = (MasterValue)value;
            try {
                String currentMasterName = this.currentValue.getNodeName();
                LoggerUtils.logMsg(Monitor.this.logger, Monitor.this.formatter, Level.INFO, "Monitor notified of new Master: " + currentMasterName);
                if (Monitor.this.monitorChangeListener == null) {
                    return;
                }
                Monitor.this.monitorChangeListener.notify(new NewMasterEvent(this.currentValue));
            }
            catch (Exception e) {
                LoggerUtils.logMsg(Monitor.this.logger, Monitor.this.formatter, Level.SEVERE, "Monitor change event processing exception: " + e.getMessage());
            }
        }
    }
}

