/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class LongMaxStat
extends LongStat {
    public LongMaxStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
        this.clear();
    }

    public LongMaxStat(StatGroup group, StatDefinition definition, long counter) {
        super(group, definition);
        this.counter = counter;
    }

    public void clear() {
        this.set(Long.MIN_VALUE);
    }

    public void setMax(long newValue) {
        this.counter = this.counter < newValue ? newValue : this.counter;
    }

    String getFormattedValue() {
        if (this.counter == Long.MIN_VALUE) {
            return "NONE";
        }
        return Stat.FORMAT.format(this.counter);
    }
}

