/*
 * Decompiled with CFR 0.152.
 */
package org.n52.oxf.xmlbeans.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.oxf.xmlbeans.parser.XMLBeansParser;
import org.n52.oxf.xmlbeans.parser.XMLHandlingException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static final XmlOptions NO_XML_FRAGMENTS = new XmlOptions().setSaveOuter();
    public static final XmlOptions PRETTYPRINT = new XmlOptions(NO_XML_FRAGMENTS);
    public static final XmlOptions FAST = new XmlOptions(NO_XML_FRAGMENTS);

    public static XmlObject getXmlAnyNodeFrom(XmlObject xml, String nodeName) throws XmlException {
        Node bodyNode = XmlUtil.getDomNode(xml, nodeName);
        return bodyNode == null ? null : XmlObject.Factory.parse(bodyNode);
    }

    public static Node getDomNode(XmlObject xmlobj, String name) throws XmlException {
        Node domNode = xmlobj.getDomNode();
        if (domNode == null) {
            throw new XmlException("No DOM node found where to extract" + name + " element.");
        }
        name = XmlUtil.stripPrefix(name);
        NodeList childList = domNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node node = childList.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(name)) continue;
            return node;
        }
        return null;
    }

    private static String stripPrefix(String name) {
        return name.substring(name.indexOf(":") + 1);
    }

    public static String getElement(XmlObject doc, String element) throws XMLHandlingException {
        try {
            for (Method method : doc.getClass().getMethods()) {
                if (!method.getName().equals(element)) continue;
                return method.invoke((Object)doc, (Object[])null).toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLHandlingException("cannot extract '" + element + "' from " + doc.schemaType().getName().toString(), e);
        }
    }

    public static String objectToString(XmlObject doc) throws XMLHandlingException {
        return XmlUtil.objectToString(doc, true);
    }

    public static String objectToString(XmlObject doc, boolean validate) throws XMLHandlingException {
        return XmlUtil.objectToString(doc, validate, false);
    }

    public static String objectToString(XmlObject doc, boolean validate, boolean prettyprint) throws XMLHandlingException {
        if (validate) {
            XMLBeansParser.strictValidate(doc);
        }
        if (prettyprint) {
            return doc.xmlText(PRETTYPRINT);
        }
        return doc.xmlText(FAST);
    }

    public static void writeObject(XmlObject doc, PrintWriter out) throws IOException {
        doc.save(out, PRETTYPRINT);
    }

    public static void writeObject(XmlObject doc, PrintWriter out, boolean validate) throws IOException, XMLHandlingException {
        if (validate) {
            XMLBeansParser.strictValidate(doc);
        }
        XmlUtil.writeObject(doc, out);
    }

    public static Node getDomNode(XmlObject input) throws XMLHandlingException {
        try {
            XmlObject rootNode = XmlUtil.getRootNode(input);
            return rootNode.getDomNode();
        }
        catch (Throwable t) {
            throw new XMLHandlingException(t.getMessage(), t);
        }
    }

    private static XmlObject getRootNode(XmlObject input) {
        return XmlUtil.selectPath("/*", input)[0];
    }

    public static XmlObject qualifySubstitutionGroup(XmlObject xobj, QName newInstance) {
        return XmlUtil.qualifySubstitutionGroup(xobj, newInstance, null);
    }

    public static XmlObject qualifySubstitutionGroup(XmlObject xobj, QName newInstance, SchemaType newType) {
        XmlObject substitute = null;
        if (newType != null && (substitute = xobj.substitute(newInstance, newType)) != null && substitute.schemaType() == newType && substitute.getDomNode().getLocalName().equals(newInstance.getLocalPart())) {
            return substitute;
        }
        XmlCursor cursor = xobj.newCursor();
        cursor.setName(newInstance);
        QName qName = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
        cursor.removeAttribute(qName);
        cursor.dispose();
        return null;
    }

    public static String stripText(XmlObject[] elems) {
        if (elems != null && elems.length > 0) {
            return XmlUtil.stripText(elems[0]);
        }
        return null;
    }

    public static String stripText(XmlObject elem) {
        if (elem != null) {
            StringBuilder sb = new StringBuilder();
            NodeList children = elem.getDomNode().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                sb.append(XmlUtil.toString(child).trim());
            }
            return sb.toString();
        }
        return null;
    }

    public static XmlObject[] selectPath(String path, XmlObject xo) {
        return XmlUtil.selectPath(path, xo, new XmlOptions());
    }

    public static XmlObject[] selectPath(String path, XmlObject xo, XmlOptions opts) {
        opts.put((Object)"PATH_DELEGATE_INTERFACE", "org.n52.oxf.xmlbeans.tools.XbeansXPathSaxon94");
        return xo.selectPath(path, opts);
    }

    public static XmlObject[] execQuery(String path, XmlObject xo) {
        return XmlUtil.execQuery(path, xo, new XmlOptions());
    }

    public static XmlObject[] execQuery(String path, XmlObject xo, XmlOptions opts) {
        opts.put((Object)"QUERY_DELEGATE_INTERFACE", "org.n52.oxf.xmlbeans.tools.XbeansXQuerySaxon94");
        return xo.execQuery(path, opts);
    }

    public static QName getElementType(XmlObject xml) {
        return xml == null ? null : xml.schemaType().getDocumentElementName();
    }

    public static String getTextContentFromXml(XmlObject xmlElement) {
        Node node = xmlElement.getDomNode();
        return node.getFirstChild().getFirstChild().getNodeValue();
    }

    public static String getTextContentFromAnyNode(XmlObject xmlAnyElement) {
        Node node = xmlAnyElement.getDomNode();
        return node.getFirstChild().getNodeValue();
    }

    public static XmlObject setTextContent(XmlObject xmlObject, String content) {
        XmlCursor cursor = xmlObject.newCursor();
        cursor.toFirstChild();
        cursor.setTextValue(content);
        cursor.dispose();
        return xmlObject;
    }

    public static String toString(Node xml) {
        short type = xml.getNodeType();
        if (type == 3) {
            return xml.getNodeValue();
        }
        StringWriter buffer = new StringWriter();
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(xml), new StreamResult(buffer));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }

    static {
        PRETTYPRINT.setSavePrettyPrint();
        PRETTYPRINT.setSavePrettyPrintIndent(2);
        PRETTYPRINT.setUseDefaultNamespace();
        FAST.setUseDefaultNamespace();
    }
}

