/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.IO;

public class ReplayTdsLogs {
    private static final Logger logger = LoggerFactory.getLogger(ReplayTdsLogs.class);
    private static AtomicInteger reqno = new AtomicInteger(0);
    private static Formatter out;
    private static Formatter out2;
    private static final String USER_AGENT = "ReplayTdsLogs testing utility from toolsUI";
    private static final String URI_DEFAULT_SCHEME_SPECIFIC_PART = "http://";
    final int nthreads = 2;
    ExecutorService executor;
    ExecutorCompletionService<SendRequestTask> completionService;
    Thread resultProcessingThread;
    AtomicLong regProcess = new AtomicLong();
    AtomicLong total_sendRequest_time = new AtomicLong();
    AtomicLong total_expected_time = new AtomicLong();
    final String server;
    boolean dump = false;
    private static Pattern regPattern;
    private int maxLines = -1;
    private static int total_submit;
    private static int skip_submit;
    private static int max_submit;
    static int total_reqs;
    static int total_bad;
    static Filter all;
    static Filter unknown;
    static List<Filter> filters;
    static String serverLive;

    ReplayTdsLogs(String server) throws FileNotFoundException, HTTPException {
        this.server = server;
        this.executor = Executors.newFixedThreadPool(2);
        this.completionService = new ExecutorCompletionService(this.executor);
        this.resultProcessingThread = new Thread(new ResultProcessor());
        this.resultProcessingThread.start();
    }

    public void exit(int secs) throws IOException {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(secs, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(secs, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            System.out.println("exit interrupted");
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        System.out.println("executor terminated");
        System.out.println("total requests= " + reqno.get());
        System.out.println("total_sendRequest_time= " + this.total_sendRequest_time.get() / 1000L + " secs");
        System.out.println("total_expected_time= " + this.total_expected_time.get() / 1000L + " secs");
        float speedup = (float)this.total_expected_time.get() / (float)this.total_sendRequest_time.get();
        System.out.println("speedup= " + speedup);
    }

    Log parseLine(Pattern p, String line) {
        try {
            Matcher m = p.matcher(line);
            boolean groupno = true;
            if (m.matches()) {
                Log log = new Log();
                log.ip = m.group(1);
                log.date = m.group(3);
                log.request = m.group(4);
                log.returnCode = this.parse(m.group(5));
                log.sizeBytes = this.parseLong(m.group(6));
                log.referrer = m.group(7);
                log.client = m.group(8);
                log.msecs = this.parseLong(m.group(9));
                String[] reqss = log.request.split(" ");
                if (reqss.length == 3) {
                    log.verb = reqss[0];
                    log.path = reqss[1];
                    log.http = reqss[2];
                }
                return log;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cant parse " + line);
        }
        return null;
    }

    private int parse(String s) {
        if (s.equals("-")) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private long parseLong(String s) {
        if (s.equals("-")) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    void scanTime(String filename, int secs) throws IOException {
        String line;
        int count;
        FileInputStream ios = new FileInputStream(filename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        int filterCount = 0;
        for (count = 0; (this.maxLines < 0 || count < this.maxLines) && (line = dataIS.readLine()) != null; ++count) {
            Log log = this.parseLine(regPattern, line);
            if (log == null || log.msecs / 1000L <= (long)secs) continue;
            System.out.println("TIME " + log.msecs / 1000L + ": " + log);
            ++filterCount;
        }
        ((InputStream)ios).close();
        System.out.println("total requests= " + count + " filter=" + filterCount);
    }

    void scanRequest(String filename) throws IOException {
        String line;
        int count;
        FileInputStream ios = new FileInputStream(filename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        int filterCount = 0;
        for (count = 0; (this.maxLines < 0 || count < this.maxLines) && (line = dataIS.readLine()) != null; ++count) {
            Log log = this.parseLine(regPattern, line);
            if (log == null || log.request.startsWith("GET") || log.request.startsWith("HEAD")) continue;
            System.out.println("REQUEST: " + log);
            ++filterCount;
        }
        ((InputStream)ios).close();
        System.out.println("total requests= " + count + " filter=" + filterCount);
    }

    void sendRequests(String filename, int max) throws IOException {
        String line;
        int submit = 0;
        long skip = 0L;
        long total = 0L;
        FileInputStream ios = new FileInputStream(filename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((max < 0 || submit < max) && (line = dataIS.readLine()) != null) {
            Log log = this.parseLine(regPattern, line);
            if (log == null || log.path == null) continue;
            if (++total + (long)total_submit < (long)skip_submit || total + (long)total_submit > (long)max_submit) {
                ++skip;
                continue;
            }
            if (log.verb != null && log.verb.equals("POST")) {
                ++skip;
                continue;
            }
            if (log.path.indexOf("manager") > 0) {
                ++skip;
                continue;
            }
            if (log.path.indexOf("admin") > 0) {
                ++skip;
                continue;
            }
            if (log.path.indexOf("/dts/") > 0) {
                ++skip;
                continue;
            }
            if (log.returnCode != 200) {
                ++skip;
                continue;
            }
            this.completionService.submit(new SendRequestTask(log));
            ++submit;
        }
        ((InputStream)ios).close();
        System.out.println("total requests= " + total + " skip= " + skip + " submit = " + submit);
        total_submit += submit;
    }

    void passFilter(String filename, PrintWriter out) throws IOException {
        String line;
        FileInputStream ios = new FileInputStream(filename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        int count = 0;
        int bad = 0;
        while ((this.maxLines < 0 || count < this.maxLines) && (line = dataIS.readLine()) != null) {
            Log log = this.parseLine(regPattern, line);
            if (log == null) {
                ++bad;
                ++total_bad;
                continue;
            }
            all.accum(log);
            ++total_reqs;
            boolean filtered = false;
            for (Filter f : filters) {
                if (!f.isMine(log)) continue;
                f.accum(log);
                filtered = true;
                break;
            }
            if (!filtered) {
                out.println(log.toCSV());
                unknown.accum(log);
            }
            ++count;
        }
        ((InputStream)ios).close();
        System.out.println(" " + filename + " requests= " + count + " bad=" + bad);
    }

    private void test() {
        String line = "128.117.140.75 - - [01/Mar/2008:00:47:08 -0700] \"HEAD /thredds/dodsC/model/NCEP/DGEX/CONUS_12km/DGEX_CONUS_12km_20080229_1800.grib2.dds HTTP/1.1\" 200 - \"null\" \"Java/1.6.0_01\" 23";
        String line2 = "140.115.36.145 - - [01/Mar/2008:00:01:20 -0700] \"GET /thredds/dodsC/satellite/IR/NHEM-MULTICOMP_1km/20080229/NHEM-MULTICOMP_1km_IR_20080229_1500.gini.dods HTTP/1.0\" 200 134 \"null\" \"Wget/1.10.2 (Red Hat modified)\" 35";
        String line3 = "82.141.193.194 - - [01/May/2008:09:29:06 -0600] \"GET /thredds/wcs/galeon/testdata/sst.nc?REQUEST=GetCoverage&SERVICE=WCS&VERSION=1.0.0&COVERAGE=tos&CRS=EPSG:4326&BBOX=1,-174,359,184&WIDTH=128&HEIGHT=128&FORMAT=GeoTIFF HTTP/1.1\" 200 32441 \"null\" \"null\" 497";
        Log log = this.parseLine(regPattern, line3);
        if (log != null) {
            System.out.println("test= " + log);
        }
        String what = "GET /thredds/wcs/galeon/testdata/sst.nc?REQUEST=GetCoverage&SERVICE=WCS&VERSION=1.0.0&COVERAGE=tos&CRS=EPSG:4326&BBOX=1,-174,359,184&WIDTH=128&HEIGHT=128&FORMAT=GeoTIFF HTTP/1.1";
        String[] hell = what.split(" ");
    }

    static void readAllInDir(File dir, MClosure closure) {
        List<File> list = Arrays.asList(dir.listFiles());
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            File f = list.get(i);
            if (!f.getName().endsWith("log")) continue;
            if (f.isDirectory()) {
                ReplayTdsLogs.readAllInDir(f, closure);
                continue;
            }
            try {
                closure.run(f.getPath());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error on " + f + " (" + e.getMessage() + ")\n");
                e.printStackTrace();
            }
        }
    }

    static void read(String filename, MClosure closure) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            System.out.println(filename + " does not exist");
            return;
        }
        if (f.isDirectory()) {
            ReplayTdsLogs.readAllInDir(f, closure);
        } else {
            closure.run(f.getPath());
        }
    }

    public static void main(String[] args) throws IOException {
        int EXIT_NORMAL = 0;
        int USAGE_ERROR = 64;
        int HOST_ERROR = 68;
        int IO_ERROR = 74;
        out = null;
        out2 = new Formatter(System.out);
        List<String> message = Arrays.asList(" ", "ReplayTdsLogs takes two arguments.%n", "  The first argument is the URL of the server to test (e.g. http://my.thredds.edu)%n", "  The second argument is the path of the directory which holds the log files you wish to replay against the test server. (e.g. /my/testlogs/live/here)%n", "%n", "  Example usage:%n", "java -classpath toolsUI.jar thredds.logs.ReplayTdsLogs http://my.thredds.edu /my/testlogs/live/here %n");
        if (args.length == 0) {
            for (String line : message) {
                System.out.format(line, new Object[0]);
            }
            System.exit(EXIT_NORMAL);
        } else if (args.length != 2) {
            for (String line : message) {
                System.err.format(line, new Object[0]);
            }
            System.exit(USAGE_ERROR);
        }
        String serverToTest = args[0].toString();
        String accessLogsToTestWith = args[1].toString();
        if (!serverToTest.startsWith(URI_DEFAULT_SCHEME_SPECIFIC_PART)) {
            serverToTest = URI_DEFAULT_SCHEME_SPECIFIC_PART + serverToTest;
        }
        try (HTTPMethod method = HTTPFactory.Head(serverToTest);){
            serverToTest = method.getSession().getSessionURI();
            method.setUserAgent(USER_AGENT);
            method.execute();
            method.close();
        }
        catch (HTTPException httpe) {
            String errorMessage = httpe.getLocalizedMessage();
            System.err.format("Error related to test server %s:%n", serverToTest);
            System.err.format("%n", new Object[0]);
            if (errorMessage.toLowerCase().contains("unknownhostexception")) {
                System.err.format("The hostname %s is incorrect, or the host may be down.%n", serverToTest);
                System.exit(HOST_ERROR);
            } else {
                System.err.format("%s%n", httpe.getMessage());
            }
            System.exit(USAGE_ERROR);
        }
        Path pathToTestDir = Paths.get(accessLogsToTestWith, new String[0]);
        try {
            pathToTestDir = pathToTestDir.toRealPath(new LinkOption[0]);
            if (!Files.isDirectory(pathToTestDir, new LinkOption[0])) {
                System.err.format("The second argument %s is not a directory.", pathToTestDir.toString());
                System.exit(USAGE_ERROR);
            }
            try (DirectoryStream<Path> potential_log_files = Files.newDirectoryStream(pathToTestDir);){
                if (!potential_log_files.iterator().hasNext()) {
                    System.err.format("The directory %s appears to be empty.", pathToTestDir.toString());
                    System.exit(EXIT_NORMAL);
                }
            }
        }
        catch (NoSuchFileException nsfe) {
            System.err.format("The directory %s does not exists.", pathToTestDir.toString());
            System.exit(EXIT_NORMAL);
        }
        catch (IOException ioe) {
            System.err.format("%s%n", ioe);
            System.exit(IO_ERROR);
        }
        final ReplayTdsLogs reader = new ReplayTdsLogs(serverToTest);
        long startElapsed = System.nanoTime();
        System.out.format("%ntest server=%s sending request for log files in the directory %s %n%n", serverToTest, accessLogsToTestWith);
        ReplayTdsLogs.read(accessLogsToTestWith, new MClosure(){

            @Override
            public void run(String filename) throws IOException {
                reader.sendRequests(filename, -1);
            }
        });
        System.out.println("total_submit= " + total_submit);
        reader.exit(86400);
        long elapsedTime = System.nanoTime() - startElapsed;
        System.out.format("elapsed= %d secs%n", elapsedTime / 1000000000L);
        if (out != null) {
            out.close();
        }
        out2.close();
        System.exit(EXIT_NORMAL);
    }

    static {
        regPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+) - (.*) \\[(.*)\\] \"(.*)\" (\\d+) ([\\-\\d]+) \"(.*)\" \"(.*)\" (\\d+)");
        total_submit = 0;
        skip_submit = -1;
        max_submit = Integer.MAX_VALUE;
        total_reqs = 0;
        total_bad = 0;
        all = new All();
        unknown = new Unknown();
        filters = new ArrayList<Filter>();
        serverLive = null;
    }

    static interface MClosure {
        public void run(String var1) throws IOException;
    }

    static class Datafed
    extends Filter {
        Datafed() {
            super("Datafed");
        }

        @Override
        boolean isMine(Log log) {
            return log.ip.equals("128.252.21.75") && log.path.startsWith("/thredds/wcs/");
        }
    }

    static class FileServer
    extends Filter {
        FileServer() {
            super("FileServer");
        }

        @Override
        boolean isMine(Log log) {
            return log.path.startsWith("/thredds/fileServer/") && log.client.startsWith("Wget") || log.client.startsWith("curl") || log.client.startsWith("Python-urllib");
        }
    }

    static class PostProbe
    extends Filter {
        PostProbe() {
            super("PostProbe");
        }

        @Override
        boolean isMine(Log log) {
            return log.request.startsWith("POST /proxy");
        }
    }

    static class Idv
    extends Filter {
        Idv() {
            super("IDV");
        }

        @Override
        boolean isMine(Log log) {
            return log.client.startsWith("IDV") || log.client.startsWith("Jakarta Commons-HttpClient");
        }
    }

    static class JUnitReqs
    extends Filter {
        JUnitReqs() {
            super("JUnitReqs");
        }

        @Override
        boolean isMine(Log log) {
            return log.ip.equals("128.117.140.75");
        }
    }

    static class Client
    extends Filter {
        String clientStartsWith;

        Client(String clientStartsWith) {
            super(clientStartsWith);
            this.clientStartsWith = clientStartsWith;
        }

        @Override
        boolean isMine(Log log) {
            return log.client.startsWith(this.clientStartsWith);
        }
    }

    static class Unknown
    extends Filter {
        Unknown() {
            super("Unknown");
        }

        @Override
        boolean isMine(Log log) {
            return false;
        }
    }

    static class All
    extends Filter {
        All() {
            super("All");
        }

        @Override
        boolean isMine(Log log) {
            return true;
        }
    }

    static abstract class Filter {
        String name;
        int nreqs;
        long accumTime;
        long accumBytes;

        abstract boolean isMine(Log var1);

        Filter(String name) {
            this.name = name;
        }

        void accum(Log log) {
            ++this.nreqs;
            this.accumTime += log.msecs;
            if (log.sizeBytes > 0L) {
                this.accumBytes += log.sizeBytes;
            }
        }

        public void show(Formatter out) {
            double mb = 1.0E-6 * (double)this.accumBytes;
            double secs = 0.001 * (double)this.accumTime;
            out.format(" %20s: %10d %10.3f %10.3f%n", this.name, this.nreqs, secs, mb);
        }
    }

    private class Log {
        String ip;
        String date;
        String request;
        String referrer;
        String client;
        int returnCode;
        long msecs;
        long sizeBytes;
        String verb;
        String path;
        String http;

        private Log() {
        }

        public String toCSV() {
            return this.ip + "," + this.date + "," + this.verb + ",\"" + this.path + "\"," + this.returnCode + "," + this.sizeBytes + ",\"" + this.referrer + "\",\"" + this.client + "\"," + this.msecs;
        }

        public String toString() {
            return this.ip + " [" + this.date + "] " + this.verb + " " + this.path + " " + this.http + " " + this.returnCode + " " + this.sizeBytes + " " + this.referrer + " " + this.client + " " + this.msecs;
        }
    }

    private class ResultProcessor
    implements Runnable {
        private boolean cancel = false;

        private ResultProcessor() {
        }

        @Override
        public void run() {
            block3: while (true) {
                try {
                    while (true) {
                        float speedup;
                        Future<SendRequestTask> f;
                        if ((f = ReplayTdsLogs.this.completionService.poll()) == null) {
                            if (this.cancel) break block3;
                            f = ReplayTdsLogs.this.completionService.take();
                        }
                        SendRequestTask itask = f.get();
                        Log log = itask.log;
                        String urlString = ReplayTdsLogs.this.server + log.path;
                        if (ReplayTdsLogs.this.dump) {
                            System.out.printf("\"%s\",%d,%d", urlString, log.sizeBytes, log.msecs);
                        }
                        float f2 = speedup = itask.msecs > 0L ? (float)log.msecs / (float)itask.msecs : 0.0f;
                        if (itask.failed) {
                            System.out.printf("***FAIL %s %s %n", log.path, itask.failMessage);
                        } else if (itask.statusCode != (long)log.returnCode && log.returnCode != 304 && log.returnCode != 302) {
                            if (!this.compareAgainstLive(itask)) {
                                if (out != null) {
                                    out.format("%5d: status=%d was=%d %s  %n", itask.reqnum, itask.statusCode, log.returnCode, log.path);
                                }
                                out2.format("%5d: status=%d was=%d %s  %n", itask.reqnum, itask.statusCode, log.returnCode, log.path);
                            }
                        } else if (itask.statusCode == 200L && itask.bytesRead != log.sizeBytes && out != null) {
                            out.format("%5d: bytes=%d was=%d %s%n", itask.reqnum, itask.bytesRead, log.sizeBytes, log.path);
                        }
                        if (!ReplayTdsLogs.this.dump) continue;
                        System.out.printf(",%d,%f,%s%n", itask.msecs, Float.valueOf(speedup), itask.failed);
                    }
                }
                catch (InterruptedException e) {
                    this.cancel = true;
                    continue;
                }
                catch (Exception e) {
                    logger.error("ResultProcessor ", e);
                    continue;
                }
                break;
            }
            System.out.println("exit ResultProcessor");
        }

        private boolean compareAgainstLive(SendRequestTask itask) throws IOException {
            if (serverLive == null) {
                return true;
            }
            try (HTTPMethod method = HTTPFactory.Get(serverLive + itask.log.path);){
                out2.format("send %s %n", method.getPath());
                method.setUserAgent(ReplayTdsLogs.USER_AGENT);
                int statusCode = method.execute();
                InputStream is = method.getResponseBodyAsStream();
                if (is != null) {
                    IO.copy2null(is, 10000);
                }
                boolean bl = (long)statusCode == itask.statusCode;
                return bl;
            }
        }
    }

    public class SendRequestTask
    implements Callable<SendRequestTask> {
        Log log;
        long statusCode;
        long bytesRead;
        boolean failed = false;
        String failMessage;
        long msecs;
        long reqnum;

        SendRequestTask(Log log) {
            this.log = log;
        }

        @Override
        public SendRequestTask call() throws Exception {
            long start = System.nanoTime();
            this.reqnum = reqno.incrementAndGet();
            if (this.reqnum % 100L == 0L) {
                System.out.println(this.reqnum + " request= " + this.log);
            }
            try {
                this.send();
                long took = System.nanoTime() - start;
                this.msecs = took / 1000L / 1000L;
                ReplayTdsLogs.this.total_sendRequest_time.getAndAdd(this.msecs);
                ReplayTdsLogs.this.total_expected_time.getAndAdd(this.log.msecs);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.failed = true;
                this.failMessage = t.getMessage();
            }
            return this;
        }

        void send() throws IOException {
            String unescapedForm = EscapeStrings.unescapeURL(this.log.path);
            String urlencoded = ReplayTdsLogs.this.server + unescapedForm;
            try (HTTPMethod method = HTTPFactory.Get(urlencoded);){
                method.setUserAgent(ReplayTdsLogs.USER_AGENT);
                this.statusCode = method.execute();
                InputStream is = method.getResponseBodyAsStream();
                if (is != null) {
                    this.bytesRead = IO.copy2null(is, 10000);
                }
            }
        }
    }
}

