/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis.shapefile;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.ui.gis.GisFeatureRendererMulti;
import ucar.nc2.ui.gis.shapefile.EsriShapefile;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class EsriShapefileRenderer
extends GisFeatureRendererMulti {
    private static Map<String, EsriShapefileRenderer> sfileHash;
    private static double defaultCoarseness;
    private EsriShapefile esri = null;
    private ProjectionImpl dataProject = new LatLonProjection("Cylindrical Equidistant");

    public static EsriShapefileRenderer factory(String filename) {
        if (sfileHash == null) {
            sfileHash = new HashMap<String, EsriShapefileRenderer>();
        }
        if (sfileHash.containsKey(filename)) {
            return sfileHash.get(filename);
        }
        try {
            EsriShapefileRenderer sfile = new EsriShapefileRenderer(filename);
            sfileHash.put(filename, sfile);
            return sfile;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static EsriShapefileRenderer factory(String key, InputStream stream) {
        if (sfileHash == null) {
            sfileHash = new HashMap<String, EsriShapefileRenderer>();
        }
        if (sfileHash.containsKey(key)) {
            return sfileHash.get(key);
        }
        try {
            EsriShapefileRenderer sfile = new EsriShapefileRenderer(stream);
            sfileHash.put(key, sfile);
            return sfile;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private EsriShapefileRenderer(InputStream stream) throws IOException {
        this.esri = new EsriShapefile(stream, null, defaultCoarseness);
        double avgD = this.getStats(this.esri.getFeatures().iterator());
        this.createFeatureSet(avgD);
        this.createFeatureSet(2.0 * avgD);
        this.createFeatureSet(3.0 * avgD);
        this.createFeatureSet(5.0 * avgD);
        this.createFeatureSet(8.0 * avgD);
    }

    private EsriShapefileRenderer(String filename) throws IOException {
        this(filename, defaultCoarseness);
    }

    private EsriShapefileRenderer(String filename, double coarseness) throws IOException {
        this.esri = new EsriShapefile(filename, coarseness);
        double avgD = this.getStats(this.esri.getFeatures().iterator());
        this.createFeatureSet(2.0 * avgD);
        this.createFeatureSet(4.0 * avgD);
        this.createFeatureSet(8.0 * avgD);
        this.createFeatureSet(16.0 * avgD);
    }

    @Override
    public LatLonRect getPreferredArea() {
        Rectangle2D bb = this.esri.getBoundingBox();
        return new LatLonRect(new LatLonPointImpl(bb.getMinY(), bb.getMinX()), bb.getHeight(), bb.getWidth());
    }

    @Override
    protected List getFeatures() {
        return this.esri.getFeatures();
    }

    @Override
    protected ProjectionImpl getDataProjection() {
        return this.dataProject;
    }

    static {
        defaultCoarseness = 0.0;
    }
}

