/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import org.bounce.text.xml.XMLContext;
import org.bounce.text.xml.XMLScanner;

class XMLViewUtilities {
    private static Segment lineBuffer = null;
    private static final Pattern xmlTag = Pattern.compile("(<[.+]*[^<>]*>)");

    XMLViewUtilities() {
    }

    static int drawUnselectedText(View view, XMLScanner scanner, XMLContext context, Graphics g2, int x, int y, int start, int end) throws BadLocationException {
        Document doc = view.getDocument();
        Style lastStyle = null;
        int mark = start;
        while (start < end) {
            XMLViewUtilities.updateScanner(scanner, doc, start);
            int p = Math.min(scanner.getEndOffset(), end);
            p = p <= start ? end : p;
            Style style = context.getStyle(scanner.token);
            if (style != lastStyle && lastStyle != null) {
                g2.setColor(context.getForeground(lastStyle));
                g2.setFont(g2.getFont().deriveFont(context.getFontStyle(lastStyle)));
                Segment text = XMLViewUtilities.getLineBuffer();
                doc.getText(mark, start - mark, text);
                x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)((Object)view), mark);
                mark = start;
            }
            lastStyle = style;
            start = p;
        }
        g2.setColor(context.getForeground(lastStyle));
        g2.setFont(g2.getFont().deriveFont(context.getFontStyle(lastStyle)));
        Segment text = XMLViewUtilities.getLineBuffer();
        doc.getText(mark, end - mark, text);
        x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)((Object)view), mark);
        return x;
    }

    static int drawSelectedText(View view, XMLScanner scanner, XMLContext context, Graphics g2, int x, int y, int start, int end) throws BadLocationException {
        Document doc = view.getDocument();
        Style lastStyle = null;
        int mark = start;
        while (start < end) {
            XMLViewUtilities.updateScanner(scanner, doc, start);
            int p = Math.min(scanner.getEndOffset(), end);
            p = p <= start ? end : p;
            Style style = context.getStyle(scanner.token);
            if (style != lastStyle && lastStyle != null) {
                g2.setFont(g2.getFont().deriveFont(context.getFontStyle(lastStyle)));
                Segment text = XMLViewUtilities.getLineBuffer();
                doc.getText(mark, start - mark, text);
                x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)((Object)view), mark);
                mark = start;
            }
            lastStyle = style;
            start = p;
        }
        g2.setFont(g2.getFont().deriveFont(context.getFontStyle(lastStyle)));
        Segment text = XMLViewUtilities.getLineBuffer();
        doc.getText(mark, end - mark, text);
        x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)((Object)view), mark);
        return x;
    }

    public static void drawBorder(View view, Graphics g2, Shape shape, Document document) {
        Map tagsMap = (Map)document.getProperty("folding-marking");
        if (tagsMap != null) {
            TagInfo tagInfo;
            tagsMap.clear();
            int height = shape.getBounds().height;
            Color color = g2.getColor();
            g2.setColor(Color.WHITE);
            g2.drawPolygon(new int[]{0, 15, 15, 0}, new int[]{0, 0, height, height}, 4);
            g2.setColor(color);
            try {
                String visibleTextFromBegin = document.getText(0, document.getLength());
                Matcher matcher = xmlTag.matcher(visibleTextFromBegin);
                while (matcher.find()) {
                    String curGroup = matcher.group();
                    if (curGroup.startsWith("<!--") || curGroup.startsWith("<?")) continue;
                    boolean xmlTagStart = !curGroup.startsWith("</");
                    boolean xmlTagSingle = curGroup.endsWith("/>");
                    int spaceIndex = curGroup.indexOf(" ");
                    int tagCloseIndex = curGroup.indexOf(">");
                    if (spaceIndex > 0 && spaceIndex < tagCloseIndex) {
                        tagCloseIndex = spaceIndex;
                    }
                    String curTag = curGroup.substring(xmlTagStart ? 1 : 2, tagCloseIndex);
                    int mark = matcher.start();
                    TagInfo tagInfo2 = (TagInfo)tagsMap.get(matcher.start());
                    if (tagInfo2 != null) continue;
                    TagInfo twinTagInfo = null;
                    for (Integer key : tagsMap.keySet()) {
                        TagInfo curTagInfo = (TagInfo)tagsMap.get(key);
                        if (!curTagInfo.getTag().equals(curTag) || curTagInfo.isFilled()) continue;
                        twinTagInfo = curTagInfo;
                    }
                    if (twinTagInfo != null) {
                        tagInfo2 = twinTagInfo;
                    }
                    if (tagInfo2 == null) {
                        tagInfo2 = new TagInfo();
                        tagInfo2.setTag(curTag);
                    }
                    if (tagsMap.get(mark) == null) {
                        tagsMap.put(mark, tagInfo2);
                    }
                    Rectangle curRectangle = (Rectangle)view.modelToView(mark, shape, Position.Bias.Forward);
                    if (xmlTagSingle) {
                        tagInfo2.setFirstOrdinate(curRectangle.y);
                        tagInfo2.setSecondOrdinate(curRectangle.y);
                        tagInfo2.setFirstMark(mark);
                        int secondMark = mark + curTag.length() + 9;
                        tagInfo2.setSecondMark(secondMark);
                        tagsMap.put(secondMark, tagInfo2);
                    } else if (xmlTagStart) {
                        tagInfo2.setFirstOrdinate(curRectangle.y);
                        tagInfo2.setFirstMark(mark);
                    } else {
                        tagInfo2.setSecondOrdinate(curRectangle.y);
                        tagInfo2.setSecondMark(mark);
                    }
                    tagInfo2.setFolded(curGroup.endsWith("{...}/>"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int skipMark = -1;
            for (Integer key : tagsMap.keySet()) {
                tagInfo = (TagInfo)tagsMap.get(key);
                if (skipMark != -1 && skipMark != key || (skipMark = skipMark == -1 && tagInfo.isFolded() ? tagInfo.getSecondMark() : -1) != -1 || tagInfo.isFolded()) continue;
                XMLViewUtilities.drawTraceLines(g2, tagInfo, shape);
            }
            skipMark = -1;
            for (Integer key : tagsMap.keySet()) {
                tagInfo = (TagInfo)tagsMap.get(key);
                if (skipMark != -1 && skipMark != key) continue;
                if (((skipMark = skipMark == -1 && tagInfo.isFolded() ? tagInfo.getSecondMark() : -1) == -1 || tagInfo.isFolded()) && !tagInfo.isProcessed()) {
                    XMLViewUtilities.drawFoldingMarkers(g2, tagInfo);
                    tagInfo.setProcessed(true);
                    continue;
                }
                tagInfo.setProcessed(false);
            }
        }
    }

    private static void drawTraceLines(Graphics g2, TagInfo tagInfo, Shape shape) {
        if (!tagInfo.isOrdinatesEquals()) {
            int fontHeight = g2.getFont().getSize();
            int firstOrdinate = tagInfo.getFirstOrdinate();
            int secondOrdinate = tagInfo.getSecondOrdinate();
            if (firstOrdinate == -1) {
                firstOrdinate = 0;
            }
            if (secondOrdinate == -1) {
                secondOrdinate = shape.getBounds().height;
            }
            XMLViewUtilities.drawTraceLine(g2, firstOrdinate + fontHeight, secondOrdinate, true);
        }
    }

    private static void drawFoldingMarkers(Graphics g2, TagInfo tagInfo) {
        if (!tagInfo.isOrdinatesEquals() || tagInfo.isFolded()) {
            int firstOrdinate = tagInfo.getFirstOrdinate();
            int secondOrdinate = tagInfo.getSecondOrdinate();
            if (tagInfo.isFolded()) {
                XMLViewUtilities.drawClosedMarker(g2, firstOrdinate, tagInfo);
            } else {
                if (firstOrdinate != -1) {
                    XMLViewUtilities.drawFirstMarker(g2, firstOrdinate, tagInfo);
                }
                if (secondOrdinate != -1) {
                    XMLViewUtilities.drawSecondMarker(g2, secondOrdinate, tagInfo);
                }
            }
        }
    }

    private static void drawTraceLine(Graphics g2, int begin, int end, boolean dotted) {
        Color color = g2.getColor();
        if (dotted) {
            for (int i = begin; i <= end; i += 2) {
                g2.setColor(Color.GRAY);
                g2.drawLine(5, i, 5, i);
                g2.setColor(Color.WHITE);
                g2.drawLine(5, i + 1, 5, i + 1);
            }
        } else {
            g2.setColor(Color.GRAY);
            g2.drawLine(5, begin, 5, end);
        }
        g2.setColor(color);
    }

    private static void drawFirstMarker(Graphics g2, int y, TagInfo tagInfo) {
        Color color = g2.getColor();
        g2.setColor(Color.GRAY);
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 1);
        polygon.addPoint(9, 1);
        polygon.addPoint(9, 7);
        polygon.addPoint(5, 11);
        polygon.addPoint(1, 7);
        polygon.translate(0, y);
        tagInfo.setFirstPolygon(polygon);
        g2.setColor(Color.WHITE);
        g2.fillPolygon(polygon);
        g2.setColor(Color.GRAY);
        g2.drawPolygon(polygon);
        g2.drawLine(3, y + 5, 7, y + 5);
        g2.setColor(color);
    }

    private static void drawSecondMarker(Graphics g2, int y, TagInfo tagInfo) {
        Color color = g2.getColor();
        g2.setColor(Color.GRAY);
        Polygon polygon = new Polygon();
        polygon.addPoint(9, 11);
        polygon.addPoint(1, 11);
        polygon.addPoint(1, 5);
        polygon.addPoint(5, 1);
        polygon.addPoint(9, 5);
        polygon.translate(0, y);
        tagInfo.setSecondPolygon(polygon);
        g2.setColor(Color.WHITE);
        g2.fillPolygon(polygon);
        g2.setColor(Color.GRAY);
        g2.drawPolygon(polygon);
        g2.drawLine(3, y + 7, 7, y + 7);
        g2.setColor(color);
    }

    private static void drawClosedMarker(Graphics g2, int y, TagInfo tagInfo) {
        Color color = g2.getColor();
        g2.setColor(Color.GRAY);
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 1);
        polygon.addPoint(9, 1);
        polygon.addPoint(9, 9);
        polygon.addPoint(1, 9);
        polygon.translate(0, y);
        tagInfo.setFirstPolygon(polygon);
        g2.setColor(Color.WHITE);
        g2.fillPolygon(polygon);
        g2.setColor(Color.GRAY);
        g2.drawPolygon(polygon);
        g2.drawLine(3, y + 5, 7, y + 5);
        g2.drawLine(5, y + 3, 5, y + 7);
        g2.setColor(color);
    }

    private static void updateScanner(XMLScanner scanner, Document doc, int p) {
        try {
            if (!scanner.isValid()) {
                scanner.setRange(XMLViewUtilities.getTagEnd(doc, p), doc.getLength());
                scanner.setValid(true);
            }
            while (scanner.getEndOffset() <= p) {
                scanner.scan();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int getTagEnd(Document doc, int p) {
        int elementEnd = 0;
        if (p > 0) {
            try {
                String s2 = doc.getText(0, p);
                int cdataStart = s2.lastIndexOf("<![CDATA[");
                int cdataEnd = s2.lastIndexOf("]]>");
                int commentStart = s2.lastIndexOf("<!--");
                int commentEnd = s2.lastIndexOf("-->");
                int index = cdataStart > 0 && cdataStart > cdataEnd ? s2.lastIndexOf(">", cdataStart) : (commentStart > 0 && commentStart > commentEnd ? s2.lastIndexOf(">", commentStart) : s2.lastIndexOf(">"));
                if (index != -1) {
                    elementEnd = index;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return elementEnd;
    }

    private static Segment getLineBuffer() {
        if (lineBuffer == null) {
            lineBuffer = new Segment();
        }
        return lineBuffer;
    }

    public static class TagInfo {
        private String tag;
        private int firstMark;
        private int secondMark;
        private int firstOrdinate = -1;
        private int secondOrdinate = -1;
        private Polygon firstPolygon;
        private Polygon secondPolygon;
        private boolean folded = false;
        private boolean processed = false;

        public boolean isOrdinatesEquals() {
            return this.firstOrdinate == this.secondOrdinate;
        }

        public boolean isFilled() {
            return this.firstMark != 0 && this.secondMark != 0;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public int getFirstMark() {
            return this.firstMark;
        }

        public void setFirstMark(int firstMark) {
            this.firstMark = firstMark;
        }

        public int getSecondMark() {
            return this.secondMark;
        }

        public void setSecondMark(int secondMark) {
            this.secondMark = secondMark;
        }

        public int getFirstOrdinate() {
            return this.firstOrdinate;
        }

        public void setFirstOrdinate(int firstOrdinate) {
            this.firstOrdinate = firstOrdinate;
        }

        public int getSecondOrdinate() {
            return this.secondOrdinate;
        }

        public void setSecondOrdinate(int secondOrdinate) {
            this.secondOrdinate = secondOrdinate;
        }

        public Polygon getFirstPolygon() {
            return this.firstPolygon;
        }

        public void setFirstPolygon(Polygon firstPolygon) {
            this.firstPolygon = firstPolygon;
        }

        public Polygon getSecondPolygon() {
            return this.secondPolygon;
        }

        public void setSecondPolygon(Polygon secondPolygon) {
            this.secondPolygon = secondPolygon;
        }

        public boolean isFolded() {
            return this.folded;
        }

        public void setFolded(boolean folded) {
            this.folded = folded;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public String toString() {
            return this.tag;
        }
    }
}

