/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerCatalog;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.MFileIterator;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.CloseableIterator;
import ucar.nc2.util.ListenerManager;

public abstract class CollectionManagerAbstract
extends CollectionAbstract
implements CollectionManager {
    TimeDuration recheck;
    private ListenerManager lm;
    private boolean isStatic;

    public static CollectionManager open(String collectionName, String collectionSpec, String olderThan, Formatter errlog) throws IOException {
        if (collectionSpec.startsWith("catalog:")) {
            return new CollectionManagerCatalog(collectionName, collectionSpec, olderThan, errlog);
        }
        return MFileCollectionManager.open(collectionName, collectionSpec, olderThan, errlog);
    }

    CollectionManagerAbstract(String collectionName, Logger logger) {
        super(collectionName, logger);
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    @Override
    public TimeDuration getRecheck() {
        return this.recheck;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MFileIterator(this.getFilesSorted().iterator(), null);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean scanIfNeeded() throws IOException {
        return this.isScanNeeded() && this.scan(false);
    }

    void sendEvent(CollectionManager.TriggerEvent event) {
        if (this.lm != null) {
            this.lm.sendEvent(event);
        }
    }

    @Override
    public void addEventListener(CollectionManager.TriggerListener l) {
        if (this.lm == null) {
            this.createListenerManager();
        }
        this.lm.addListener(l);
    }

    @Override
    public void removeEventListener(CollectionManager.TriggerListener l) {
        if (this.lm != null) {
            this.lm.removeListener(l);
        }
    }

    private void createListenerManager() {
        this.lm = new ListenerManager("thredds.inventory.CollectionManager$TriggerListener", "thredds.inventory.CollectionManager$TriggerEvent", "handleCollectionEvent");
    }
}

