/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import ucar.unidata.util.StringUtil2;

public class PathMatcher {
    private final TreeMap<String, Match> treeMap = new TreeMap(new PathComparator());
    private static boolean debug = false;

    public void put(String root) {
        this.treeMap.put(root, new Match(root));
    }

    public Match get(String key) {
        return this.treeMap.get(key);
    }

    public Iterator iterator() {
        return this.treeMap.values().iterator();
    }

    public Match match(String path) {
        SortedMap<String, Match> tail = this.treeMap.tailMap(path);
        if (tail.isEmpty()) {
            return null;
        }
        String after = tail.firstKey();
        if (path.startsWith(after)) {
            return this.treeMap.get(after);
        }
        for (String key : tail.keySet()) {
            if (path.startsWith(key)) {
                return this.treeMap.get(key);
            }
            if (StringUtil2.match(path, key) != 0) continue;
            break;
        }
        return null;
    }

    private void doit(String s2) {
        System.out.println(s2 + " == " + this.match(s2));
    }

    public static void main(String[] args) {
        PathMatcher m3 = new PathMatcher();
        m3.put("/thredds/dods/test/longer");
        m3.put("/thredds/dods/test");
        m3.put("/thredds/dods/tester");
        m3.put("/thredds/dods/short");
        m3.put("/actionable");
        m3.put("myworld");
        m3.put("mynot");
        m3.put("ncmodels");
        m3.put("ncmodels/bzipped");
        m3.doit("nope");
        m3.doit("/thredds/dods/test");
        m3.doit("/thredds/dods/test/lo");
        m3.doit("/thredds/dods/test/longer/donger");
        m3.doit("myworldly");
        m3.doit("/my");
        m3.doit("mysnot");
        debug = true;
        m3.doit("ncmodels/canonical");
    }

    private static class PathComparator
    implements Comparator<String>,
    Serializable {
        private PathComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int compare = -1 * o1.compareTo(o2);
            if (debug) {
                System.out.println(" compare " + o1 + " to " + o2 + " = " + compare);
            }
            return compare;
        }
    }

    public static class Match {
        public String root;

        Match(String root) {
            this.root = root;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("root", this.root).toString();
        }
    }
}

