/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Formatter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.ui.catalog.CatalogChooser;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class ThreddsDatasetChooser
extends JPanel {
    private static final String FRAME_SIZE = "FrameSize";
    private CatalogChooser catalogChooser;
    private JTabbedPane tabbedPane;
    private boolean doResolve = false;
    private boolean pipeOut;
    private boolean messageOut;
    private JFrame frame;
    private boolean debugResolve = false;
    private static ThreddsDatasetChooser chooser;
    private static PreferencesExt p;
    private static XMLStore store;

    public ThreddsDatasetChooser(PreferencesExt prefs, JTabbedPane tabs) {
        this(prefs, tabs, null, false, false, false);
    }

    public ThreddsDatasetChooser(PreferencesExt prefs, JTabbedPane tabs, JFrame frame, boolean pipeOutput, boolean messageOutput, boolean addDqc) {
        this.frame = frame;
        this.pipeOut = pipeOutput;
        this.messageOut = messageOutput;
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("catChooser");
        this.catalogChooser = new CatalogChooser(node, true, true, true);
        this.catalogChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("InvAccess")) {
                    ThreddsDatasetChooser.this.firePropertyChangeEvent(e);
                    return;
                }
                if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                    ThreddsDatasetChooser.this.firePropertyChangeEvent(e);
                }
            }
        });
        this.tabbedPane = tabs == null ? new JTabbedPane(1) : tabs;
        this.tabbedPane.addTab("Catalog Chooser", this.catalogChooser);
        this.tabbedPane.setSelectedComponent(this.catalogChooser);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public void setDoResolve(boolean doResolve) {
        this.doResolve = doResolve;
    }

    public CatalogChooser getCatalogChooser() {
        return this.catalogChooser;
    }

    public void save() {
        this.catalogChooser.save();
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.pipeOut) {
            this.pipeEvent(event);
        }
        if (this.messageOut) {
            this.messageEvent(event);
        }
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    private void messageEvent(PropertyChangeEvent e) {
        Formatter buff = new Formatter();
        buff.format("Event propertyName = %s", e.getPropertyName());
        Object newValue = e.getNewValue();
        if (newValue != null) {
            buff.format(", class = %s", newValue.getClass().getName());
        }
        buff.format("%n", new Object[0]);
        if (e.getPropertyName().equals("Dataset")) {
            this.showDatasetInfo(buff, (Dataset)e.getNewValue());
        } else if (e.getPropertyName().equals("Datasets")) {
            Object[] ds = (Object[])e.getNewValue();
            buff.format(" element class = %s%n", ds[0].getClass().getName());
            for (Object d : ds) {
                if (!(d instanceof Dataset)) continue;
                this.showDatasetInfo(buff, (Dataset)d);
            }
        }
        JOptionPane.showMessageDialog(this.frame, buff);
    }

    private void pipeEvent(PropertyChangeEvent e) {
        Formatter buff = new Formatter();
        if (e.getPropertyName().equals("Dataset")) {
            this.getAccessURLs(buff, (Dataset)e.getNewValue());
        } else if (e.getPropertyName().equals("Datasets")) {
            Object[] ds;
            for (Object d : ds = (Object[])e.getNewValue()) {
                if (!(d instanceof Dataset)) continue;
                this.getAccessURLs(buff, (Dataset)d);
            }
        }
        System.out.println(buff);
    }

    private void getAccessURLs(Formatter buff, Dataset ds) {
        for (Access ac : ds.getAccess()) {
            buff.format("%s %s %n", new Object[]{ac.getStandardUrlName(), ac.getService().getType()});
        }
    }

    private void showDatasetInfo(Formatter buff, Dataset ds) {
        buff.format(" Dataset = %s", ds.getName());
        buff.format(", dataType = %s%n", new Object[]{ds.getFeatureType()});
        for (Access ac : ds.getAccess()) {
            buff.format("  service = %s, url = %s%n", new Object[]{ac.getService().getType(), ac.getStandardUrlName()});
        }
    }

    public JDialog makeDialog(JFrame parent, String title, boolean modal) {
        return new Dialog(this.frame, title, modal);
    }

    public static void main(String[] args) {
        boolean usePopup = false;
        for (String arg : args) {
            if (!arg.equals("-usePopup")) continue;
            usePopup = true;
        }
        try {
            store = XMLStore.createFromFile("ThreddsDatasetChooser", null);
            p = store.getPreferences();
        }
        catch (IOException e) {
            System.out.println("XMLStore Creation failed " + e);
        }
        final JFrame frame = new JFrame("Thredds Dataset Chooser");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                chooser.save();
                Rectangle bounds = frame.getBounds();
                p.putBeanObject(ThreddsDatasetChooser.FRAME_SIZE, bounds);
                try {
                    store.save();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                System.exit(0);
            }
        });
        chooser = new ThreddsDatasetChooser(p, null, frame, true, usePopup, false);
        chooser.setDoResolve(true);
        frame.getContentPane().add(chooser);
        Rectangle bounds = (Rectangle)p.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
    }

    private class Dialog
    extends JDialog {
        private Dialog(JFrame frame, String title, boolean modal) {
            super(frame, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            JButton dismissButton = new JButton("Dismiss");
            dismissButton.addActionListener(e -> this.setVisible(false));
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)ThreddsDatasetChooser.this, "Center");
            this.pack();
        }
    }
}

