/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import ucar.httpservices.HTTPException;

public class HTTPProviderFactory {
    protected Class<CredentialsProvider> providerclass = null;
    protected Constructor<CredentialsProvider> constructor = null;

    protected HTTPProviderFactory() throws HTTPException {
        this(null);
    }

    public HTTPProviderFactory(Class<CredentialsProvider> pclass) throws HTTPException {
        this.providerclass = pclass;
        if (pclass != null) {
            try {
                this.constructor = pclass.getConstructor(AuthScope.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new HTTPException("HTTPProviderFactory: no proper constructor available", e);
            }
        }
    }

    public CredentialsProvider getProvider(AuthScope scope) throws HTTPException {
        if (this.providerclass == null) {
            return null;
        }
        try {
            CredentialsProvider cp = this.constructor.newInstance(scope);
            return cp;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HTTPException("HTTPProvider Factory failure", e);
        }
    }
}

