/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.TimeUnitConverter;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.coord.TimeCoordIntvDateValue;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.CfsrLocalTables;
import ucar.nc2.grib.grib2.table.EccodesLocalTables;
import ucar.nc2.grib.grib2.table.FslHrrrLocalTables;
import ucar.nc2.grib.grib2.table.GempakLocalTables;
import ucar.nc2.grib.grib2.table.Grib2CodeTableInterface;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.Grib2TablesId;
import ucar.nc2.grib.grib2.table.KmaLocalTables;
import ucar.nc2.grib.grib2.table.MrmsLocalTables;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.grib.grib2.table.NdfdLocalTables;
import ucar.nc2.grib.grib2.table.NwsMetDevTables;
import ucar.nc2.grib.grib2.table.WmoCodeFlagTables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.grib.grib2.table.WmoParamTable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.wmo.CommonCodeTable;

@Immutable
public class Grib2Tables
implements GribTables,
TimeUnitConverter {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Tables.class);
    private static Map<Grib2TablesId, Grib2Tables> tables = new HashMap<Grib2TablesId, Grib2Tables>();
    private static Grib2Tables wmoStandardTable = null;
    protected final Grib2TableConfig config;
    private boolean timeUnitWarnWasSent;
    private TimeUnitConverter timeUnitConverter;

    public static Grib2Tables factory(Grib2Record gr) {
        Grib2SectionIdentification ids = gr.getId();
        Grib2Pds pds = gr.getPDS();
        return Grib2Tables.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version(), pds.getGenProcessId());
    }

    public static Grib2Tables factory(int center, int subCenter, int masterVersion, int localVersion, int genProcessId) {
        Grib2TablesId id = new Grib2TablesId(center, subCenter, masterVersion, localVersion, genProcessId);
        Grib2Tables cust = tables.get(id);
        if (cust != null) {
            return cust;
        }
        Grib2TableConfig config = Grib2TableConfig.matchTable(id);
        cust = Grib2Tables.build(config);
        tables.put(id, cust);
        return cust;
    }

    private static Grib2Tables build(Grib2TableConfig config) {
        switch (config.getType()) {
            case cfsr: {
                return new CfsrLocalTables(config);
            }
            case eccodes: {
                return new EccodesLocalTables(config);
            }
            case gempak: {
                return new GempakLocalTables(config);
            }
            case gsd: {
                return new FslHrrrLocalTables(config);
            }
            case kma: {
                return new KmaLocalTables(config);
            }
            case ncep: {
                return new NcepLocalTables(config);
            }
            case ndfd: {
                return new NdfdLocalTables(config);
            }
            case mrms: {
                return new MrmsLocalTables(config);
            }
            case nwsDev: {
                return new NwsMetDevTables(config);
            }
        }
        if (wmoStandardTable == null) {
            wmoStandardTable = new Grib2Tables(config);
        }
        return wmoStandardTable;
    }

    public static int makeParamId(int discipline, int category, int number) {
        return (discipline << 16) + (category << 8) + number;
    }

    public static int[] unmakeParamId(int code) {
        int number = code & 0xFF;
        int category = (code >>= 8) & 0xFF;
        int discipline = code >> 8;
        return new int[]{discipline, category, number};
    }

    public static String makeParamCode(int discipline, int category, int number) {
        return String.format("%d-%d-%d", discipline, category, number);
    }

    public static String makeParamCode(int code) {
        int number = code & 0xFF;
        int category = (code >>= 8) & 0xFF;
        int discipline = code >> 8;
        return String.format("%d-%d-%d", discipline, category, number);
    }

    public static boolean isLocal(GribTables.Parameter p) {
        return Grib2Tables.isLocal(p.getDiscipline(), p.getCategory(), p.getNumber());
    }

    public static boolean isLocal(int discipline, int category, int number) {
        return discipline <= 191 && category <= 191 && number <= 191;
    }

    public static boolean isLocal(int code) {
        int[] uncode = Grib2Tables.unmakeParamId(code);
        return Grib2Tables.isLocal(uncode[0], uncode[1], uncode[2]);
    }

    public static ImmutableList<Grib2Tables> getAllRegisteredTables() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Grib2TableConfig config : Grib2TableConfig.getTables()) {
            builder.add(Grib2Tables.build(config));
        }
        return builder.build();
    }

    protected Grib2Tables(Grib2TableConfig config) {
        this.config = config;
    }

    public String getName() {
        return this.config.getName();
    }

    public int getCenterId() {
        return this.config.getConfigId().center;
    }

    public String getPath() {
        return this.config.getPath();
    }

    public Grib2TablesId getConfigId() {
        return this.config.getConfigId();
    }

    public Grib2TablesId.Type getType() {
        return this.config.getType();
    }

    public String getVariableName(Grib2Record gr) {
        return this.getVariableName(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
    }

    public String getVariableName(int discipline, int category, int parameter) {
        String s2 = WmoParamTable.getParameterName(discipline, category, parameter);
        if (s2 == null) {
            s2 = "U" + discipline + "-" + category + "-" + parameter;
        }
        return s2;
    }

    @Nullable
    public GribTables.Parameter getParameter(Grib2Record gr) {
        return this.getParameter(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
    }

    @Nullable
    public GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex vindex) {
        return this.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
    }

    public GribTables.Parameter getParameter(int discipline, Grib2Pds pds) {
        return this.getParameter(discipline, pds.getParameterCategory(), pds.getParameterNumber());
    }

    @Nullable
    GribTables.Parameter getParameter(int discipline, int category, int number) {
        return WmoParamTable.getParameter(discipline, category, number);
    }

    @Nullable
    public String getCodeTableValue(String tableName, int code) {
        WmoCodeTable codeTable = WmoCodeFlagTables.getInstance().getCodeTable(tableName);
        Grib2CodeTableInterface.Entry entry = codeTable == null ? null : codeTable.getEntry(code);
        return entry == null ? null : entry.getName();
    }

    @Override
    @Nullable
    public String getSubCenterName(int center_id, int subcenter_id) {
        return CommonCodeTable.getSubCenterName(center_id, subcenter_id);
    }

    @Override
    @Nullable
    public String getGeneratingProcessName(int genProcess) {
        return null;
    }

    @Override
    @Nullable
    public String getGeneratingProcessTypeName(int genProcess) {
        return this.getCodeTableValue("4.3", genProcess);
    }

    @Nullable
    public String getCategory(int discipline, int category) {
        WmoCodeTable catTable = WmoCodeFlagTables.getInstance().getCodeTable("4.1." + discipline);
        Grib2CodeTableInterface.Entry entry = catTable == null ? null : catTable.getEntry(category);
        return entry == null ? null : entry.getName();
    }

    public String getStatisticName(int id) {
        String result = this.getCodeTableValue("4.10", id);
        if (result == null) {
            result = this.getStatisticNameShort(id);
        }
        return result;
    }

    public String getStatisticNameShort(int id) {
        GribStatType stat = GribStatType.getStatTypeFromGrib2(id);
        return stat == null ? "UnknownStatType-" + id : stat.toString();
    }

    @Override
    @Nullable
    public GribStatType getStatType(int grib2StatCode) {
        return GribStatType.getStatTypeFromGrib2(grib2StatCode);
    }

    public String getProbabilityNameShort(int id) {
        switch (id) {
            case 0: {
                return "unweightedMean";
            }
            case 1: {
                return "weightedMean";
            }
            case 2: {
                return "stdDev";
            }
            case 3: {
                return "stdDevNormalized";
            }
            case 4: {
                return "spread";
            }
            case 5: {
                return "largeAnomalyIndex";
            }
            case 6: {
                return "unweightedMeanCluster";
            }
            case 7: {
                return "interquartileRange";
            }
            case 8: {
                return "minimumEnsemble";
            }
            case 9: {
                return "maximumEnsemble";
            }
        }
        return "UnknownProbType" + id;
    }

    @Override
    public VertCoordType getVertUnit(int code) {
        switch (code) {
            case 11: 
            case 12: {
                return new VertCoordType(code, "m", null, true);
            }
            case 20: {
                return new VertCoordType(code, "K", null, false);
            }
            case 100: {
                return new VertCoordType(code, "Pa", null, false);
            }
            case 102: {
                return new VertCoordType(code, "m", "mean sea level", true);
            }
            case 103: {
                return new VertCoordType(code, "m", "ground", true);
            }
            case 104: 
            case 105: {
                return new VertCoordType(code, "sigma", null, false);
            }
            case 106: {
                return new VertCoordType(code, "m", "land surface", false);
            }
            case 107: {
                return new VertCoordType(code, "K", null, true);
            }
            case 108: {
                return new VertCoordType(code, "Pa", "ground", true);
            }
            case 109: {
                return new VertCoordType(code, "K m2 kg-1 s-1", null, true);
            }
            case 114: {
                return new VertCoordType(code, "numeric", null, false);
            }
            case 117: {
                return new VertCoordType(code, "m", null, true);
            }
            case 119: {
                return new VertCoordType(code, "Pa", null, false);
            }
            case 160: {
                return new VertCoordType(code, "m", "sea level", false);
            }
            case 161: {
                return new VertCoordType(code, "m", "water surface", false);
            }
            case 235: {
                return new VertCoordType(code, "0.1 C", null, true);
            }
            case 237: {
                return new VertCoordType(code, "m", null, true);
            }
            case 238: {
                return new VertCoordType(code, "m", null, true);
            }
        }
        return new VertCoordType(code, null, null, true);
    }

    public boolean isLevelUsed(int code) {
        VertCoordType vunit = this.getVertUnit(code);
        return vunit.isVerticalCoordinate();
    }

    @Nullable
    public String getLevelName(int id) {
        return this.getCodeTableValue("4.5", id);
    }

    public boolean isLayer(Grib2Pds pds) {
        return pds.getLevelType2() != 255 && pds.getLevelType2() != 0;
    }

    @Override
    public String getLevelNameShort(int id) {
        switch (id) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 10: {
                return "entire_atmosphere";
            }
            case 11: {
                return "cumulonimbus_base";
            }
            case 12: {
                return "cumulonimbus_top";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "isobaric";
            }
            case 101: {
                return "msl";
            }
            case 102: {
                return "altitude_above_msl";
            }
            case 103: {
                return "height_above_ground";
            }
            case 104: {
                return "sigma";
            }
            case 105: {
                return "hybrid";
            }
            case 106: {
                return "depth_below_surface";
            }
            case 107: {
                return "isentrope";
            }
            case 108: {
                return "pressure_difference";
            }
            case 109: {
                return "potential_vorticity_surface";
            }
            case 111: {
                return "eta";
            }
            case 113: {
                return "log_hybrid";
            }
            case 117: {
                return "mixed_layer_depth";
            }
            case 118: {
                return "hybrid_height";
            }
            case 119: {
                return "hybrid_pressure";
            }
            case 120: {
                return "pressure_thickness";
            }
            case 160: {
                return "depth_below_sea";
            }
            case -9999: {
                return "none";
            }
        }
        return "UnknownLevelType-" + id;
    }

    public void setTimeUnitConverter(TimeUnitConverter timeUnitConverter) {
        if (this.timeUnitConverter != null) {
            throw new RuntimeException("Cant modify timeUnitConverter once its been set");
        }
        this.timeUnitConverter = timeUnitConverter;
    }

    @Override
    public int convertTimeUnit(int timeUnit) {
        if (this.timeUnitConverter == null) {
            return timeUnit;
        }
        return this.timeUnitConverter.convertTimeUnit(timeUnit);
    }

    @Nullable
    public CalendarDate getForecastDate(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (pds.isTimeInterval()) {
            TimeCoordIntvDateValue intv = this.getForecastTimeInterval(gr);
            return intv == null ? null : intv.getEnd();
        }
        int val = pds.getForecastTime();
        CalendarPeriod period = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(pds.getTimeUnit()));
        if (period == null) {
            return null;
        }
        return gr.getReferenceDate().add(period.multiply(val));
    }

    @Nullable
    public TimeCoordIntvDateValue getForecastTimeInterval(Grib2Record gr) {
        if (!gr.getPDS().isTimeInterval()) {
            return null;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        int timeUnitOrg = gr.getPDS().getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit == 255) continue;
            if ((ti.timeRangeUnit != timeUnitOrg || ti.timeIncrementUnit != timeUnitOrg && ti.timeIncrementUnit != 255 && ti.timeIncrement != 0) && !this.timeUnitWarnWasSent) {
                logger.warn("TimeInterval has different units timeUnit org=" + timeUnitOrg + " TimeInterval=" + ti.timeIncrementUnit);
                this.timeUnitWarnWasSent = true;
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        CalendarPeriod unitPeriod = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(timeUnitOrg));
        if (unitPeriod == null) {
            return null;
        }
        CalendarPeriod period = unitPeriod.multiply(range);
        CalendarDate EI = pdsIntv.getIntervalTimeEnd();
        if (EI == CalendarDate.UNKNOWN) {
            return new TimeCoordIntvDateValue(gr.getReferenceDate(), period);
        }
        return new TimeCoordIntvDateValue(period, EI);
    }

    public double getForecastTimeIntervalSizeInHours(Grib2Pds pds) {
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        int timeUnitOrg = pds.getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit == 255) continue;
            if (ti.timeRangeUnit != timeUnitOrg || ti.timeIncrementUnit != timeUnitOrg && ti.timeIncrementUnit != 255 && ti.timeIncrement != 0) {
                logger.warn("TimeInterval(2) has different units timeUnit org=" + timeUnitOrg + " TimeInterval=" + ti.timeIncrementUnit);
                throw new RuntimeException("TimeInterval(2) has different units");
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        CalendarPeriod timeUnitPeriod = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(timeUnitOrg));
        if (timeUnitPeriod == null) {
            return -9999.0;
        }
        if (timeUnitPeriod.equals(CalendarPeriod.Hour)) {
            return range;
        }
        double fac = timeUnitPeriod.getField() == CalendarPeriod.Field.Month ? 720.0 : (timeUnitPeriod.getField() == CalendarPeriod.Field.Year ? 8760.0 : CalendarPeriod.Hour.getConvertFactor(timeUnitPeriod));
        return fac * (double)range;
    }

    @Nullable
    public int[] getForecastTimeIntervalOffset(Grib2Record gr) {
        TimeCoordIntvDateValue tinvd = this.getForecastTimeInterval(gr);
        if (tinvd == null) {
            return null;
        }
        Grib2Pds pds = gr.getPDS();
        int unit = this.convertTimeUnit(pds.getTimeUnit());
        TimeCoordIntvValue tinv = tinvd.convertReferenceDate(gr.getReferenceDate(), Grib2Utils.getCalendarPeriod(unit));
        if (tinv == null) {
            return null;
        }
        int[] result = new int[]{tinv.getBounds1(), tinv.getBounds2()};
        return result;
    }

    @Nullable
    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return WmoParamTable.getParameter(discipline, category, number);
    }

    public String getParamTablePathUsedFor(int discipline, int category, int number) {
        return WmoCodeFlagTables.standard.getResourceName();
    }

    public ImmutableList<GribTables.Parameter> getParameters() {
        ImmutableList.Builder allParams = ImmutableList.builder();
        for (WmoCodeFlagTables.WmoTable wmoTable : WmoCodeFlagTables.getInstance().getWmoTables()) {
            if (wmoTable.getType() != WmoCodeFlagTables.TableType.param) continue;
            WmoParamTable paramTable = new WmoParamTable(wmoTable);
            allParams.addAll(paramTable.getParameters());
        }
        return allParams.build();
    }

    public void lookForProblems(Formatter f) {
    }

    public void showDetails(Formatter f) {
    }

    public void showEntryDetails(Formatter f, List<GribTables.Parameter> params) {
    }

    public void showSpecialPdsInfo(Grib2Record pds, Formatter f) {
    }
}

