/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.gml;

import java.io.IOException;
import net.opengis.gml.x32.TimePositionType;
import org.joda.time.DateTime;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ogc.MarshallingUtil;
import ucar.nc2.time.CalendarDate;

public abstract class NcTimePositionType {
    public static TimePositionType initTime(TimePositionType time, PointFeature pointFeat) {
        time.setStringValue(pointFeat.getNominalTimeAsCalendarDate().toString());
        return time;
    }

    public static TimePositionType initBeginPosition(TimePositionType beginPosition, CalendarDate date) throws IOException {
        beginPosition.setStringValue(date.toString());
        return beginPosition;
    }

    public static TimePositionType initEndPosition(TimePositionType endPosition, CalendarDate date) throws IOException {
        endPosition.setStringValue(date.toString());
        return endPosition;
    }

    public static TimePositionType initTimePosition(TimePositionType timePosition) {
        DateTime resultTime = MarshallingUtil.fixedResultTime;
        if (resultTime == null) {
            resultTime = new DateTime();
        }
        timePosition.setStringValue(resultTime.toString());
        return timePosition;
    }

    private NcTimePositionType() {
    }
}

