/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis.shapefile;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

class DbaseFieldDesc {
    String Name;
    byte Type;
    int FieldLength;
    int DecimalCount;
    byte[] Header;

    DbaseFieldDesc(DataInputStream in, byte version) {
        if ((version & 3) == 3) {
            this.read_dbase3(in);
        } else {
            this.read_dbase4(in);
        }
    }

    DbaseFieldDesc(String Name2, byte Type4, int FieldLength, int DecimalCount, int SetFlags, int WorkAreaID, byte MDXflag) {
        this.Name = Name2;
        this.Type = Type4;
        this.FieldLength = FieldLength;
        this.DecimalCount = DecimalCount;
        this.Header = new byte[32];
        for (int i = 0; i < 32; ++i) {
            this.Header[i] = 32;
        }
        byte[] headerName = Name2.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(headerName, 0, this.Header, 0, headerName.length);
        this.Header[11] = Type4;
        this.Header[16] = (byte)FieldLength;
        this.Header[17] = (byte)DecimalCount;
        this.Header[23] = (byte)SetFlags;
        this.Header[20] = (byte)WorkAreaID;
        this.Header[31] = MDXflag;
    }

    private int read_dbase3(DataInputStream in) {
        this.Header = new byte[32];
        try {
            in.readFully(this.Header, 0, 32);
        }
        catch (IOException e) {
            return -1;
        }
        this.Name = new String(this.Header, 0, 11, StandardCharsets.UTF_8);
        this.Name = this.Name.trim();
        this.Type = this.Header[11];
        this.FieldLength = this.Header[16];
        if (this.FieldLength < 0) {
            this.FieldLength += 256;
        }
        this.DecimalCount = this.Header[17];
        if (this.DecimalCount < 0) {
            this.DecimalCount += 256;
        }
        return 0;
    }

    private int read_dbase4(DataInputStream in) {
        if (this.read_dbase3(in) != 0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.Name;
    }
}

