/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.coord.SparseArray;
import ucar.nc2.ui.ReportPanel;
import ucar.nc2.ui.grib.Grib2ReportPanel;
import ucar.nc2.util.CloseableIterator;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class CdmIndexReportPanel
extends ReportPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2ReportPanel.class);
    String lastFilename = null;
    private static final int MIN_COUNT = 400;

    public CdmIndexReportPanel(PreferencesExt prefs) {
        super(prefs);
    }

    @Override
    public Object[] getOptions() {
        return Report.values();
    }

    @Override
    protected void doReport(Formatter f, Object option, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        switch ((Report)((Object)option)) {
            case dupAndMissing: {
                this.doDupAndMissing(f, dcm, eachFile, extra);
                break;
            }
            case misplacedFlds: {
                this.doMisplacedFields(f, dcm, useIndex, eachFile, extra);
            }
        }
    }

    protected void doDupAndMissing(Formatter f, MCollection dcm, boolean eachFile, boolean extra) throws IOException {
        Accum total = new Accum();
        try (CloseableIterator<MFile> iter = dcm.getFileIterator();){
            while (iter != null && iter.hasNext()) {
                this.doDupAndMissingEach(f, (MFile)iter.next(), eachFile, extra, total);
            }
        }
        f.format("total %s%n", total);
    }

    private void doDupAndMissingEach(Formatter f, MFile mfile, boolean each, boolean extra, Accum accum) throws IOException {
        if (each) {
            f.format("%nFile %s%n", mfile.getPath());
        }
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex(mfile.getPath(), config, false, logger);){
            if (gc == null) {
                f.format("Not a grib collection index file=%s%n" + mfile.getPath(), new Object[0]);
                return;
            }
            for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                if (each) {
                    f.format("%nDataset %s%n", new Object[]{ds.getType()});
                }
                for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                    Accum groupAccum = new Accum();
                    if (each) {
                        f.format(" Group %s%n", g2.getDescription());
                    }
                    for (GribCollectionImmutable.VariableIndex v : g2.getVariables()) {
                        if (each && extra) {
                            f.format("  %s%n", v.toStringFrom());
                        } else {
                            this.showIfNonZero(f, v, mfile.getPath());
                        }
                        groupAccum.add(v);
                        accum.add(v);
                    }
                    if (!each) continue;
                    f.format("total %s%n", groupAccum);
                }
            }
        }
    }

    void showIfNonZero(Formatter f, GribCollectionImmutable.VariableIndex v, String filename) {
        if (v.getNdups() != 0 || v.getNmissing() != 0) {
            if (!filename.equals(this.lastFilename)) {
                f.format(" %s%n  %s%n", filename, v.toStringFrom());
            } else {
                f.format("  %s%n", v.toStringFrom());
            }
            this.lastFilename = filename;
        }
    }

    protected void doMisplacedFields(Formatter f, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        if (eachFile) {
            HashSet<String> filenames = new HashSet<String>();
            try (CloseableIterator<MFile> iter = dcm.getFileIterator();){
                while (iter != null && iter.hasNext()) {
                    this.doMisplacedFieldsEach(f, (MFile)iter.next(), filenames, extra);
                }
            }
            f.format("%nAll files%n", new Object[0]);
            for (String filename : filenames) {
                f.format("  %s%n", filename);
            }
        } else {
            this.doMisplacedFields(f, dcm, extra);
        }
    }

    private void doMisplacedFieldsEach(Formatter f2, MFile mfile, Set<String> filenames, boolean extra) throws IOException {
        Formatter f = new Formatter(System.out);
        f.format("Check Misplaced Fields for %s, records count < %d%n", mfile, 400);
        HashMap<Integer, VarInfo> varCount = new HashMap<Integer, VarInfo>();
        int countMisplaced = 0;
        f.format("%n%s%n", mfile.getPath());
        this.countTop(mfile.getPath(), f, varCount);
        f.format("%nTotals%n", new Object[0]);
        ArrayList sorted = new ArrayList(varCount.values());
        Collections.sort(sorted);
        for (VarInfo vinfo : sorted) {
            f.format(" %20s = %d%n", vinfo.name, vinfo.count);
            if (vinfo.count > 400) {
                vinfo.ok = true;
            }
            if (vinfo.ok) continue;
            countMisplaced += vinfo.count;
        }
        f.format("countMisplaced = %d%n", countMisplaced);
        countMisplaced = 0;
        f.format("%nFind Misplaced Files%n", new Object[0]);
        File indexFile = new File(mfile.getPath());
        f.format("%nDone countMisplaced=%d (n < %d)%n%nFiles%n", 400, countMisplaced += this.doOneIndex(indexFile, f, varCount, filenames, new Indent(2), extra));
        f2.format("%s", f.toString());
    }

    private void doMisplacedFields(Formatter f, MCollection dcm, boolean extra) throws IOException {
        f.format("Check Misplaced Fields, records count < %d%n", 400);
        HashMap<Integer, VarInfo> varCount = new HashMap<Integer, VarInfo>();
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("%n%s%n", mfile.getPath());
            this.countTop(mfile.getPath(), f, varCount);
        }
        int countMisplaced = 0;
        f.format("%nTotals%n", new Object[0]);
        ArrayList sorted = new ArrayList(varCount.values());
        Collections.sort(sorted);
        for (VarInfo vinfo : sorted) {
            f.format(" %20s = %d%n", vinfo.name, vinfo.count);
            if (vinfo.count > 400) {
                vinfo.ok = true;
            }
            if (vinfo.ok) continue;
            countMisplaced += vinfo.count;
        }
        f.format("countMisplaced = %d%n", countMisplaced);
        HashSet<String> filenames = new HashSet<String>();
        countMisplaced = 0;
        f.format("%nFind Misplaced Files%n", new Object[0]);
        for (MFile mfile : dcm.getFilesSorted()) {
            File indexFile = new File(mfile.getPath());
            countMisplaced += this.doOneIndex(indexFile, f, varCount, filenames, new Indent(2), extra);
        }
        f.format("%nDone countMisplaced=%d (n < %d)%n%nFiles%n", 400, countMisplaced);
        for (String filename : filenames) {
            f.format("  %s%n", filename);
        }
    }

    public void countTop(String indexFile, Formatter f, Map<Integer, VarInfo> varCount) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex(indexFile, config, false, logger);){
            if (gc == null) {
                throw new IOException(indexFile + " not a grib collection index file");
            }
            for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                if (!ds.getType().equals((Object)GribCollectionImmutable.Type.TwoD)) continue;
                for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                    f.format(" Group %s%n", g2.getDescription());
                    for (GribCollectionImmutable.VariableIndex vi : g2.getVariables()) {
                        String name = vi.makeVariableName();
                        int nrecords = vi.getNRecords();
                        f.format("  %7d: %s%n", nrecords, name);
                        int hash = vi.hashCode() + g2.getGdsHash().hashCode();
                        VarInfo vinfo = varCount.get(hash);
                        if (vinfo == null) {
                            vinfo = new VarInfo(name);
                            varCount.put(hash, vinfo);
                        }
                        vinfo.count += nrecords;
                    }
                }
            }
        }
    }

    private int doOneIndex(File indexFile, Formatter f, Map<Integer, VarInfo> varCount, Set<String> filenames, Indent indent, boolean showScan) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "r");){
            GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
            if (showScan) {
                f.format("%sIndex %s type=%s", new Object[]{indent, indexFile, type});
            }
        }
        int totalMisplaced = 0;
        try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex(indexFile.getPath(), config, false, logger);){
            VarInfo vinfo;
            int hash;
            if (gc == null) {
                throw new IOException(indexFile + " not a grib collection index file");
            }
            int countMisplaced = 0;
            for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                if (ds.getType().equals((Object)GribCollectionImmutable.Type.Best)) continue;
                for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                    for (GribCollectionImmutable.VariableIndex vi : g2.getVariables()) {
                        hash = vi.hashCode() + g2.getGdsHash().hashCode();
                        vinfo = varCount.get(hash);
                        if (vinfo == null) {
                            f.format("ERROR on vi %s%n", vi);
                            continue;
                        }
                        if (vinfo.ok) continue;
                        countMisplaced += vi.getNRecords();
                    }
                }
            }
            if (countMisplaced == 0) {
                if (showScan) {
                    f.format(" none%n", new Object[0]);
                }
                int n = 0;
                return n;
            }
            indent.incr();
            if (gc instanceof PartitionCollectionImmutable) {
                PartitionCollectionImmutable pc = (PartitionCollectionImmutable)gc;
                boolean isPoP = pc.isPartitionOfPartitions();
                if (showScan) {
                    f.format(" isPofP=%s%n", isPoP);
                }
                for (PartitionCollectionImmutable.Partition partition : pc.getPartitions()) {
                    File nestedIndex = new File(partition.getIndexFilenameInCache());
                    if (showScan) {
                        f.format("%sPartition index= %s exists=%s%n", indent, nestedIndex, nestedIndex.exists());
                    }
                    if (nestedIndex.exists()) {
                        totalMisplaced += this.doOneIndex(nestedIndex, f, varCount, filenames, indent.incr(), showScan);
                        indent.decr();
                        continue;
                    }
                    f.format("%sdir=%s filename=%s nestedIndex %s NOT EXIST%n", indent, gc.getDirectory(), partition.getFilename(), nestedIndex.getPath());
                }
            } else {
                if (showScan) {
                    f.format("%n", new Object[0]);
                }
                f.format("%sIndex %s count=%d%n", indent, indexFile, countMisplaced);
                indent.incr();
                for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                    if (ds.getType().equals((Object)GribCollectionImmutable.Type.Best)) continue;
                    for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                        for (GribCollectionImmutable.VariableIndex vi : g2.getVariables()) {
                            hash = vi.hashCode() + g2.getGdsHash().hashCode();
                            vinfo = varCount.get(hash);
                            if (vinfo.ok) continue;
                            vi.readRecords();
                            if (vi.getSparseArray() == null) continue;
                            SparseArray<GribCollectionImmutable.Record> sa = vi.getSparseArray();
                            for (GribCollectionImmutable.Record record : sa.getContent()) {
                                String filename = gc.getFilename(record.fileno);
                                f.format(">%s%s: %s at pos %d%n", indent, vinfo.name, filename, record.pos);
                                ++totalMisplaced;
                                filenames.add(filename);
                            }
                        }
                    }
                }
                indent.decr();
            }
        }
        indent.decr();
        return totalMisplaced;
    }

    private static class VarInfo
    implements Comparable<VarInfo> {
        String name;
        int count = 0;
        boolean ok;

        private VarInfo(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(VarInfo o) {
            return this.name.compareTo(o.name);
        }
    }

    private static class Accum {
        int nrecords;
        int ndups;
        int nmissing;

        private Accum() {
        }

        Accum add(GribCollectionImmutable.VariableIndex v) {
            this.nrecords += v.getNrecords();
            this.ndups += v.getNdups();
            this.nmissing += v.getNmissing();
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("nrecords", this.nrecords).add("ndups", this.ndups).add("nmissing", this.nmissing).toString();
        }
    }

    public static enum Report {
        dupAndMissing,
        misplacedFlds;

    }
}

