/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.grib.grib2.table.WmoParamTable;
import ucar.nc2.ui.ReportPanel;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Grib2ReportPanel
extends ReportPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2ReportPanel.class);
    String dir = "C:/tmp/bzip/";
    private int countPDS;
    private int countPDSdup;
    int total = 0;
    int prob = 0;

    public Grib2ReportPanel(PreferencesExt prefs) {
        super(prefs);
    }

    @Override
    public Object[] getOptions() {
        return Report.values();
    }

    @Override
    protected void doReport(Formatter f, Object option, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        switch ((Report)((Object)option)) {
            case checkTables: {
                this.doCheckTables(f, dcm, useIndex);
                break;
            }
            case localUseSection: {
                this.doLocalUseSection(f, dcm, useIndex);
                break;
            }
            case uniqueTemplates: {
                this.doUniqueTemplates(f, dcm, useIndex);
                break;
            }
            case duplicatePds: {
                this.doDuplicatePds(f, dcm, useIndex);
                break;
            }
            case drsSummary: {
                this.doDrsSummary(f, dcm, useIndex, eachFile, extra);
                break;
            }
            case gdsSummary: {
                this.doGdsSummary(f, dcm, extra);
                break;
            }
            case pdsSummary: {
                this.doPdsSummary(f, dcm, eachFile);
                break;
            }
            case pdsProblems: {
                this.doPdsProblems(f, dcm, useIndex);
                break;
            }
            case idProblems: {
                this.doIdProblems(f, dcm, useIndex);
                break;
            }
            case timeCoord: {
                this.doTimeCoord(f, dcm, useIndex);
                break;
            }
            case rename: {
                this.doRename(f, dcm, useIndex);
                break;
            }
            case copyCompress: {
                this.doCopyCompress(f, dcm, useIndex, eachFile, extra);
                break;
            }
            case gribIndex: {
                this.doGribIndex(f, dcm, eachFile);
            }
        }
    }

    private void doGribIndex(Formatter f, MCollection dcm, boolean eachFile) throws IOException {
        Counters counters = new Counters();
        counters.add("GDS");
        counters.add("GDShashes");
        try (MCollection dcm2 = this.getCollectionUnfiltered(this.spec, f);){
            for (MFile mfile : dcm2.getFilesSorted()) {
                String path = mfile.getPath();
                f.format(" %s%n", path);
                this.doGribIndex(f, mfile, counters, eachFile);
            }
        }
        counters.show(f);
    }

    private void doGribIndex(Formatter fm, MFile ff, Counters counters, boolean eachFile) throws IOException {
        String path = ff.getPath();
        Grib2Index g2idx = new Grib2Index();
        g2idx.readIndex(path, 0L, CollectionUpdateType.nocheck);
        counters.count("GDS", Integer.valueOf(g2idx.getGds().size()));
        HashSet<Integer> gdsHash = new HashSet<Integer>();
        for (Grib2SectionGridDefinition gdss : g2idx.getGds()) {
            gdsHash.add(gdss.getGDS().hashCode());
        }
        counters.count("GDShashes", Integer.valueOf(gdsHash.size()));
        if (eachFile) {
            fm.format("   count=%d countHash=%d%n", g2idx.getGds().size(), gdsHash.size());
        }
    }

    private void doCopyCompress(Formatter f, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        f.format("Copy and Compress selected files%n", new Object[0]);
        Counters counters = new Counters();
        counters.add("Nbits");
        long totalOrg = 0L;
        long totalZip = 0L;
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("------- %s%n", mfile.getPath());
            long orgSize = mfile.getLength();
            totalOrg += orgSize;
            File fileOut = new File(this.dir + mfile.getName() + ".bzip2");
            try (RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
                 BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(fileOut), 100000);){
                int count = 0;
                Grib2RecordScanner scan = new Grib2RecordScanner(raf);
                while (scan.hasNext()) {
                    Grib2Record gr = scan.next();
                    this.doCopyCompress(f, gr, raf, fout, counters);
                    if (count++ % 100 != 0) continue;
                    System.out.printf("%s%n", count);
                }
            }
            long zipSize = fileOut.length();
            totalZip += zipSize;
            double r = orgSize == 0L ? 0.0 : (double)zipSize / (double)orgSize;
            f.format("  org=%d zip=%d ratio=%f%n", orgSize, zipSize, r);
        }
        double r = totalOrg != 0L ? (double)totalZip / (double)totalOrg : 0.0;
        f.format("  org=%d zip=%d ratio=%f%n", totalOrg, totalZip, r);
        counters.show(f);
    }

    private void doCopyCompress(Formatter f, Grib2Record gr, RandomAccessFile raf, OutputStream out, Counters counters) throws IOException {
        float[] data = gr.readData(raf);
        Grib2SectionDataRepresentation drss = gr.getDataRepresentationSection();
        drss.getDrs(raf);
        GribData.Info info = gr.getBinaryDataInfo(raf);
        int nbits = info.numberOfBits;
        counters.count("Nbits", Integer.valueOf(nbits));
        int width = (2 << nbits - 1) - 1;
        float dataMin = Float.MAX_VALUE;
        float dataMax = -3.4028235E38f;
        for (float fd : data) {
            dataMin = Math.min(dataMin, fd);
            dataMax = Math.max(dataMax, fd);
        }
        float scale_factor = (dataMax - dataMin) / (float)(width - 2);
        float add_offset = dataMin - scale_factor;
    }

    private void doCheckTables(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Check Grib-2 Parameter Tables%n", new Object[0]);
        int[] accum = new int[4];
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("%n %s%n", mfile.getPath());
            this.doCheckTables(mfile, f, accum);
        }
        f.format("%nGrand total=%d not operational = %d local = %d missing = %d%n", accum[0], accum[1], accum[2], accum[3]);
    }

    private void doCheckTables(MFile ff, Formatter fm, int[] accum) throws IOException {
        int local = 0;
        int miss = 0;
        int nonop = 0;
        int total = 0;
        try (GridDataset ncfile = GridDataset.open(ff.getPath());){
            for (GridDatatype dt : ncfile.getGrids()) {
                String currName = dt.getName();
                ++total;
                Attribute att = dt.findAttributeIgnoreCase("Grib_Parameter");
                if (att == null || att.getLength() != 3) continue;
                int discipline = (Integer)att.getValue(0);
                int category = (Integer)att.getValue(1);
                int number = (Integer)att.getValue(2);
                if (category > 191 || number > 191) {
                    fm.format("  local parameter (%d %d %d) = %s units=%s %n", discipline, category, number, currName, dt.getUnitsString());
                    ++local;
                    continue;
                }
                GribTables.Parameter entry = WmoParamTable.getParameter(discipline, category, number);
                if (entry == null) {
                    fm.format("  missing from WMO table (%d %d %d) = %s units=%s %n", discipline, category, number, currName, dt.getUnitsString());
                    ++miss;
                    continue;
                }
                if (entry.getOperationalStatus().equalsIgnoreCase("Operational")) continue;
                fm.format("  %s parameter = %s (%d %d %d) %n", entry.getOperationalStatus(), currName, discipline, category, number);
                ++nonop;
            }
        }
        fm.format("total=%d not operational = %d local = %d missing = %d%n", total, nonop, local, miss);
        accum[0] = accum[0] + total;
        accum[1] = accum[1] + nonop;
        accum[2] = accum[2] + local;
        accum[3] = accum[3] + miss;
    }

    private void doLocalUseSection(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Show Local Use Section%n", new Object[0]);
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            this.doLocalUseSection(mfile, f, useIndex);
        }
    }

    private void doLocalUseSection(MFile mf, Formatter f, boolean useIndex) throws IOException {
        f.format("File = %s%n", mf);
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        for (Grib2Record gr : index.getRecords()) {
            Grib2SectionLocalUse lus = gr.getLocalUseSection();
            if (lus == null || lus.getRawBytes() == null) {
                f.format(" %10d == none%n", gr.getDataSection().getStartingPosition());
                continue;
            }
            f.format(" %10d == %s%n", gr.getDataSection().getStartingPosition(), Misc.showBytes(lus.getRawBytes()));
        }
    }

    private Grib2Index createIndex(MFile mf, Formatter f) throws IOException {
        Grib2Index index = new Grib2Index();
        String path = mf.getPath();
        if (!index.readIndex(path, mf.getLastModified())) {
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                if (!Grib2RecordScanner.isValidFile(raf)) {
                    Grib2Index grib2Index = null;
                    return grib2Index;
                }
                index.makeIndex(path, raf);
            }
        }
        return index;
    }

    private void doUniqueTemplates(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Show Unique GDS and PDS templates%n", new Object[0]);
        HashMap<Integer, FileList> gdsSet = new HashMap<Integer, FileList>();
        HashMap<Integer, FileList> pdsSet = new HashMap<Integer, FileList>();
        HashMap<Integer, FileList> drsSet = new HashMap<Integer, FileList>();
        for (MFile mFile : dcm.getFilesSorted()) {
            f.format(" %s%n", mFile.getPath());
            this.doUniqueTemplates(mFile, gdsSet, pdsSet, drsSet, f);
        }
        ArrayList sorted = new ArrayList(gdsSet.values());
        Collections.sort(sorted);
        for (Object gdsl : sorted) {
            f.format("%nGDS %s template= %d %n", ((FileList)gdsl).name, ((FileList)gdsl).template);
            for (FileCount fileCount : ((FileList)gdsl).fileList) {
                f.format("  %5d %s %n", fileCount.countRecords, fileCount.f.getPath());
            }
        }
        ArrayList arrayList = new ArrayList(pdsSet.values());
        Collections.sort(arrayList);
        for (FileList pdsl : arrayList) {
            f.format("%n===================================================%n", new Object[0]);
            f.format("%nPDS %s template= %d %n", pdsl.name, pdsl.template);
            for (FileCount fc : pdsl.fileList) {
                f.format("  %5d %s %n", fc.countRecords, fc.f.getPath());
            }
        }
        ArrayList sortedDrs = new ArrayList(drsSet.values());
        Collections.sort(sortedDrs);
        for (FileList fileList : sortedDrs) {
            f.format("%n===================================================%n", new Object[0]);
            f.format("%nDRS %s template= %d %n", fileList.name, fileList.template);
            for (FileCount fc : fileList.fileList) {
                f.format("  %5d %s %n", fc.countRecords, fc.f.getPath());
            }
        }
    }

    private void doUniqueTemplates(MFile mf, Map<Integer, FileList> gdsSet, Map<Integer, FileList> pdsSet, Map<Integer, FileList> drsSet, Formatter f) {
        Grib2Index g1idx = new Grib2Index();
        String path = mf.getPath();
        boolean ok = g1idx.readIndex(path, 0L, CollectionUpdateType.nocheck);
        if (!ok) {
            f.format("**Cant open %s%n", path);
            return;
        }
        for (Grib2Record gr : g1idx.getRecords()) {
            int template = gr.getGDSsection().getGDSTemplateNumber();
            gdsSet.computeIfAbsent(template, k -> new FileList((int)k, gr.getGDSsection().getGDS().getNameShort()));
            gdsSet.get(template).findAndAdd(mf);
            int pdsTemplate = gr.getPDSsection().getPDSTemplateNumber();
            pdsSet.computeIfAbsent(pdsTemplate, k -> new FileList((int)k, gr.getPDSsection().getPDS().getClass().getName()));
            pdsSet.get(pdsTemplate).findAndAdd(mf);
            int drsTemplate = gr.getDataRepresentationSection().getDataTemplate();
            drsSet.computeIfAbsent(drsTemplate, k -> new FileList((int)k, "DRS" + k));
            drsSet.get(drsTemplate).findAndAdd(mf);
        }
    }

    private void doDuplicatePds(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        this.countPDS = 0;
        this.countPDSdup = 0;
        f.format("Show Duplicate PDS%n", new Object[0]);
        for (MFile mfile : dcm.getFilesSorted()) {
            this.doDuplicatePds(f, mfile);
        }
        f.format("Total PDS duplicates = %d / %d%n%n", this.countPDSdup, this.countPDS);
    }

    private void doDuplicatePds(Formatter f, MFile mfile) throws IOException {
        HashSet<Long> pdsMap = new HashSet<Long>();
        int dups = 0;
        int count = 0;
        RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
        Grib2RecordScanner scan = new Grib2RecordScanner(raf);
        while (scan.hasNext()) {
            Grib2Record gr = scan.next();
            Grib2SectionProductDefinition pds = gr.getPDSsection();
            long crc = pds.calcCRC();
            if (pdsMap.contains(crc)) {
                ++dups;
            } else {
                pdsMap.add(crc);
            }
            ++count;
        }
        raf.close();
        f.format("PDS duplicates = %d / %d for %s%n%n", dups, count, mfile.getPath());
        this.countPDS += count;
        this.countPDSdup += dups;
    }

    private void doPdsProblems(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Check Grib-2 PDS probability and statistical variables%n", new Object[0]);
        this.total = 0;
        this.prob = 0;
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("%n %s%n", mfile.getPath());
            this.doPdsProblems(f, mfile);
        }
        f.format("problems = %d/%d%n", this.prob, this.total);
    }

    private void doPdsProblems(Formatter fm, MFile ff) throws IOException {
        String path = ff.getPath();
        Grib2Index index = this.createIndex(ff, fm);
        if (index == null) {
            return;
        }
        Formatter errlog = new Formatter();
        GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(false, ff, CollectionUpdateType.nocheck, new FeatureCollectionConfig(), errlog, logger);
        Throwable throwable = null;
        if (gc != null) {
            if (throwable != null) {
                try {
                    gc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                gc.close();
            }
        }
        try {
            throwable = null;
            try (GridDataset ncfile = GridDataset.open(path + ".ncx4");){
                for (GridDatatype dt : ncfile.getGrids()) {
                    int type;
                    int statType;
                    String currName = dt.getName();
                    ++this.total;
                    Attribute att = dt.findAttributeIgnoreCase("Grib_Probability_Type");
                    if (att != null) {
                        fm.format("  %s (PROB) desc=%s %n", currName, dt.getDescription());
                        ++this.prob;
                    }
                    if ((att = dt.findAttributeIgnoreCase("Grib_Statistical_Interval_Type")) != null && ((statType = att.getNumericValue().intValue()) == 7 || statType == 9)) {
                        fm.format("  %s (STAT type %s) desc=%s %n", currName, statType, dt.getDescription());
                        ++this.prob;
                    }
                    if ((att = dt.findAttributeIgnoreCase("Grib_Ensemble_Derived_Type")) == null || (type = att.getNumericValue().intValue()) <= 9) continue;
                    fm.format("  %s (DERIVED type %s) desc=%s %n", currName, type, dt.getDescription());
                    ++this.prob;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable ioe) {
            fm.format("Failed on %s == %s%n", path, ioe.getMessage());
            System.out.printf("Failed on %s%n", path);
            ioe.printStackTrace();
        }
    }

    private void doPdsSummary(Formatter f, MCollection dcm, boolean eachFile) throws IOException {
        Counters countersAll = new Counters();
        countersAll.add("template");
        countersAll.add("timeUnit");
        countersAll.add("timeOffset");
        countersAll.add("timeIntervalSize");
        countersAll.add("levelType");
        countersAll.add("genProcessType");
        countersAll.add("genProcessId");
        countersAll.add("levelScale");
        countersAll.add("nExtraCoords");
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("---%s%n", mfile.getPath());
            this.doPdsSummary(f, mfile, countersAll);
            if (!eachFile) continue;
            countersAll.show(f);
            countersAll.reset();
        }
        f.format("PdsSummary - all files%n", new Object[0]);
        if (!eachFile) {
            countersAll.show(f);
        }
    }

    private void doPdsSummary(Formatter f, MFile mf, Counters counters) throws IOException {
        boolean showLevel = true;
        boolean showCoords = true;
        int firstPtype = -1;
        boolean shutup = false;
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        Grib2Tables cust = null;
        for (Grib2Record gr : index.getRecords()) {
            int[] intv;
            if (cust == null) {
                cust = Grib2Tables.factory(gr);
            }
            Grib2Pds pds = gr.getPDS();
            counters.count("template", Integer.valueOf(pds.getTemplateNumber()));
            counters.count("timeUnit", Integer.valueOf(pds.getTimeUnit()));
            counters.count("timeOffset", Integer.valueOf(pds.getForecastTime()));
            if (pds.isTimeInterval() && (intv = cust.getForecastTimeIntervalOffset(gr)) != null) {
                counters.count("timeIntervalSize", Integer.valueOf(intv[1] - intv[0]));
            }
            counters.count("levelType", Integer.valueOf(pds.getLevelType1()));
            if (showLevel && pds.getLevelType1() == 105) {
                showLevel = false;
                f.format(" level = 105 : %s%n", mf.getPath());
            }
            int n = pds.getExtraCoordinatesCount();
            counters.count("nExtraCoords", Integer.valueOf(n));
            if (showCoords && n > 0) {
                showCoords = false;
                f.format(" ncoords > 0 : %s%n", mf.getPath());
            }
            int ptype = pds.getGenProcessType();
            counters.count("genProcessType", Integer.valueOf(ptype));
            counters.count("genProcessId", Integer.valueOf(pds.getGenProcessId()));
            if (pds.getLevelScale1() <= 127 || !cust.isLevelUsed(pds.getLevelType1())) continue;
            f.format(" LevelScale > 127: %s %s == %d%n", mf.getPath(), gr.getPDS().getParameterNumber(), pds.getLevelScale1());
            counters.count("levelScale", Integer.valueOf(pds.getLevelScale1()));
        }
    }

    private void doIdProblems(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Look for ID Problems%n", new Object[0]);
        Counters countersAll = new Counters();
        countersAll.add("discipline");
        countersAll.add("masterTable");
        countersAll.add("localTable");
        countersAll.add("centerId");
        countersAll.add("subcenterId");
        countersAll.add("genProcess");
        countersAll.add("backProcess");
        countersAll.add("significanceOfReference");
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            this.doIdProblems(f, mfile, useIndex, countersAll);
        }
        countersAll.show(f);
    }

    private void doIdProblems(Formatter f, MFile mf, boolean showProblems, Counters countersAll) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        int center = -1;
        int subcenter = -1;
        int master = -1;
        int local = -1;
        int genProcess = -1;
        int backProcess = -1;
        int sigRef = -1;
        for (Grib2Record gr : index.getRecords()) {
            countersAll.count("discipline", Integer.valueOf(gr.getDiscipline()));
            countersAll.count("masterTable", Integer.valueOf(gr.getId().getMaster_table_version()));
            countersAll.count("localTable", Integer.valueOf(gr.getId().getLocal_table_version()));
            countersAll.count("centerId", Integer.valueOf(gr.getId().getCenter_id()));
            countersAll.count("subcenterId", Integer.valueOf(gr.getId().getSubcenter_id()));
            countersAll.count("genProcess", Integer.valueOf(gr.getPDS().getGenProcessId()));
            countersAll.count("backProcess", Integer.valueOf(gr.getPDS().getBackProcessId()));
            countersAll.count("significanceOfReference", Integer.valueOf(gr.getId().getSignificanceOfRT()));
            if (!showProblems) continue;
            if (gr.getDiscipline() == 255) {
                f.format("  bad discipline= ", new Object[0]);
                gr.show(f);
                f.format("%n", new Object[0]);
            }
            int val = gr.getId().getCenter_id();
            if (center < 0) {
                center = val;
            } else if (center != val) {
                f.format("  center %d != %d ", center, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getSubcenter_id();
            if (subcenter < 0) {
                subcenter = val;
            } else if (subcenter != val) {
                f.format("  subcenter %d != %d ", subcenter, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getMaster_table_version();
            if (master < 0) {
                master = val;
            } else if (master != val) {
                f.format("  master %d != %d ", master, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getLocal_table_version();
            if (local < 0) {
                local = val;
            } else if (local != val) {
                f.format("  local %d != %d ", local, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getPDS().getGenProcessId();
            if (genProcess < 0) {
                genProcess = val;
            } else if (genProcess != val) {
                f.format("  genProcess %d != %d ", genProcess, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getPDS().getBackProcessId();
            if (backProcess < 0) {
                backProcess = val;
            } else if (backProcess != val) {
                f.format("  backProcess %d != %d ", backProcess, val);
                gr.show(f);
                f.format(" %s%n", gr.getId());
            }
            val = gr.getId().getSignificanceOfRT();
            if (sigRef < 0) {
                sigRef = val;
                continue;
            }
            if (sigRef == val) continue;
            f.format("  sigRef %d != %d ", sigRef, val);
            gr.show(f);
            f.format(" %s%n", gr.getId());
        }
    }

    private void doDrsSummary(Formatter f, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        f.format("Show Unique DRS Templates%n", new Object[0]);
        Counters countersAll = new Counters();
        countersAll.add("DRS_template");
        countersAll.add("BMS indicator");
        countersAll.add("DRS template 40 signed problem");
        countersAll.add("Number_of_Bits");
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("------- %s%n", mfile.getPath());
            if (useIndex) {
                this.doDrsSummaryIndex(f, mfile, extra, countersAll);
            } else {
                this.doDrsSummaryScan(f, mfile, extra, countersAll);
            }
            if (!eachFile) continue;
            countersAll.show(f);
            f.format("%n", new Object[0]);
            countersAll.reset();
        }
        if (!eachFile) {
            countersAll.show(f);
        }
    }

    private void doDrsSummaryIndex(Formatter f, MFile mf, boolean extra, Counters counters) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        long messageSum = 0L;
        int nrecords = 0;
        String path = mf.getPath();
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            for (Grib2Record gr : index.getRecords()) {
                Grib2Drs.Type40 drs40;
                Grib2SectionDataRepresentation drss = gr.getDataRepresentationSection();
                int template = drss.getDataTemplate();
                counters.count("DRS_template", Integer.valueOf(template));
                messageSum += gr.getIs().getMessageLength();
                ++nrecords;
                counters.count("BMS indicator", Integer.valueOf(gr.repeat));
                if (!extra || template != 40 || (drs40 = gr.readDataTest(raf)) == null) continue;
                if (drs40.hasSignedProblem()) {
                    counters.count("DRS template 40 signed problem", Integer.valueOf(1));
                    continue;
                }
                counters.count("DRS template 40 signed problem", Integer.valueOf(0));
            }
            float percent = (float)messageSum / (float)raf.length();
            f.format("raf length = %d, messageSum = %d, percent = %f nrecords = %d%n", raf.length(), messageSum, Float.valueOf(percent), nrecords);
        }
    }

    private void doDrsSummaryScan(Formatter f, MFile mf, boolean extra, Counters counters) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(mf.getPath(), "r");
        Grib2RecordScanner scan = new Grib2RecordScanner(raf);
        while (scan.hasNext()) {
            Grib2Record gr = scan.next();
            this.doDrsSummary(gr, raf, extra, counters);
        }
        raf.close();
    }

    private void doDrsSummary(Grib2Record gr, RandomAccessFile raf, boolean extra, Counters counters) throws IOException {
        Grib2Drs.Type40 drs40;
        Grib2SectionDataRepresentation drss = gr.getDataRepresentationSection();
        int template = drss.getDataTemplate();
        counters.count("DRS_template", Integer.valueOf(template));
        counters.count("BMS indicator", Integer.valueOf(gr.repeat));
        GribData.Info info = gr.getBinaryDataInfo(raf);
        counters.count("Number_of_Bits", Integer.valueOf(info.numberOfBits));
        if (extra && template == 40 && (drs40 = gr.readDataTest(raf)) != null) {
            if (drs40.hasSignedProblem()) {
                counters.count("DRS template 40 signed problem", Integer.valueOf(1));
            } else {
                counters.count("DRS template 40 signed problem", Integer.valueOf(0));
            }
        }
    }

    private void doGdsSummary(Formatter f, MCollection dcm, boolean extra) throws IOException {
        f.format("Show Unique GDS Templates%n", new Object[0]);
        Counters counters = new Counters();
        counters.add("template");
        counters.add("scanMode");
        counters.add("scanModeDifference");
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            this.doGdsSummary(f, mfile, counters, extra);
        }
        counters.show(f);
    }

    private void doGdsSummary(Formatter f, MFile mf, Counters counters, boolean extra) throws IOException {
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return;
        }
        HashMap<Integer, Grib2SectionGridDefinition> gdssMap = new HashMap<Integer, Grib2SectionGridDefinition>();
        for (Grib2SectionGridDefinition gdss : index.getGds()) {
            gdssMap.put(gdss.hashCode(), gdss);
            Grib2Gds gds = gdss.getGDS();
            gds.testScanMode(f);
            int template = gdss.getGDSTemplateNumber();
            int scanMode = gds.getScanMode();
            if (!extra || !GribUtils.scanModeYisPositive(scanMode)) continue;
            f.format("    template %d with Ypos%n", template);
        }
        for (Grib2Record gr : index.getRecords()) {
            Grib2SectionGridDefinition gdss = gr.getGDSsection();
            Grib2SectionGridDefinition gdssIndex = (Grib2SectionGridDefinition)gdssMap.get(gdss.hashCode());
            Grib2Gds gdsIndex = gdssIndex.getGDS();
            counters.count("template", Integer.valueOf(gdss.getGDSTemplateNumber()));
            counters.count("scanMode", Integer.valueOf(gr.getScanMode()));
            if (gdsIndex.getScanMode() == gr.getScanMode()) continue;
            counters.count("scanModeDifference", (Comparable)((Object)mf.getName()));
        }
    }

    private void doTimeCoord(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        Counters counters = new Counters();
        counters.add("template");
        counters.add("timeUnit");
        counters.add("statType");
        counters.add("NumberTimeIntervals");
        counters.add("TimeIntervalsDiffer");
        counters.add("TimeIntervalsLength");
        int count = 0;
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            count += this.doTimeCoord(f, mfile, counters);
        }
        f.format("total records = %d%n", count);
        counters.show(f);
    }

    private int doTimeCoord(Formatter f, MFile mf, Counters counters) throws IOException {
        boolean showTinvDiffers = true;
        boolean showNint = true;
        boolean shutup = false;
        Grib2Index index = this.createIndex(mf, f);
        if (index == null) {
            return 0;
        }
        Grib2Tables cust = null;
        int count = 0;
        for (Grib2Record gr : index.getRecords()) {
            Grib2Pds pds = gr.getPDS();
            counters.count("template", Integer.valueOf(pds.getTemplateNumber()));
            int timeUnit = pds.getTimeUnit();
            counters.count("timeUnit", Integer.valueOf(timeUnit));
            if (pds instanceof Grib2Pds.PdsInterval) {
                Grib2Pds.PdsInterval pdsi = (Grib2Pds.PdsInterval)((Object)pds);
                for (Grib2Pds.TimeInterval ti : pdsi.getTimeIntervals()) {
                    counters.count("statType", Integer.valueOf(ti.statProcessType));
                    if (ti.timeRangeUnit == timeUnit && (ti.timeIncrementUnit == timeUnit || ti.timeIncrementUnit == 255 || ti.timeIncrement == 0)) continue;
                    counters.count("TimeIntervalsDiffer", Integer.valueOf(ti.timeRangeUnit));
                    if (!showTinvDiffers) continue;
                    f.format("  TimeInterval has different units timeUnit= %s file=%s%n  ", timeUnit, mf.getName());
                    pds.show(f);
                    f.format("%n", new Object[0]);
                }
                counters.count("NumberTimeIntervals", Integer.valueOf(pdsi.getTimeIntervals().length));
                if (showNint && !shutup && pdsi.getTimeIntervals().length > 1) {
                    f.format("  TimeIntervals > 1 = %s file=%s%n  ", this.getId(gr), mf.getName());
                    shutup = true;
                }
                if (cust == null) {
                    cust = Grib2Tables.factory(gr);
                }
                double len = cust.getForecastTimeIntervalSizeInHours(pds);
                counters.count("TimeIntervalsLength", Integer.valueOf((int)len));
                int[] intv = cust.getForecastTimeIntervalOffset(gr);
                if (intv != null && intv[0] == 0 && intv[1] == 0) {
                    f.format("  TimeInterval [0,0] = %s file=%s%n  ", this.getId(gr), mf.getName());
                }
            }
            ++count;
        }
        return count;
    }

    String getId(Grib2Record gr) {
        Grib2SectionIndicator is = gr.getIs();
        Grib2Pds pds = gr.getPDS();
        return is.getDiscipline() + "-" + pds.getParameterCategory() + "-" + pds.getParameterNumber();
    }

    /*
     * WARNING - void declaration
     */
    private void doRename(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("CHECK Grib-2 Names: Old vs New for collection %s%n", dcm.getCollectionName());
        ArrayList<VarName> varNames = new ArrayList<VarName>(3000);
        HashMap<String, List> gridsAll = new HashMap<String, List>(1000);
        int countExactMatch = 0;
        int countExactMatchIg = 0;
        int countOldVars = 0;
        for (MFile mfile : dcm.getFilesSorted()) {
            Object gm2;
            GridMatch match;
            f.format("%n%s%n", mfile.getPath());
            Map<Integer, GridMatch> gridsNew = this.getGridsNew(mfile, f);
            Map<Integer, GridMatch> gridsOld = this.getGridsOld(mfile, f);
            HashSet<String> namesNew = new HashSet<String>(gridsNew.size());
            for (GridMatch gridMatch : gridsNew.values()) {
                namesNew.add(gridMatch.grid.getFullName());
            }
            for (GridMatch gridMatch : gridsOld.values()) {
                if (namesNew.contains(gridMatch.grid.getFullName())) {
                    ++countExactMatch;
                }
                ++countOldVars;
            }
            for (GridMatch gridMatch : gridsNew.values()) {
                match = (GridMatch)gridsOld.get(gridMatch.hashCode());
                if (match == null) continue;
                gridMatch.match = match;
                match.match = gridMatch;
            }
            for (GridMatch gridMatch : gridsNew.values()) {
                if (gridMatch.match != null || (match = this.altMatch(gridMatch, gridsOld.values())) == null) continue;
                gridMatch.match = match;
                match.match = gridMatch;
            }
            f.format("%n", new Object[0]);
            ArrayList<GridMatch> listNew = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(listNew);
            for (Object gm2 : listNew) {
                f.format(" %s%n", ((GridMatch)gm2).grid.findAttributeIgnoreCase("Grib_Variable_Id"));
                f.format(" %s (%d)%n", ((GridMatch)gm2).grid.getFullName(), ((GridMatch)gm2).hashCode());
                if (((GridMatch)gm2).match != null) {
                    boolean exactIg;
                    boolean exact = ((GridMatch)gm2).match.grid.getFullName().equals(((GridMatch)gm2).grid.getFullName());
                    boolean bl = exactIg = !exact && ((GridMatch)gm2).match.grid.getFullName().equalsIgnoreCase(((GridMatch)gm2).grid.getFullName());
                    if (exactIg) {
                        ++countExactMatchIg;
                    }
                    String status = exact ? " " : (exactIg ? "**" : " *");
                    f.format("%s%s (%d)%n", status, ((GridMatch)gm2).match.grid.getFullName(), ((GridMatch)gm2).match.hashCode());
                }
                f.format("%n", new Object[0]);
            }
            f.format("%nMISSING MATCHES IN NEW%n", new Object[0]);
            ArrayList<GridMatch> arrayList = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(arrayList);
            gm2 = arrayList.iterator();
            while (gm2.hasNext()) {
                GridMatch gm3 = (GridMatch)gm2.next();
                if (gm3.match != null) continue;
                f.format(" %s (%s) == %s%n", gm3.grid.getFullName(), gm3.show(), gm3.grid.getDescription());
            }
            f.format("%nMISSING MATCHES IN OLD%n", new Object[0]);
            ArrayList listOld = new ArrayList(gridsOld.values());
            Collections.sort(listOld);
            for (GridMatch gm4 : listOld) {
                if (gm4.match != null) continue;
                f.format(" %s (%s)%n", gm4.grid.getFullName(), gm4.show());
            }
            for (GridMatch gmOld : listOld) {
                String keyNew;
                String key = gmOld.grid.getShortName();
                List newGrids = gridsAll.computeIfAbsent(key, k -> new ArrayList());
                if (gmOld.match == null || newGrids.contains(keyNew = gmOld.match.grid.getShortName())) continue;
                newGrids.add(keyNew);
            }
            for (GridMatch gmOld : listOld) {
                if (gmOld.match == null) {
                    f.format("MISSING %s (%s)%n", gmOld.grid.getFullName(), gmOld.show());
                    continue;
                }
                Attribute att = gmOld.match.grid.findAttributeIgnoreCase("Grib_Variable_Id");
                String varId = att == null ? "" : att.getStringValue();
                varNames.add(new VarName(mfile.getName(), gmOld.grid.getShortName(), gmOld.match.grid.getShortName(), varId));
            }
        }
        f.format("%nOLD -> NEW MAPPINGS%n", new Object[0]);
        ArrayList keys = new ArrayList(gridsAll.keySet());
        int total = keys.size();
        int dups = 0;
        Collections.sort(keys);
        for (String key : keys) {
            f.format(" OLD %s%n", key);
            List newGrids = (List)gridsAll.get(key);
            Collections.sort(newGrids);
            if (newGrids.size() > 1) {
                ++dups;
            }
            for (Object newKey : newGrids) {
                f.format(" NEW %s%n", newKey);
            }
            f.format("%n", new Object[0]);
        }
        f.format("Exact matches=%d  Exact ignore case=%d  totalOldVars=%d%n", countExactMatch, countExactMatchIg, countOldVars);
        f.format("Number with more than one map=%d total=%d%n", dups, total);
        if (!useIndex) {
            Element rootElem = new Element("gribVarMap");
            Document doc = new Document(rootElem);
            rootElem.setAttribute("collection", dcm.getCollectionName());
            String currentDs = null;
            Object var15_29 = null;
            for (VarName vn : varNames) {
                void var15_30;
                if (!vn.dataset.equals(currentDs)) {
                    Element element = new Element("dataset");
                    rootElem.addContent(element);
                    element.setAttribute("name", vn.dataset);
                    currentDs = vn.dataset;
                }
                Element param = new Element("param");
                var15_30.addContent(param);
                param.setAttribute("oldName", vn.oldVar);
                param.setAttribute("newName", vn.newVar);
                param.setAttribute("varId", vn.varId);
            }
            FileOutputStream fout = new FileOutputStream("C:/tmp/grib2VarMap.xml");
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            fmt.output(doc, (OutputStream)fout);
            fout.close();
        }
    }

    private GridMatch altMatch(GridMatch want, Collection<GridMatch> test) {
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatch(want)) continue;
            return gm;
        }
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatchNoProb(want)) continue;
            return gm;
        }
        return null;
    }

    private Map<Integer, GridMatch> getGridsNew(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        try (GridDataset ncfile = GridDataset.open(ff.getPath());){
            for (GridDatatype dt : ncfile.getGrids()) {
                GridMatch gm = new GridMatch(dt, true);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP NEW (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        return grids;
    }

    private Map<Integer, GridMatch> getGridsOld(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        try (NetcdfFile ncfile = NetcdfFile.open(ff.getPath(), "ucar.nc2.iosp.grib.GribServiceProvider", -1, null, null);){
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            GridDataset grid = new GridDataset(ncd);
            for (GridDatatype dt : grid.getGrids()) {
                GridMatch gm = new GridMatch(dt, false);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP OLD (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return grids;
    }

    private static class GridMatch
    implements Comparable<GridMatch> {
        GridDatatype grid;
        GridMatch match;
        boolean isNew;
        int[] param = new int[3];
        int level;
        boolean isLayer;
        boolean isError;
        int interval = -1;
        int prob = -1;
        int ens = -1;
        int probLimit = Integer.MAX_VALUE;

        private GridMatch(GridDatatype grid, boolean aNew) {
            this.grid = grid;
            this.isNew = aNew;
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis1D zaxis = gcs.getVerticalAxis();
            if (zaxis != null) {
                this.isLayer = zaxis.isInterval();
            }
            if (this.isNew) {
                int intv;
                Attribute att = grid.findAttributeIgnoreCase("Grib2_Parameter");
                for (int i = 0; i < 3; ++i) {
                    this.param[i] = att.getNumericValue(i).intValue();
                }
                att = grid.findAttributeIgnoreCase("Grib2_Level_Type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                att = grid.findAttributeIgnoreCase("Grib2_Statistical_Interval_Type");
                if (att != null && (intv = att.getNumericValue().intValue()) != 255) {
                    this.interval = intv;
                }
                if ((att = grid.findAttributeIgnoreCase("Grib2_Probability_Type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if ((att = grid.findAttributeIgnoreCase("Grib2_Probability_Name")) != null) {
                    String pname = att.getStringValue();
                    int pos = pname.indexOf(95);
                    pname = pname.substring(pos + 1);
                    this.probLimit = (int)(1000.0 * Double.parseDouble(pname));
                }
                if ((att = grid.findAttributeIgnoreCase("Grib2_Ensemble_Derived_Type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            } else {
                Attribute att = grid.findAttributeIgnoreCase("GRIB_param_id");
                for (int i = 0; i < 3; ++i) {
                    this.param[i] = att.getNumericValue(i + 1).intValue();
                }
                att = grid.findAttributeIgnoreCase("GRIB_level_type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                att = grid.findAttributeIgnoreCase("GRIB_interval_stat_type");
                if (att != null) {
                    String intName = att.getStringValue();
                    this.interval = GribStatType.getStatTypeNumber(intName);
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_probability_type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if (this.prob == 0) {
                    att = grid.findAttributeIgnoreCase("GRIB_probability_lower_limit");
                    if (att != null) {
                        this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                    }
                } else if (this.prob == 1 && (att = grid.findAttributeIgnoreCase("GRIB_probability_upper_limit")) != null) {
                    this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_ensemble_derived_type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            if (this.prob != gridMatch.prob) {
                return false;
            }
            if (this.probLimit != gridMatch.probLimit) {
                return false;
            }
            return Arrays.equals(this.param, gridMatch.param);
        }

        public boolean altMatch(GridMatch gridMatch) {
            if (!this.altMatchNoProb(gridMatch)) {
                return false;
            }
            if (this.probLimit / 1000 == gridMatch.probLimit) {
                return true;
            }
            return this.probLimit == gridMatch.probLimit / 1000;
        }

        public boolean altMatchNoProb(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (!Arrays.equals(this.param, gridMatch.param)) {
                return false;
            }
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            return this.prob == gridMatch.prob;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.level;
            result = 31 * result + this.param[0];
            result = 31 * result + (this.isLayer ? 1 : 0);
            result = 31 * result + this.param[1];
            result = 31 * result + (this.isError ? 1 : 0);
            if (this.interval >= 0) {
                result = 31 * result + this.interval;
            }
            if (this.prob >= 0) {
                result = 31 * result + this.prob;
            }
            result = 31 * result + this.param[2];
            if (this.ens >= 0) {
                result = 31 * result + this.ens;
            }
            if (this.probLimit != Integer.MAX_VALUE) {
                result = 31 * result + this.probLimit;
            }
            return result;
        }

        @Override
        public int compareTo(GridMatch o) {
            return this.grid.compareTo(o.grid);
        }

        String show() {
            Formatter f = new Formatter();
            for (int i = 0; i < 3; ++i) {
                f.format("%d-", this.param[i]);
            }
            f.format("%d", this.level);
            if (this.isLayer) {
                f.format("_layer", new Object[0]);
            }
            if (this.interval >= 0) {
                f.format("_intv%d", this.interval);
            }
            if (this.prob >= 0) {
                f.format("_prob%d_%d", this.prob, this.probLimit);
            }
            if (this.ens >= 0) {
                f.format("_ens%d", this.ens);
            }
            if (this.isError) {
                f.format("_error", new Object[0]);
            }
            return f.toString();
        }
    }

    private static class VarName {
        String dataset;
        String oldVar;
        String newVar;
        String varId;

        private VarName(String dataset, String oldVar, String newVar, String varId) {
            this.dataset = dataset;
            this.oldVar = oldVar;
            this.newVar = newVar;
            this.varId = varId;
        }
    }

    private class FileCount {
        MFile f;
        int countRecords = 0;

        private FileCount(MFile f) {
            this.f = f;
        }
    }

    private class FileList
    implements Comparable<FileList> {
        String name;
        int template;
        List<FileCount> fileList = new ArrayList<FileCount>();

        private FileList(int template, String name) {
            this.name = name;
            this.template = template;
        }

        void findAndAdd(MFile f) {
            FileCount which = null;
            for (FileCount fc : this.fileList) {
                if (!fc.f.getPath().equals(f.getPath())) continue;
                which = fc;
            }
            if (which == null) {
                which = new FileCount(f);
                this.fileList.add(which);
            }
            ++which.countRecords;
        }

        @Override
        public int compareTo(FileList o) {
            return this.template - o.template;
        }
    }

    public static enum Report {
        checkTables,
        localUseSection,
        uniqueTemplates,
        duplicatePds,
        drsSummary,
        gdsSummary,
        pdsSummary,
        pdsProblems,
        idProblems,
        timeCoord,
        rename,
        copyCompress,
        gribIndex;

    }
}

