/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import thredds.client.catalog.tools.DataFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.iosp.hdf4.H4header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ui.ToolsUI;
import ucar.ui.widget.BAMutil;

public class ModesMenu
extends JMenu {
    private ToolsUI toolsui;

    public ModesMenu(ToolsUI tui) {
        super("Modes");
        this.setMnemonic('M');
        this.toolsui = tui;
        this.addNetcdfFileSubmenu();
        this.addNetcdfDatasetSubmenu();
        this.addHdfeosSubmenu();
        this.addGribSubmenu();
        this.addFmrcSubmenu();
    }

    private void addNetcdfFileSubmenu() {
        JMenu ncMenu = new JMenu("NetcdfFile");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                ModesMenu.this.toolsui.setUseRecordStructure(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "nc3UseRecords", false, 86, -1);
        BAMutil.addActionToMenu(ncMenu, a);
        this.add(ncMenu);
    }

    private void addNetcdfDatasetSubmenu() {
        JMenu dsMenu = new JMenu("NetcdfDataset");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                CoordSysBuilder.setUseMaximalCoordSys(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "Set Use Maximal CoordSystem", CoordSysBuilder.getUseMaximalCoordSys(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setFillValueIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "Use _FillValue attribute for missing values", NetcdfDataset.getFillValueIsMissing(), 70, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setInvalidDataIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "Use valid_range attribute for missing values", NetcdfDataset.getInvalidDataIsMissing(), 86, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setMissingDataIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "Use missing_value attribute for missing values", NetcdfDataset.getMissingDataIsMissing(), 77, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        this.add(dsMenu);
    }

    private void addHdfeosSubmenu() {
        JMenu subMenu = new JMenu("HDF-EOS");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                H5iosp.useHdfEos(state);
            }
        };
        a.putValue("state", true);
        BAMutil.setActionProperties(a, null, "Use HDF-EOS StructMetadata to augment HDF5", true, 53, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                H4header.useHdfEos(state);
            }
        };
        a.putValue("state", true);
        BAMutil.setActionProperties(a, null, "Use HDF-EOS StructMetadata to augment HDF4", true, 52, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                Nc4Iosp.useHdfEos(state);
            }
        };
        a.putValue("state", true);
        BAMutil.setActionProperties(a, null, "Use HDF-EOS StructMetadata to augment netcdf4 (JNI)", true, 78, -1);
        BAMutil.addActionToMenu(subMenu, a);
        this.add(subMenu);
    }

    private void addGribSubmenu() {
        JMenu subMenu = new JMenu("GRIB");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModesMenu.this.toolsui.setGribDiskCache();
            }
        };
        BAMutil.setActionProperties(a, null, "Set Grib disk cache\u2026", false, 71, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                Grib1ParamTables.setStrict(state);
            }
        };
        boolean strictMode = Grib1ParamTables.isStrict();
        a.putValue("state", strictMode);
        BAMutil.setActionPropertiesToggle(a, null, "GRIB1 strict", strictMode, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                GribData.setInterpolationMethod(state ? GribData.InterpolationMethod.cubic : GribData.InterpolationMethod.linear);
            }
        };
        boolean useCubic = GribData.getInterpolationMethod() == GribData.InterpolationMethod.cubic;
        a.putValue("state", useCubic);
        BAMutil.setActionPropertiesToggle(a, null, "Use Cubic Interpolation on Thin Grids", useCubic, 73, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useGenTypeDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useGenTypeDef);
        BAMutil.setActionPropertiesToggle(a, null, "useGenType", FeatureCollectionConfig.useGenTypeDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useTableVersionDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useTableVersionDef);
        BAMutil.setActionPropertiesToggle(a, null, "useTableVersion", FeatureCollectionConfig.useTableVersionDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.intvMergeDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.intvMergeDef);
        BAMutil.setActionPropertiesToggle(a, null, "intvMerge", FeatureCollectionConfig.intvMergeDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useCenterDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useCenterDef);
        BAMutil.setActionPropertiesToggle(a, null, "useCenter", FeatureCollectionConfig.useCenterDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        this.add(subMenu);
    }

    private void addFmrcSubmenu() {
        JMenu subMenu = new JMenu("FMRC");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                FeatureCollectionConfig.setRegularizeDefault(state);
            }
        };
        FeatureCollectionConfig.setRegularizeDefault(true);
        a.putValue("state", true);
        BAMutil.setActionPropertiesToggle(a, null, "regularize", true, 82, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                DataFactory.setPreferCdm(state);
            }
        };
        DataFactory.setPreferCdm(true);
        a.putValue("state", true);
        BAMutil.setActionPropertiesToggle(a, null, "preferCdm", true, 80, -1);
        BAMutil.addActionToMenu(subMenu, a);
        this.add(subMenu);
    }
}

