/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.grib.GribRewritePanel;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class GribRewriteOpPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private GribRewritePanel ftTable;
    private final FileManager dirChooser;

    public GribRewriteOpPanel(PreferencesExt prefs) {
        super(prefs, "dir:", false, false);
        this.dirChooser = new FileManager(ToolsUI.getToolsFrame(), null, null, (PreferencesExt)prefs.node("FeatureScanFileManager"));
        this.ftTable = new GribRewritePanel(prefs, this.buttPanel);
        this.add((Component)this.ftTable, "Center");
        this.ftTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!(e.getNewValue() instanceof String)) {
                    return;
                }
                String pname = e.getPropertyName();
                String datasetName = (String)e.getNewValue();
                if ("openNetcdfFile".equals(pname)) {
                    ToolsUI.getToolsUI().openNetcdfFile(datasetName);
                } else if ("openGridDataset".equals(pname)) {
                    ToolsUI.getToolsUI().openGridDataset(datasetName);
                } else if ("openGrib1Data".equals(pname)) {
                    ToolsUI.getToolsUI().openGrib1Data(datasetName);
                } else if ("openGrib2Data".equals(pname)) {
                    ToolsUI.getToolsUI().openGrib2Data(datasetName);
                } else {
                    logger.debug("Unknown popertry name {}", (Object)pname);
                }
            }
        });
        this.dirChooser.getFileChooser().setFileSelectionMode(2);
        this.dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
        AbstractAction fileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = GribRewriteOpPanel.this.dirChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                GribRewriteOpPanel.this.cb.setSelectedItem(filename);
            }
        };
        BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
        BAMutil.addActionToContainer(this.buttPanel, fileAction);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        return this.ftTable.setScanDirectory(command);
    }

    @Override
    public void closeOpenFiles() {
        this.ftTable.clear();
    }

    @Override
    public void save() {
        this.dirChooser.save();
        this.ftTable.save();
        this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
        super.save();
    }
}

