/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.simplegeom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.CFGridWriter2;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.util.prefs.PreferencesExt;

public class SimpleGeomTable
extends JPanel {
    private PreferencesExt prefs;
    private ucar.nc2.dt.GridDataset gridDataset;
    private BeanTable varTable;
    private BeanTable csTable = null;
    private BeanTable axisTable = null;
    private BeanTable simpleGeomTable = null;
    private JSplitPane split = null;
    private JSplitPane split2 = null;
    private JSplitPane split3 = null;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private NetcdfOutputChooser outChooser;

    public SimpleGeomTable(PreferencesExt prefs, boolean showCS) {
        this.prefs = prefs;
        this.varTable = new BeanTable<GeoGridBean>(GeoGridBean.class, (PreferencesExt)prefs.node("GeogridBeans"), false);
        JTable jtable = this.varTable.getJTable();
        PopupMenu csPopup = new PopupMenu(jtable, "Options");
        csPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeoGridBean vb = (GeoGridBean)SimpleGeomTable.this.varTable.getSelectedBean();
                VariableDS v = vb.geogrid.getVariable();
                SimpleGeomTable.this.infoTA.clear();
                if (v == null) {
                    SimpleGeomTable.this.infoTA.appendLine("Cant find variable " + vb.getName() + " escaped= (" + NetcdfFile.makeValidPathName(vb.getName()) + ")");
                } else {
                    SimpleGeomTable.this.infoTA.appendLine("Variable " + v.getFullName() + " :");
                    SimpleGeomTable.this.infoTA.appendLine(v.toString());
                }
                SimpleGeomTable.this.infoTA.gotoTop();
                SimpleGeomTable.this.infoWindow.show();
            }
        });
        csPopup.addAction("Show Coordinates", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeoGridBean vb = (GeoGridBean)SimpleGeomTable.this.varTable.getSelectedBean();
                Formatter f = new Formatter();
                SimpleGeomTable.this.showCoordinates(vb, f);
                SimpleGeomTable.this.infoTA.setText(f.toString());
                SimpleGeomTable.this.infoTA.gotoTop();
                SimpleGeomTable.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("nj22/NetcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        JComponent comp = this.varTable;
        if (showCS) {
            this.csTable = new BeanTable<GeoCoordinateSystemBean>(GeoCoordinateSystemBean.class, (PreferencesExt)prefs.node("GeoCoordinateSystemBean"), false);
            this.axisTable = new BeanTable<GeoAxisBean>(GeoAxisBean.class, (PreferencesExt)prefs.node("GeoCoordinateAxisBean"), false);
            this.simpleGeomTable = new BeanTable<SimpleGeomBean>(SimpleGeomBean.class, (PreferencesExt)prefs.node("SimpleGeomBean"), false);
            this.split = new JSplitPane(0, false, this.varTable, this.csTable);
            this.split.setDividerLocation(prefs.getInt("splitPos", 500));
            this.split2 = new JSplitPane(0, false, this.split, this.axisTable);
            this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
            this.split3 = new JSplitPane(0, false, this.split2, this.simpleGeomTable);
            this.split3.setDividerLocation(prefs.getInt("splitPos3", 500));
            comp = this.split3;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)comp, "Center");
    }

    public void addExtra(JPanel buttPanel, FileManager fileChooser) {
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
        infoButton.addActionListener(e -> {
            if (this.gridDataset != null && this.gridDataset instanceof GridDataset) {
                GridDataset gdsImpl = (GridDataset)this.gridDataset;
                this.infoTA.clear();
                this.infoTA.appendLine(gdsImpl.getDetailInfo());
                this.infoTA.gotoTop();
                this.infoWindow.show();
            }
        });
        buttPanel.add(infoButton);
        JButton invButton = new JButton("GridInv");
        invButton.addActionListener(e -> {
            if (this.gridDataset == null) {
                return;
            }
            GridDatasetInv inv = new GridDatasetInv((GridDataset)this.gridDataset, null);
            try {
                this.infoTA.setText(inv.writeXML(new Date()));
                this.infoTA.gotoTop();
                this.infoWindow.show();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        buttPanel.add(invButton);
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleGeomTable.this.gridDataset == null) {
                    return;
                }
                List<String> gridList = SimpleGeomTable.this.getSelectedGrids();
                if (gridList.size() == 0) {
                    JOptionPane.showMessageDialog(SimpleGeomTable.this, "No Simple Geometries are selected");
                    return;
                }
                if (SimpleGeomTable.this.outChooser == null) {
                    SimpleGeomTable.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    SimpleGeomTable.this.outChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            SimpleGeomTable.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue());
                        }
                    });
                }
                SimpleGeomTable.this.outChooser.setOutputFilename(SimpleGeomTable.this.gridDataset.getLocation());
                SimpleGeomTable.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties(netcdfAction, "nj22/Netcdf", "Write netCDF-CF file", false, 83, -1);
        BAMutil.addActionToContainer(buttPanel, netcdfAction);
    }

    private void showCoordinates(GeoGridBean vb, Formatter f) {
        GridCoordSystem gcs = vb.geogrid.getCoordinateSystem();
        gcs.show(f, true);
    }

    private void writeNetcdf(NetcdfOutputChooser.Data data) {
        if (data.version == NetcdfFileWriter.Version.ncstream) {
            return;
        }
        try {
            NetcdfFileWriter writer = NetcdfFileWriter.createNew(data.version, data.outputFilename, null);
            CFGridWriter2.writeFile(this.gridDataset, this.getSelectedGrids(), null, null, 1, null, null, 1, false, writer);
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.csTable != null) {
            this.csTable.saveState(false);
        }
        if (this.axisTable != null) {
            this.axisTable.saveState(false);
        }
    }

    public void clear() {
        this.gridDataset = null;
        this.varTable.clearBeans();
        this.csTable.clearBeans();
        this.axisTable.clearBeans();
    }

    public void setDataset(NetcdfDataset ds, Formatter parseInfo) throws IOException {
        this.gridDataset = new GridDataset(ds, parseInfo);
        ArrayList<GeoGridBean> beanList = new ArrayList<GeoGridBean>();
        List<GridDatatype> list = this.gridDataset.getGrids();
        for (GridDatatype g2 : list) {
            beanList.add(new GeoGridBean(g2));
        }
        this.varTable.setBeans(beanList);
        ArrayList<SimpleGeomBean> sgList = new ArrayList<SimpleGeomBean>();
        List<GridDatatype> list2 = this.gridDataset.getGrids();
        for (GridDatatype g3 : list2) {
            sgList.add(new SimpleGeomBean(g3));
        }
        this.varTable.setBeans(sgList);
        if (this.csTable != null) {
            ArrayList<GeoCoordinateSystemBean> csList = new ArrayList<GeoCoordinateSystemBean>();
            ArrayList<GeoAxisBean> axisList = new ArrayList<GeoAxisBean>();
            for (GridDataset.Gridset gset : this.gridDataset.getGridsets()) {
                csList.add(new GeoCoordinateSystemBean(gset));
                GridCoordSystem gsys = gset.getGeoCoordSystem();
                List<CoordinateAxis> axes = gsys.getCoordinateAxes();
                for (CoordinateAxis axis : axes) {
                    GeoAxisBean axisBean = new GeoAxisBean(axis);
                    if (this.contains(axisList, axisBean.getName())) continue;
                    axisList.add(axisBean);
                }
            }
            this.csTable.setBeans(csList);
            this.axisTable.setBeans(axisList);
        }
    }

    public void setDataset(ucar.nc2.dt.GridDataset gds) throws IOException {
        this.gridDataset = gds;
        ArrayList<GeoGridBean> beanList = new ArrayList<GeoGridBean>();
        List<GridDatatype> list = this.gridDataset.getGrids();
        for (GridDatatype g2 : list) {
            beanList.add(new GeoGridBean(g2));
        }
        this.varTable.setBeans(beanList);
        if (this.csTable != null) {
            ArrayList<GeoCoordinateSystemBean> csList = new ArrayList<GeoCoordinateSystemBean>();
            ArrayList<GeoAxisBean> axisList = new ArrayList<GeoAxisBean>();
            for (GridDataset.Gridset gset : this.gridDataset.getGridsets()) {
                csList.add(new GeoCoordinateSystemBean(gset));
                GridCoordSystem gsys = gset.getGeoCoordSystem();
                List<CoordinateAxis> axes = gsys.getCoordinateAxes();
                for (CoordinateAxis axis : axes) {
                    GeoAxisBean axisBean = new GeoAxisBean(axis);
                    if (this.contains(axisList, axisBean.getName())) continue;
                    axisList.add(axisBean);
                }
            }
            this.csTable.setBeans(csList);
            this.axisTable.setBeans(axisList);
        }
    }

    private boolean contains(List<GeoAxisBean> axisList, String name) {
        for (GeoAxisBean axis : axisList) {
            if (!axis.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ucar.nc2.dt.GridDataset getGridDataset() {
        return this.gridDataset;
    }

    public List<String> getSelectedGrids() {
        List grids = this.varTable.getSelectedBeans();
        ArrayList<String> result = new ArrayList<String>();
        for (Object bean : grids) {
            GeoGridBean gbean = (GeoGridBean)bean;
            result.add(gbean.getName());
        }
        return result;
    }

    public GridDatatype getGrid() {
        GeoGridBean vb = (GeoGridBean)this.varTable.getSelectedBean();
        if (vb == null) {
            List<GridDatatype> grids = this.gridDataset.getGrids();
            if (grids.size() > 0) {
                return grids.get(0);
            }
            return null;
        }
        return this.gridDataset.findGridDatatype(vb.getName());
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)SimpleGeomTable.this, "Center");
            this.pack();
        }
    }

    public class SimpleGeomBean {
        GridDatatype v;
        String line;
        String polygon;
        String geoX;
        String geoY;

        public SimpleGeomBean() {
        }

        public String getName() {
            return "";
        }

        public SimpleGeomBean(GridDatatype v) {
            this.v = v;
            this.setLine("");
            this.setPolygon("");
            this.setGeoX("");
            this.setGeoY("");
        }

        public String getLine() {
            return this.line;
        }

        public void setLine(String line) {
            this.line = line;
        }

        public String getPolygon() {
            return this.polygon;
        }

        public void setPolygon(String polygon) {
            this.polygon = polygon;
        }

        public String getGeoX() {
            return this.geoX;
        }

        public void setGeoX(String geoX) {
            this.geoX = geoX;
        }

        public String getGeoY() {
            return this.geoY;
        }

        public void setGeoY(String geoY) {
            this.geoY = geoY;
        }
    }

    public class GeoAxisBean {
        CoordinateAxis axis;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String incr = "";
        String dims;
        String shape;
        String csNames;
        boolean isCoordVar;

        public GeoAxisBean() {
        }

        public GeoAxisBean(CoordinateAxis v) {
            CoordinateAxis1D v1;
            String p;
            this.axis = v;
            this.setName(v.getFullName());
            this.setCoordVar(v.isCoordinateVariable());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List<Dimension> dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            AxisType at = v.getAxisType();
            if (at != null) {
                this.setAxisType(at.toString());
            }
            if ((p = v.getPositive()) != null) {
                this.setPositive(p);
            }
            if (v instanceof CoordinateAxis1D && (v1 = (CoordinateAxis1D)v).isRegular()) {
                this.setRegular(Double.toString(v1.getIncrement()));
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCoordVar() {
            return this.isCoordVar;
        }

        public void setCoordVar(boolean isCoordVar) {
            this.isCoordVar = isCoordVar;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public String getRegular() {
            return this.incr;
        }

        public void setRegular(String incr) {
            this.incr = incr;
        }
    }

    public class GeoCoordinateSystemBean {
        private GridCoordSystem gcs;
        private String proj;
        private String coordTrans;
        private int ngrids = -1;

        public GeoCoordinateSystemBean() {
        }

        public GeoCoordinateSystemBean(GridDataset.Gridset gset) {
            this.gcs = gset.getGeoCoordSystem();
            this.setNGrids(gset.getGrids().size());
            ProjectionImpl proj = this.gcs.getProjection();
            if (proj != null) {
                this.setProjection(proj.getClassName());
            }
            int count = 0;
            StringBuilder buff = new StringBuilder();
            List<CoordinateTransform> ctList = this.gcs.getCoordinateTransforms();
            Iterator<CoordinateTransform> iterator = ctList.iterator();
            while (iterator.hasNext()) {
                ProjectionCT pct;
                CoordinateTransform o;
                CoordinateTransform ct = o = iterator.next();
                if (count > 0) {
                    buff.append("; ");
                }
                if (ct instanceof VerticalCT) {
                    buff.append((Object)((VerticalCT)ct).getVerticalTransformType());
                    ++count;
                }
                if (!(ct instanceof ProjectionCT) || (pct = (ProjectionCT)ct).getProjection() != null) continue;
                buff.append("-").append(pct.getName());
                ++count;
            }
            this.setCoordTransforms(buff.toString());
        }

        public String getName() {
            return this.gcs.getName();
        }

        public boolean isRegularSpatial() {
            return this.gcs.isRegularSpatial();
        }

        public boolean isLatLon() {
            return this.gcs.isLatLon();
        }

        public boolean isGeoXY() {
            return ((GridCoordSys)this.gcs).isGeoXY();
        }

        public int getDomainRank() {
            return this.gcs.getDomain().size();
        }

        public int getRangeRank() {
            return this.gcs.getCoordinateAxes().size();
        }

        public int getNGrids() {
            return this.ngrids;
        }

        public void setNGrids(int ngrids) {
            this.ngrids = ngrids;
        }

        public String getProjection() {
            return this.proj;
        }

        public void setProjection(String proj) {
            this.proj = proj;
        }

        public String getCoordTransforms() {
            return this.coordTrans;
        }

        public void setCoordTransforms(String coordTrans) {
            this.coordTrans = coordTrans;
        }
    }

    public class GeoGridBean {
        GridDatatype geogrid;
        String name;
        String desc;
        String units;
        String csys;
        String dims;
        String x;
        String y;
        String z;
        String t;
        String ens;
        String rt;

        public GeoGridBean() {
        }

        public GeoGridBean(GridDatatype geogrid) {
            this.geogrid = geogrid;
            this.setName(geogrid.getFullName());
            this.setDescription(geogrid.getDescription());
            this.setUnits(geogrid.getUnitsString());
            GridCoordSystem gcs = geogrid.getCoordinateSystem();
            this.setCoordSystem(gcs.getName());
            StringBuilder buff = new StringBuilder();
            List<Dimension> dims = geogrid.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    buff.append(",");
                }
                buff.append(dim.getLength());
            }
            this.setShape(buff.toString());
            this.x = this.getAxisName(gcs.getXHorizAxis());
            this.y = this.getAxisName(gcs.getYHorizAxis());
            this.z = this.getAxisName(gcs.getVerticalAxis());
            this.t = this.getAxisName(gcs.getTimeAxis());
            this.rt = this.getAxisName(gcs.getRunTimeAxis());
            this.ens = this.getAxisName(gcs.getEnsembleAxis());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getCoordSystem() {
            return this.csys;
        }

        public void setCoordSystem(String csys) {
            this.csys = csys;
        }

        public String getX() {
            return this.x;
        }

        public String getY() {
            return this.y;
        }

        public String getZ() {
            return this.z;
        }

        public String getT() {
            return this.t;
        }

        public String getEns() {
            return this.ens;
        }

        public String getRt() {
            return this.rt;
        }

        public String getShape() {
            return this.dims;
        }

        public void setShape(String dims) {
            this.dims = dims;
        }

        private String getAxisName(CoordinateAxis axis) {
            if (axis != null) {
                return axis.isCoordinateVariable() ? axis.getShortName() : axis.getNameAndDimensions(false);
            }
            return "";
        }
    }
}

