/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.prefs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.PrefPanel;

class FieldResizable
extends Field {
    private Field delegate;
    private JComponent parent;
    private JPanel comp;
    private ResizeButton resizeButt = null;
    private ResizeButton dragButt = null;
    private JComponent glassPane = null;
    private RubberbandRectangle rb;
    private boolean resizeMode = false;
    private int startx;
    private int starty;
    private boolean debug = false;

    public FieldResizable(Field d, JComponent p) {
        super(d.getName(), d.getLabel(), d.getPersistenceManager());
        this.delegate = d;
        this.parent = p;
        this.dragButt = new ResizeButton();
        this.dragButt.setColor(Color.blue);
        this.dragButt.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent de) {
                if (FieldResizable.this.resizeMode) {
                    Point pt = SwingUtilities.convertPoint(FieldResizable.this.dragButt, de.getPoint(), FieldResizable.this.glassPane);
                    pt.setLocation(pt.getX(), (double)FieldResizable.this.starty);
                    FieldResizable.this.dragButt.setLocation(pt);
                    FieldResizable.this.rb.stretch(pt);
                }
            }
        });
        this.dragButt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (FieldResizable.this.resizeMode) {
                    Point pt = SwingUtilities.convertPoint(FieldResizable.this.dragButt, e.getPoint(), FieldResizable.this.glassPane);
                    FieldResizable.this.rb.stop(pt);
                    FieldResizable.this.resizeButt.setColor(Color.black);
                    FieldResizable.this.glassPane.setVisible(false);
                    FieldResizable.this.glassPane.remove(FieldResizable.this.dragButt);
                    FieldResizable.this.resizeMode = false;
                    int newWidth = (int)((double)FieldResizable.this.comp.getWidth() + pt.getX() - (double)FieldResizable.this.startx);
                    if (FieldResizable.this.debug) {
                        System.out.println("***FieldResizable width= " + FieldResizable.this.comp.getWidth() + "  new width= " + newWidth);
                    }
                    Dimension d = FieldResizable.this.comp.getSize();
                    d.setSize(newWidth, (int)d.getHeight());
                    FieldResizable.this.comp.setPreferredSize(d);
                    FieldResizable.this.comp.revalidate();
                }
            }
        });
        this.resizeButt = new ResizeButton();
        this.resizeButt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (FieldResizable.this.glassPane == null) {
                    JRootPane root = SwingUtilities.getRootPane(FieldResizable.this.parent);
                    FieldResizable.this.glassPane = (JComponent)root.getGlassPane();
                    FieldResizable.this.glassPane.setLayout(null);
                    FieldResizable.this.rb = new RubberbandRectangle(FieldResizable.this.glassPane);
                }
                FieldResizable.this.resizeButt.setColor(Color.blue);
                Rectangle r = FieldResizable.this.resizeButt.getBounds();
                Point pt = SwingUtilities.convertPoint(FieldResizable.this.comp, (int)r.getX(), (int)r.getY(), FieldResizable.this.glassPane);
                r.setLocation(pt);
                FieldResizable.this.startx = (int)pt.getX();
                FieldResizable.this.starty = (int)pt.getY();
                FieldResizable.this.dragButt.setBounds(r);
                pt.setLocation(pt.getX(), (double)FieldResizable.this.starty + r.getHeight());
                FieldResizable.this.rb.start(pt);
                FieldResizable.this.glassPane.add(FieldResizable.this.dragButt);
                FieldResizable.this.glassPane.setVisible(true);
                FieldResizable.this.resizeMode = true;
            }
        });
        this.comp = new MyPanel();
        this.comp.setLayout(new BorderLayout());
        this.comp.add((Component)this.delegate.getEditComponent(), "Center");
        this.comp.add((Component)this.resizeButt, "East");
    }

    public Field getDelegate() {
        return this.delegate;
    }

    @Override
    public JComponent getEditComponent() {
        return this.comp;
    }

    @Override
    public Object getEditValue() {
        return this.delegate.getEditValue();
    }

    @Override
    public void setEditValue(Object value) {
        this.delegate.setEditValue(value);
    }

    @Override
    protected Object getStoreValue(Object defValue) {
        return this.delegate.getStoreValue(defValue);
    }

    @Override
    protected void setStoreValue(Object newValue) {
        this.delegate.setStoreValue(newValue);
    }

    @Override
    protected boolean accept(StringBuffer buff) {
        return this.delegate.accept(buff);
    }

    @Override
    protected boolean acceptIfDifferent(Object newValue) {
        return this.delegate.acceptIfDifferent(newValue);
    }

    @Override
    protected void restoreValue(Object defValue) {
        this.delegate.restoreValue(defValue);
    }

    @Override
    protected void sendEvent() {
        this.delegate.sendEvent();
    }

    @Override
    protected void setNewValueFromStore() {
        this.delegate.setNewValueFromStore();
    }

    @Override
    protected void next() {
        this.delegate.next();
    }

    @Override
    protected boolean validate(StringBuffer buff) {
        return this.delegate.validate(buff);
    }

    @Override
    protected boolean _validate(StringBuffer buff) {
        return this.delegate._validate(buff);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test prefs Field");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        PrefPanel.Dialog d = new PrefPanel.Dialog(frame, false, "title", null, null);
        PrefPanel pp = d.getPrefPanel();
        Field.Text tf = pp.addTextField("text", "text", "defValue");
        pp.setCursor(1, 0);
        pp.addTextField("text2", "text2", "text2");
        tf.setText("better value");
        d.finish();
        d.show();
        JPanel main = new JPanel(new FlowLayout());
        frame.getContentPane().add(main);
        main.setPreferredSize(new Dimension(200, 200));
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
        pp.addActionListener(e -> {
            String text = tf.getText();
            tf.setText(text + "1");
        });
    }

    private static class MyPanel
    extends JPanel {
        private MyPanel() {
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            super.setPreferredSize(preferredSize);
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }
    }

    private static class RubberbandRectangle {
        private boolean debugRB = false;
        private Point anchorPt = new Point(0, 0);
        private Point stretchedPt = new Point(0, 0);
        private Point lastPt = new Point(0, 0);
        private Point endPt = new Point(0, 0);
        private Component component;
        private boolean firstStretch = true;
        private boolean active = false;

        public RubberbandRectangle(Component c) {
            this.component = c;
            this.component.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent event) {
                    if (active) {
                        this.stretch(event.getPoint());
                    }
                }
            });
        }

        public void drawLast(Graphics graphics) {
            Rectangle rect = this.lastBounds();
            graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            if (this.debugRB) {
                System.out.println("RB drawLast " + rect);
            }
        }

        public void drawNext(Graphics graphics) {
            Rectangle rect = this.getBounds();
            graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            if (this.debugRB) {
                System.out.println("RB drawNext " + rect);
            }
        }

        public void setActive(boolean b) {
            this.active = b;
        }

        public boolean isActive() {
            return this.active;
        }

        public Point getAnchor() {
            return this.anchorPt;
        }

        public Point getStretched() {
            return this.stretchedPt;
        }

        public Point getLast() {
            return this.lastPt;
        }

        public Point getEnd() {
            return this.endPt;
        }

        public void start(Point p) {
            this.firstStretch = true;
            this.anchorPt.x = p.x;
            this.anchorPt.y = p.y;
            this.stretchedPt.x = this.lastPt.x = this.anchorPt.x;
            this.stretchedPt.y = this.lastPt.y = this.anchorPt.y;
        }

        public void stretch(Point p) {
            Graphics g2;
            this.lastPt.x = this.stretchedPt.x;
            this.lastPt.y = this.stretchedPt.y;
            this.stretchedPt.x = p.x;
            this.stretchedPt.y = p.y;
            if (this.debugRB) {
                System.out.println("RB stretch " + this.getBounds());
            }
            if ((g2 = this.component.getGraphics()) == null) {
                return;
            }
            try {
                g2.setXORMode(this.component.getBackground());
                g2.setColor(Color.blue);
                if (this.firstStretch) {
                    this.firstStretch = false;
                } else {
                    this.drawLast(g2);
                }
                this.drawNext(g2);
            }
            finally {
                g2.dispose();
            }
        }

        public void stop(Point p) {
            this.lastPt.x = this.endPt.x = p.x;
            this.lastPt.y = this.endPt.y = p.y;
            Graphics g2 = this.component.getGraphics();
            if (g2 != null) {
                try {
                    g2.setXORMode(this.component.getBackground());
                    g2.setColor(Color.blue);
                    this.drawLast(g2);
                }
                finally {
                    g2.dispose();
                }
            }
        }

        public Rectangle getBounds() {
            return new Rectangle(this.stretchedPt.x < this.anchorPt.x ? this.stretchedPt.x : this.anchorPt.x, this.stretchedPt.y < this.anchorPt.y ? this.stretchedPt.y : this.anchorPt.y, Math.abs(this.stretchedPt.x - this.anchorPt.x), Math.abs(this.stretchedPt.y - this.anchorPt.y));
        }

        public Rectangle lastBounds() {
            return new Rectangle(this.lastPt.x < this.anchorPt.x ? this.lastPt.x : this.anchorPt.x, this.lastPt.y < this.anchorPt.y ? this.lastPt.y : this.anchorPt.y, Math.abs(this.lastPt.x - this.anchorPt.x), Math.abs(this.lastPt.y - this.anchorPt.y));
        }
    }

    private static class ResizeIcon
    implements Icon {
        private int h = 10;
        private int w = 5;
        private Color color;

        ResizeIcon(Color c) {
            this.color = c;
        }

        void setColor(Color c) {
            this.color = c;
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            JComponent component = (JComponent)c;
            this.h = component.getHeight();
            g2.setColor(component.isEnabled() ? this.color : Color.gray);
            g2.translate(x, y);
            g2.drawLine(1, -4, 1, this.h);
            g2.drawLine(3, -4, 3, this.h);
            g2.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }
    }

    private static class ResizeButton
    extends JButton {
        ResizeIcon icon = new ResizeIcon(Color.black);

        ResizeButton() {
            this.setIcon(this.icon);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        void setColor(Color c) {
            this.icon.setColor(c);
        }
    }
}

