/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HidableTableColumnModel
extends DefaultTableColumnModel
implements TableModelListener {
    private TableModel model;
    protected Vector<TableColumn> allTableColumns = new Vector();

    public HidableTableColumnModel(TableModel model) {
        this.createColumnsFromModel(model);
    }

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (this.isColumnVisible(column) == visible) {
            return;
        }
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            for (TableColumn allTableColumn : this.allTableColumns) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = allTableColumn;
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn != visibleColumn) continue;
                ++visibleIndex;
            }
        }
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.indexOf(aColumn) >= 0;
    }

    @Override
    public void addColumn(TableColumn column) {
        this.allTableColumns.addElement(column);
        super.addColumn(column);
    }

    @Override
    public void removeColumn(TableColumn column) {
        int allColumnsIndex = this.allTableColumns.indexOf(column);
        if (allColumnsIndex != -1) {
            this.allTableColumns.removeElementAt(allColumnsIndex);
        }
        super.removeColumn(column);
    }

    @Override
    public void moveColumn(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        TableColumn fromColumn = (TableColumn)this.tableColumns.get(oldIndex);
        TableColumn toColumn = (TableColumn)this.tableColumns.get(newIndex);
        int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
        int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
        if (oldIndex != newIndex) {
            this.allTableColumns.removeElementAt(allColumnsOldIndex);
            this.allTableColumns.insertElementAt(fromColumn, allColumnsNewIndex);
        }
        super.moveColumn(oldIndex, newIndex);
    }

    public int getColumnCount(boolean onlyVisible) {
        Vector<TableColumn> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        return columns.size();
    }

    public Enumeration<TableColumn> getColumns(boolean onlyVisible) {
        Vector<TableColumn> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        return columns.elements();
    }

    public TableColumn getColumn(int columnIndex, boolean onlyVisible) {
        if (onlyVisible) {
            return (TableColumn)this.tableColumns.elementAt(columnIndex);
        }
        return this.allTableColumns.elementAt(columnIndex);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1) {
            assert (e.getSource() instanceof TableModel) : String.format("Why is %s firing a %s?", e.getSource(), e.getClass());
            this.createColumnsFromModel((TableModel)e.getSource());
        }
    }

    public void createColumnsFromModel(TableModel newModel) {
        if (newModel != this.model) {
            if (this.model != null) {
                this.model.removeTableModelListener(this);
            }
            newModel.addTableModelListener(this);
            this.model = newModel;
        }
        while (!this.allTableColumns.isEmpty()) {
            this.removeColumn(this.allTableColumns.elementAt(0));
        }
        for (int modelColumnIndex = 0; modelColumnIndex < newModel.getColumnCount(); ++modelColumnIndex) {
            TableColumn newColumn = new TableColumn(modelColumnIndex);
            String columnName = newModel.getColumnName(modelColumnIndex);
            newColumn.setHeaderValue(columnName);
            this.addColumn(newColumn);
        }
    }
}

