/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MyMouseAdapter
extends MouseAdapter
implements Serializable {
    private int startx;
    private int starty;
    private int minMove = 4;
    private boolean debugEvent = false;

    @Override
    public void mousePressed(MouseEvent e) {
        this.startx = e.getX();
        this.starty = e.getY();
        if (this.debugEvent) {
            System.out.println("mousePressed " + this.startx + " " + this.starty);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int deltax = e.getX() - this.startx;
        int deltay = e.getY() - this.starty;
        int total = Math.abs(deltax) + Math.abs(deltay);
        if (total <= this.minMove) {
            this.click(e);
        } else {
            this.drag(e, deltax, deltay);
        }
        if (this.debugEvent) {
            System.out.println("mouseReleased " + e.getX() + " " + e.getY());
            if (deltax > 0 || deltay > 0) {
                System.out.println("  MOVED " + deltax + " " + deltay);
            }
        }
    }

    public void setMinMove(int minMove) {
        this.minMove = minMove;
    }

    public void click(MouseEvent e) {
    }

    public void drag(MouseEvent e, int deltax, int deltay) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test MyMouseAdapter");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JLabel comp = new JLabel("test  sdfk sdf ks;dflk ;sdlkf ldsk lk");
        comp.setOpaque(true);
        comp.setBackground(Color.white);
        comp.setForeground(Color.black);
        comp.addMouseListener(new MyMouseAdapter());
        JPanel main = new JPanel(new FlowLayout());
        frame.getContentPane().add(main);
        main.setPreferredSize(new Dimension(200, 200));
        main.add(comp);
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }
}

