/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.codec.LZWCodec;

public class LegacyTiffTools {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int PHOTOMETRIC_INTERPRETATION_FIELD = 262;
    private static final int IMPOSSIBLE_IFD = 424242;

    public static Hashtable getIFDHash(RandomAccessFile readIn) throws IOException {
        byte[] byteArray = new byte[4];
        readIn.seek(4L);
        readIn.read(byteArray);
        readIn.seek(LegacyTiffTools.batoi(byteArray));
        byteArray = new byte[2];
        readIn.read(byteArray);
        Hashtable<Integer, Serializable> ifdEntries = new Hashtable<Integer, Serializable>();
        Integer numEntries = new Integer(LegacyTiffTools.batoi(byteArray));
        boolean frames = true;
        for (int i = 0; i < numEntries; ++i) {
            byteArray = new byte[2];
            readIn.read(byteArray);
            Integer entryTag = new Integer(LegacyTiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryType = new Integer(LegacyTiffTools.batoi(byteArray));
            byteArray = new byte[4];
            readIn.read(byteArray);
            Integer entrycount = new Integer(LegacyTiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryOffset = new Integer(LegacyTiffTools.batoi(byteArray));
            Vector<Integer> entryData = new Vector<Integer>();
            entryData.add(entryType);
            entryData.add(entrycount);
            entryData.add(entryOffset);
            ifdEntries.put(entryTag, entryData);
        }
        readIn.read(byteArray);
        int nextOffset = LegacyTiffTools.batoi(byteArray);
        ifdEntries.put(new Integer(424242), new Integer(nextOffset));
        return ifdEntries;
    }

    public static Hashtable getIFDHash(RandomAccessFile readIn, int block_id) throws IOException {
        Integer numEntries;
        Hashtable<Integer, Serializable> ifdEntries = new Hashtable<Integer, Serializable>();
        byte[] byteArray = new byte[4];
        readIn.seek(4L);
        readIn.read(byteArray);
        readIn.seek(LegacyTiffTools.batoi(byteArray));
        for (int frames = 0; frames != block_id; ++frames) {
            byteArray = new byte[2];
            readIn.read(byteArray);
            numEntries = new Integer(LegacyTiffTools.batoi(byteArray));
            readIn.skipBytes(12 * numEntries);
            byteArray = new byte[4];
            readIn.read(byteArray);
            readIn.seek(LegacyTiffTools.batoi(byteArray));
        }
        byteArray = new byte[2];
        readIn.read(byteArray);
        numEntries = new Integer(LegacyTiffTools.batoi(byteArray));
        for (int i = 0; i < numEntries; ++i) {
            byteArray = new byte[2];
            readIn.read(byteArray);
            Integer entryTag = new Integer(LegacyTiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryType = new Integer(LegacyTiffTools.batoi(byteArray));
            byteArray = new byte[4];
            readIn.read(byteArray);
            Integer entrycount = new Integer(LegacyTiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryOffset = new Integer(LegacyTiffTools.batoi(byteArray));
            Vector<Integer> entryData = new Vector<Integer>();
            entryData.add(entryType);
            entryData.add(entrycount);
            entryData.add(entryOffset);
            ifdEntries.put(entryTag, entryData);
        }
        readIn.read(byteArray);
        int nextOffset = LegacyTiffTools.batoi(byteArray);
        ifdEntries.put(new Integer(424242), new Integer(nextOffset));
        return ifdEntries;
    }

    public static int[] getIFDArray(RandomAccessFile readIn, Vector v) throws IOException {
        int count = (Integer)v.get(1);
        int type = (Integer)v.get(0);
        if (count == 1) {
            return new int[]{(Integer)v.get(2)};
        }
        readIn.seek(((Integer)v.get(2)).intValue());
        int[] toReturn = new int[count];
        int bytesPerEntry = 1;
        if (type == 1) {
            bytesPerEntry = 1;
        }
        if (type == 2) {
            bytesPerEntry = 1;
        }
        if (type == 3) {
            bytesPerEntry = 2;
        }
        if (type == 4) {
            bytesPerEntry = 4;
        }
        byte[] data = new byte[count * bytesPerEntry];
        readIn.read(data);
        byte[] translate = new byte[bytesPerEntry];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(data, i * bytesPerEntry, translate, 0, bytesPerEntry);
            toReturn[i] = LegacyTiffTools.batoi(translate);
        }
        return toReturn;
    }

    public static double[] getIFDRArray(RandomAccessFile readIn, Vector v) throws IOException {
        int count = (Integer)v.get(1);
        int type = (Integer)v.get(0);
        if (count == 1) {
            return new double[]{-1.0};
        }
        readIn.seek(((Integer)v.get(2)).intValue());
        double[] toReturn = new double[count];
        int bytesPerEntry = 8;
        if (type != 5) {
            return new double[]{-1.0};
        }
        byte[] data = new byte[count * bytesPerEntry];
        readIn.read(data);
        byte[] translate = new byte[bytesPerEntry];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(data, i * bytesPerEntry, translate, 0, 4);
            int num = LegacyTiffTools.batoi(translate);
            System.arraycopy(data, i * bytesPerEntry + 4, translate, 0, 4);
            int denom = LegacyTiffTools.batoi(translate);
            toReturn[i] = num / denom;
        }
        return toReturn;
    }

    public static byte[] lzwUncompress(byte[] input) throws IOException {
        try {
            return new LZWCodec().decompress(input);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static int getPhotometricInterpretation(RandomAccessFile in) throws IOException {
        Hashtable ifdHash = LegacyTiffTools.getIFDHash(in);
        Vector v = (Vector)ifdHash.get(new Integer(262));
        return (Integer)v.get(2);
    }

    public static int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        for (int i = 0; i < len; ++i) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << i * 8;
        }
        return total;
    }

    public static int[] getTIFFDimensions(RandomAccessFile readIn) throws IOException {
        int frames = 1;
        Hashtable ifdEntries = LegacyTiffTools.getIFDHash(readIn);
        int nextOffset = (Integer)ifdEntries.get(new Integer(424242));
        while (nextOffset != 0) {
            ++frames;
            try {
                readIn.seek(nextOffset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] byteArray = new byte[2];
            readIn.read(byteArray);
            int numEntries = LegacyTiffTools.batoi(byteArray);
            readIn.skipBytes(12 * numEntries);
            byteArray = new byte[4];
            readIn.read(byteArray);
            nextOffset = LegacyTiffTools.batoi(byteArray);
        }
        Vector entryData = (Vector)ifdEntries.get(new Integer(256));
        Integer width = (Integer)entryData.get(2);
        entryData = (Vector)ifdEntries.get(new Integer(257));
        Integer length = (Integer)entryData.get(2);
        return new int[]{width, length, frames};
    }

    public static int getIFDValue(Hashtable h2, int id) {
        Integer k = new Integer(id);
        Vector v = (Vector)h2.get(k);
        if (v == null) {
            return -1;
        }
        Integer i = (Integer)v.get(2);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static boolean isIFDArray(Hashtable h2, int id) {
        return LegacyTiffTools.getIFDValue(h2, id) == 1;
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile f = new RandomAccessFile(args[0], "r");
        Hashtable h2 = new Hashtable();
        int[] d = LegacyTiffTools.getTIFFDimensions(f);
        for (int meh = 0; meh < d[2]; ++meh) {
            System.out.println("*** START HASH #" + meh);
            h2 = LegacyTiffTools.getIFDHash(f, meh);
            for (int i = 0; i < 65536; ++i) {
                int j;
                Object[] a;
                Integer k = new Integer(i);
                if (!h2.containsKey(k)) continue;
                Vector v = (Vector)h2.get(k);
                System.out.print(k + ":");
                System.out.print((Integer)v.get(0) + " ");
                System.out.print((Integer)v.get(1) + " ");
                System.out.println((Integer)v.get(2));
                if ((Integer)v.get(1) == 1) continue;
                if ((Integer)v.get(1) != 5) {
                    a = LegacyTiffTools.getIFDArray(f, v);
                    System.out.print("  [ ");
                    for (j = 0; j < a.length; ++j) {
                        System.out.print(a[j] + " ");
                    }
                    System.out.println("]");
                    continue;
                }
                a = LegacyTiffTools.getIFDRArray(f, v);
                System.out.print("  [ ");
                for (j = 0; j < a.length; ++j) {
                    System.out.print(a[j] + " ");
                }
                System.out.println("]");
            }
            System.out.println("*** END HASH #" + meh);
            System.out.println(" ");
        }
        int[] a = LegacyTiffTools.getTIFFDimensions(f);
        System.out.println(a[0] + "x" + a[1] + "x" + a[2]);
    }
}

