/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.NameException;
import ucar.units.UnitID;

public final class UnitName
extends UnitID
implements Comparable<Object> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String plural;
    private final String symbol;

    protected UnitName(String name, String symbol) throws NameException {
        this(name, null, symbol);
    }

    protected UnitName(String name, String plural, String symbol) throws NameException {
        if (name == null) {
            throw new NameException("Unit name can't be null");
        }
        this.name = name;
        this.plural = plural == null ? this.makePlural(name) : plural;
        this.symbol = symbol;
    }

    public static UnitName newUnitName(String name) throws NameException {
        return UnitName.newUnitName(name, null);
    }

    public static UnitName newUnitName(String name, String plural) throws NameException {
        return UnitName.newUnitName(name, plural, null);
    }

    public static UnitName newUnitName(String name, String plural, String symbol) throws NameException {
        return new UnitName(name, plural, symbol);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public final String getSymbol() {
        return this.symbol;
    }

    @Override
    public final String toString() {
        String string = this.getSymbol();
        return string == null ? this.getName() : string;
    }

    @Override
    public final int compareTo(Object object) {
        return this.getName().compareToIgnoreCase(((UnitName)object).getName());
    }

    public final boolean equals(Object object) {
        return object instanceof UnitName && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getName().toLowerCase().hashCode();
    }

    protected String makePlural(String name) {
        char penultimateChar;
        int length = name.length();
        char lastChar = name.charAt(length - 1);
        String plural = lastChar != 'y' ? name + (lastChar == 's' || lastChar == 'x' || lastChar == 'z' || name.endsWith("ch") ? "es" : "s") : (length == 1 ? name + "s" : ((penultimateChar = name.charAt(length - 2)) == 'a' || penultimateChar == 'e' || penultimateChar == 'i' || penultimateChar == 'o' || penultimateChar == 'u' ? name + "s" : name.substring(0, length - 1) + "ies"));
        return plural;
    }
}

