/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.Immutable;
import ucar.units.Base;
import ucar.units.BaseQuantity;
import ucar.units.DerivedUnitImpl;
import ucar.units.NameException;
import ucar.units.UnitDimension;
import ucar.units.UnitExistsException;
import ucar.units.UnitName;

@Immutable
public class BaseUnit
extends DerivedUnitImpl
implements Base {
    private static final long serialVersionUID = 1L;
    private static final SortedMap<UnitName, BaseUnit> nameMap = new TreeMap<UnitName, BaseUnit>();
    private static final SortedMap<BaseQuantity, BaseUnit> quantityMap = new TreeMap<BaseQuantity, BaseUnit>();
    private final BaseQuantity baseQuantity;

    protected BaseUnit(UnitName id, BaseQuantity baseQuantity) throws NameException {
        super(id);
        if (id.getSymbol() == null) {
            throw new NameException("Base unit must have symbol");
        }
        this.setDimension(new UnitDimension(this));
        this.baseQuantity = baseQuantity;
    }

    public static synchronized BaseUnit getOrCreate(UnitName id, BaseQuantity baseQuantity) throws NameException, UnitExistsException {
        BaseUnit baseUnit;
        BaseUnit nameUnit = (BaseUnit)nameMap.get(id);
        BaseUnit quantityUnit = (BaseUnit)quantityMap.get(baseQuantity);
        if (nameUnit != null || quantityUnit != null) {
            BaseUnit baseUnit2 = baseUnit = nameUnit != null ? nameUnit : quantityUnit;
            if (nameUnit != null && !baseQuantity.equals(nameUnit.getBaseQuantity()) || quantityUnit != null && !id.equals(quantityUnit.getUnitName())) {
                throw new UnitExistsException("Attempt to incompatibly redefine base unit \"" + baseUnit + "\"");
            }
        } else {
            baseUnit = new BaseUnit(id, baseQuantity);
            quantityMap.put(baseQuantity, baseUnit);
            nameMap.put(id, baseUnit);
        }
        return baseUnit;
    }

    public final BaseQuantity getBaseQuantity() {
        return this.baseQuantity;
    }

    @Override
    public final String getID() {
        return this.getSymbol();
    }

    @Override
    public final String toString() {
        return this.getID();
    }

    @Override
    public boolean isDimensionless() {
        return this.baseQuantity.isDimensionless();
    }
}

